/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;

class CopyHandler
extends ResponseHandler {
    CopyHandler() {
    }

    public String getResponseID() {
        return "Copy-file";
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        String repositoryFile = session.readLine();
        String newFile = session.readLine();
        if (session.isNoLocalChanges() || !session.isCreateBackups()) {
            return;
        }
        String fileName = repositoryFile.substring(repositoryFile.lastIndexOf("/") + 1);
        ICVSFolder mParent = session.getLocalRoot().getFolder(localDir);
        ICVSFile mFile = mParent.getFile(fileName);
        Assert.isTrue((boolean)mParent.exists());
        Assert.isTrue((mFile.exists() && mFile.isManaged() ? 1 : 0) != 0);
        mFile.copyTo(newFile);
    }
}

