/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.TodoTaskInputDialog;
import org.eclipse.php.ui.preferences.IStatusChangeListener;
import org.eclipse.php.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.php.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.ui.util.PixelConverter;
import org.eclipse.php.ui.util.StatusInfo;
import org.eclipse.php.ui.wizards.fields.DialogField;
import org.eclipse.php.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.ui.wizards.fields.IListAdapter;
import org.eclipse.php.ui.wizards.fields.ListDialogField;
import org.eclipse.php.ui.wizards.fields.SelectionButtonDialogField;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class TodoTaskConfigurationBlock
extends PHPCoreOptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_TASK_TAGS = TodoTaskConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.taskTags");
    private static final OptionsConfigurationBlock.Key PREF_TASK_PRIORITIES = TodoTaskConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.taskPriorities");
    private static final OptionsConfigurationBlock.Key PREF_TASK_CASE_SENSITIVE = TodoTaskConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.taskCaseSensitive");
    private static final String PRIORITY_HIGH = "HIGH";
    private static final String PRIORITY_NORMAL = "NORMAL";
    private static final String PRIORITY_LOW = "LOW";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_DEFAULT = 4;
    private IStatus fTaskTagsStatus;
    private ListDialogField fTodoTasksList;
    private SelectionButtonDialogField fCaseSensitiveCheckBox;

    public TodoTaskConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, iProject, TodoTaskConfigurationBlock.getKeys(), iWorkbenchPreferenceContainer);
        TaskTagAdapter taskTagAdapter = new TaskTagAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = PHPUIMessages.TodoTaskConfigurationBlock_markers_tasks_add_button;
        stringArray[1] = PHPUIMessages.TodoTaskConfigurationBlock_markers_tasks_edit_button;
        stringArray[2] = PHPUIMessages.TodoTaskConfigurationBlock_markers_tasks_remove_button;
        stringArray[4] = PHPUIMessages.TodoTaskConfigurationBlock_markers_tasks_setdefault_button;
        String[] stringArray2 = stringArray;
        this.fTodoTasksList = new ListDialogField(taskTagAdapter, stringArray2, (ILabelProvider)new TodoTaskLabelProvider());
        this.fTodoTasksList.setDialogFieldListener(taskTagAdapter);
        this.fTodoTasksList.setRemoveButtonIndex(2);
        String[] stringArray3 = new String[]{PHPUIMessages.TodoTaskConfigurationBlock_markers_tasks_name_column, PHPUIMessages.TodoTaskConfigurationBlock_markers_tasks_priority_column};
        this.fTodoTasksList.setTableColumns(new ListDialogField.ColumnsDescription(stringArray3, true));
        this.fTodoTasksList.setViewerSorter(new TodoTaskSorter());
        this.fCaseSensitiveCheckBox = new SelectionButtonDialogField(32);
        this.fCaseSensitiveCheckBox.setLabelText(PHPUIMessages.TodoTaskConfigurationBlock_casesensitive_label);
        this.fCaseSensitiveCheckBox.setDialogFieldListener(taskTagAdapter);
        this.unpackTodoTasks();
        if (this.fTodoTasksList.getSize() > 0) {
            this.fTodoTasksList.selectFirstElement();
        } else {
            this.fTodoTasksList.enableButton(1, false);
            this.fTodoTasksList.enableButton(4, false);
        }
        this.fTaskTagsStatus = new StatusInfo();
    }

    public void setEnabled(boolean bl) {
        this.fTodoTasksList.setEnabled(bl);
        this.fCaseSensitiveCheckBox.setEnabled(bl);
    }

    final boolean isDefaultTask(TodoTask todoTask) {
        return this.fTodoTasksList.getIndexOfElement(todoTask) == 0;
    }

    private void setToDefaultTask(TodoTask todoTask) {
        List list = this.fTodoTasksList.getElements();
        list.remove(todoTask);
        list.add(0, todoTask);
        this.fTodoTasksList.setElements(list);
        this.fTodoTasksList.enableButton(4, false);
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_TASK_TAGS, PREF_TASK_PRIORITIES, PREF_TASK_CASE_SENSITIVE};
    }

    protected Control createContents(Composite composite) {
        this.setShell(composite.getShell());
        Composite composite2 = this.createMarkersTabContent(composite);
        this.validateSettings(null, null, null);
        return composite2;
    }

    private Composite createMarkersTabContent(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(composite.getFont());
        GridData gridData = new GridData(1808);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        Control control = this.fTodoTasksList.getListControl(composite2);
        control.setLayoutData((Object)gridData);
        Composite composite3 = this.fTodoTasksList.getButtonBox(composite2);
        composite3.setLayoutData((Object)new GridData(258));
        this.fCaseSensitiveCheckBox.doFillIntoGrid(composite2, 2);
        return composite2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key key, String string, String string2) {
        if (key != null) {
            if (!PREF_TASK_TAGS.equals(key)) return;
            this.fTaskTagsStatus = this.validateTaskTags();
        } else {
            this.fTaskTagsStatus = this.validateTaskTags();
        }
        IStatus iStatus = this.fTaskTagsStatus;
        this.fContext.statusChanged(iStatus);
    }

    private IStatus validateTaskTags() {
        return new StatusInfo();
    }

    protected final void updateModel(DialogField dialogField) {
        if (dialogField == this.fTodoTasksList) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            List list = this.fTodoTasksList.getElements();
            int n = 0;
            while (n < list.size()) {
                if (n > 0) {
                    stringBuffer.append(',');
                    stringBuffer2.append(',');
                }
                TodoTask todoTask = (TodoTask)list.get(n);
                stringBuffer.append(todoTask.name);
                stringBuffer2.append(todoTask.priority);
                ++n;
            }
            this.setValue(PREF_TASK_TAGS, stringBuffer.toString());
            this.setValue(PREF_TASK_PRIORITIES, stringBuffer2.toString());
            this.validateSettings(PREF_TASK_TAGS, null, null);
        } else if (dialogField == this.fCaseSensitiveCheckBox) {
            String string = this.fCaseSensitiveCheckBox.isSelected() ? ENABLED : DISABLED;
            this.setValue(PREF_TASK_CASE_SENSITIVE, string);
        }
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        String string = PHPUIMessages.TodoTaskConfigurationBlock_needsbuild_title;
        String string2 = this.fProject == null ? PHPUIMessages.TodoTaskConfigurationBlock_needsfullbuild_message : PHPUIMessages.TodoTaskConfigurationBlock_needsprojectbuild_message;
        return new String[]{string, string2};
    }

    protected void updateControls() {
        this.unpackTodoTasks();
    }

    private void unpackTodoTasks() {
        String string = this.getValue(PREF_TASK_TAGS);
        String string2 = this.getValue(PREF_TASK_PRIORITIES);
        String[] stringArray = this.getTokens(string, ",");
        String[] stringArray2 = this.getTokens(string2, ",");
        ArrayList<TodoTask> arrayList = new ArrayList<TodoTask>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            TodoTask todoTask = new TodoTask();
            todoTask.name = stringArray[n].trim();
            todoTask.priority = n < stringArray2.length ? stringArray2[n] : PRIORITY_NORMAL;
            arrayList.add(todoTask);
            ++n;
        }
        this.fTodoTasksList.setElements(arrayList);
        n = this.checkValue(PREF_TASK_CASE_SENSITIVE, ENABLED) ? 1 : 0;
        this.fCaseSensitiveCheckBox.setSelection(n != 0);
    }

    private void doTodoButtonPressed(int n) {
        TodoTask todoTask = null;
        if (n != 0) {
            todoTask = (TodoTask)this.fTodoTasksList.getSelectedElements().get(0);
        }
        if (n == 0 || n == 1) {
            TodoTaskInputDialog todoTaskInputDialog = new TodoTaskInputDialog(this.getShell(), todoTask, this.fTodoTasksList.getElements());
            if (todoTaskInputDialog.open() == 0) {
                if (todoTask != null) {
                    this.fTodoTasksList.replaceElement(todoTask, todoTaskInputDialog.getResult());
                } else {
                    this.fTodoTasksList.addElement(todoTaskInputDialog.getResult());
                }
            }
        } else if (n == 4) {
            this.setToDefaultTask(todoTask);
        }
    }

    public class TaskTagAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private boolean canEdit(List list) {
            return list.size() == 1;
        }

        private boolean canSetToDefault(List list) {
            return list.size() == 1 && !TodoTaskConfigurationBlock.this.isDefaultTask((TodoTask)list.get(0));
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            TodoTaskConfigurationBlock.this.doTodoButtonPressed(n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
            List list = listDialogField.getSelectedElements();
            listDialogField.enableButton(1, this.canEdit(list));
            listDialogField.enableButton(4, this.canSetToDefault(list));
        }

        public void doubleClicked(ListDialogField listDialogField) {
            if (this.canEdit(listDialogField.getSelectedElements())) {
                TodoTaskConfigurationBlock.this.doTodoButtonPressed(1);
            }
        }

        public void dialogFieldChanged(DialogField dialogField) {
            TodoTaskConfigurationBlock.this.updateModel(dialogField);
        }
    }

    public static class TodoTask {
        public String name;
        public String priority;
    }

    private class TodoTaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        public Image getImage(Object object) {
            return null;
        }

        public String getText(Object object) {
            return this.getColumnText(object, 0);
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            TodoTask todoTask = (TodoTask)object;
            if (n == 0) {
                String string = todoTask.name;
                if (TodoTaskConfigurationBlock.this.isDefaultTask(todoTask)) {
                    string = MessageFormat.format(PHPUIMessages.TodoTaskConfigurationBlock_tasks_default, string);
                }
                return string;
            }
            if (TodoTaskConfigurationBlock.PRIORITY_HIGH.equals(todoTask.priority)) {
                return PHPUIMessages.TodoTaskConfigurationBlock_markers_tasks_high_priority;
            }
            if (TodoTaskConfigurationBlock.PRIORITY_NORMAL.equals(todoTask.priority)) {
                return PHPUIMessages.TodoTaskConfigurationBlock_markers_tasks_normal_priority;
            }
            if (TodoTaskConfigurationBlock.PRIORITY_LOW.equals(todoTask.priority)) {
                return PHPUIMessages.TodoTaskConfigurationBlock_markers_tasks_low_priority;
            }
            return "";
        }

        public Font getFont(Object object) {
            if (TodoTaskConfigurationBlock.this.isDefaultTask((TodoTask)object)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }
    }

    private static class TodoTaskSorter
    extends ViewerSorter {
        private TodoTaskSorter() {
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            return this.collator.compare(((TodoTask)object).name, ((TodoTask)object2).name);
        }
    }
}

