/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;

public class StandardPHPElementContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    IPHPTreeContentProvider[] treeProviders;

    public StandardPHPElementContentProvider() {
        this(false);
    }

    public StandardPHPElementContentProvider(boolean bl) {
        this.fProvideMembers = bl;
    }

    public final Object[] getChildren(Object object) {
        Object[] objectArray = this.getChildrenInternal(object);
        if (this.treeProviders != null) {
            int n = 0;
            while (n < this.treeProviders.length) {
                Object[] objectArray2 = this.treeProviders[n].getChildren(object);
                if (objectArray2 != null && objectArray2.length > 0) {
                    objectArray = StandardPHPElementContentProvider.concatenate(objectArray, objectArray2);
                }
                ++n;
            }
        }
        return objectArray;
    }

    public void setTreeProviders(IPHPTreeContentProvider[] iPHPTreeContentProviderArray) {
        this.treeProviders = iPHPTreeContentProviderArray;
    }

    protected Object[] getChildrenInternal(Object object) {
        if (!this.exists(object)) {
            return NO_CHILDREN;
        }
        if (object instanceof PHPWorkspaceModelManager) {
            return this.getPHPProjects((PHPWorkspaceModelManager)object);
        }
        if (object instanceof IProject) {
            return this.getProjectChildren((IProject)object);
        }
        if (object instanceof PHPProjectModel) {
            return this.getProjectChildren((PHPProjectModel)object);
        }
        if (object instanceof IContainer) {
            return this.getFolderChildren((IContainer)object, null);
        }
        if (object instanceof IFile) {
            PHPFileData pHPFileData;
            IFile iFile = (IFile)object;
            PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iFile.getProject());
            if (pHPProjectModel != null && (pHPFileData = pHPProjectModel.getFileData(iFile.getFullPath().toString())) != null) {
                return this.getFileChildren(pHPFileData);
            }
        }
        if (object instanceof PHPFileData) {
            return this.getFileChildren((PHPFileData)object);
        }
        if (object instanceof PHPClassData) {
            return this.getClassChildren((PHPClassData)object);
        }
        return NO_CHILDREN;
    }

    private Object[] getFileChildren(PHPFileData pHPFileData) {
        PHPFunctionData[] pHPFunctionDataArray;
        PHPClassData[] pHPClassDataArray;
        PHPConstantData[] pHPConstantDataArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PHPIncludeFileData[] pHPIncludeFileDataArray = pHPFileData.getIncludeFiles();
        if (pHPIncludeFileDataArray != null) {
            int n = 0;
            while (n < pHPIncludeFileDataArray.length) {
                arrayList.add(pHPIncludeFileDataArray[n]);
                ++n;
            }
        }
        if ((pHPConstantDataArray = pHPFileData.getConstants()) != null) {
            int n = 0;
            while (n < pHPConstantDataArray.length) {
                arrayList.add(pHPConstantDataArray[n]);
                ++n;
            }
        }
        if ((pHPClassDataArray = pHPFileData.getClasses()) != null) {
            int n = 0;
            while (n < pHPClassDataArray.length) {
                arrayList.add(pHPClassDataArray[n]);
                ++n;
            }
        }
        if ((pHPFunctionDataArray = pHPFileData.getFunctions()) != null) {
            int n = 0;
            while (n < pHPFunctionDataArray.length) {
                arrayList.add(pHPFunctionDataArray[n]);
                ++n;
            }
        }
        return arrayList.toArray();
    }

    private Object[] getClassChildren(PHPClassData pHPClassData) {
        PHPClassConstData[] pHPClassConstDataArray;
        PHPClassVarData[] pHPClassVarDataArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PHPFunctionData[] pHPFunctionDataArray = pHPClassData.getFunctions();
        if (pHPFunctionDataArray != null) {
            int n = 0;
            while (n < pHPFunctionDataArray.length) {
                arrayList.add(pHPFunctionDataArray[n]);
                ++n;
            }
        }
        if ((pHPClassVarDataArray = pHPClassData.getVars()) != null) {
            int n = 0;
            while (n < pHPClassVarDataArray.length) {
                arrayList.add(pHPClassVarDataArray[n]);
                ++n;
            }
        }
        if ((pHPClassConstDataArray = pHPClassData.getConsts()) != null) {
            int n = 0;
            while (n < pHPClassConstDataArray.length) {
                arrayList.add(pHPClassConstDataArray[n]);
                ++n;
            }
        }
        return arrayList.toArray();
    }

    public final Object getParent(Object object) {
        if (!this.exists(object)) {
            return null;
        }
        return this.internalGetParent(object);
    }

    public final boolean hasChildren(Object object) {
        boolean bl = this.hasChildrenInternal(object);
        return bl;
    }

    protected boolean hasChildrenInternal(Object object) {
        Object[] objectArray;
        if (this.getProvideMembers()) {
            if (object instanceof PHPFileData) {
                return true;
            }
        } else if (object instanceof PHPFileData || object instanceof IFile) {
            return false;
        }
        if (object instanceof PHPProjectModel) {
            objectArray = (Object[])object;
            IProject iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)objectArray);
            if (!iProject.isOpen()) {
                return false;
            }
        }
        if (object instanceof PHPCodeData) {
            objectArray = (PHPCodeData)object;
            return PHPModelUtil.hasChildren((PHPCodeData)objectArray);
        }
        objectArray = this.getChildren(object);
        return objectArray != null && objectArray.length > 0;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (this.treeProviders != null) {
            int n = 0;
            while (n < this.treeProviders.length) {
                this.treeProviders[n].inputChanged(viewer, object, object2);
                ++n;
            }
        }
    }

    protected boolean exists(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IResource) {
            return ((IResource)object).exists();
        }
        return true;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    protected Object[] getPHPProjects(PHPWorkspaceModelManager pHPWorkspaceModelManager) {
        return pHPWorkspaceModelManager.listProjects();
    }

    protected Object[] getProjectChildren(PHPProjectModel pHPProjectModel) {
        IProject iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel(pHPProjectModel);
        return this.getProjectChildren(iProject);
    }

    protected Object[] getProjectChildren(PHPProjectModel pHPProjectModel, String[] stringArray) {
        IProject iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel(pHPProjectModel);
        return this.getProjectChildren(iProject, stringArray);
    }

    protected Object[] getProjectChildren(IProject iProject) {
        String[] stringArray = new String[]{};
        return this.getProjectChildren(iProject, stringArray);
    }

    protected Object[] getProjectChildren(IProject iProject, String[] stringArray) {
        if (!iProject.isOpen()) {
            return NO_CHILDREN;
        }
        Object[] objectArray = this.getFolderChildren((IContainer)iProject, stringArray);
        return objectArray;
    }

    protected boolean isProjectRoot(IContainer iContainer) {
        return iContainer instanceof IProject;
    }

    protected Object[] getFolderChildren(IContainer iContainer, String[] stringArray) {
        try {
            Object[] objectArray = iContainer.members();
            IProject iProject = iContainer.getProject();
            PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
            if (pHPProjectModel == null) {
                return objectArray;
            }
            if (!iProject.exists()) {
                return objectArray;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                boolean bl = false;
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].equals(object.getName())) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!bl) {
                    if (object instanceof IFolder) {
                        arrayList.add(object);
                    } else if (object instanceof IFile) {
                        arrayList2.add(objectArray[n]);
                    }
                }
                ++n;
            }
            arrayList.addAll(arrayList2);
            return arrayList.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    protected Object internalGetParent(Object object) {
        return PHPModelUtil.getParent((Object)object);
    }

    protected Object skipProjectRoot(IFolder iFolder) {
        if (this.isProjectRoot((IContainer)iFolder)) {
            return iFolder.getParent();
        }
        return iFolder;
    }

    protected static Object[] concatenate(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray2.length;
        Object[] objectArray3 = new Object[n + n2];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        return objectArray3;
    }

    protected boolean isSourceFolderEmpty(Object object) {
        if (object instanceof IFolder) {
            IFolder iFolder = (IFolder)object;
            try {
                if (iFolder.exists() && iFolder.members().length == 0) {
                    return true;
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        return false;
    }

    public void setProvideMembers(boolean bl) {
        this.fProvideMembers = bl;
    }
}

