/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.hover;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.Logger;
import org.eclipse.php.core.documentModel.PHPEditorModel;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.ui.util.CodeDataResolver;
import org.eclipse.php.ui.editor.hover.AbstractPHPTextHover;
import org.eclipse.php.ui.util.PHPCodeDataHTMLDescriptionUtilities;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class PHPAnnotationTextHover
extends AbstractPHPTextHover {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        IDocument iDocument = iTextViewer.getDocument();
        if (!(iDocument instanceof IStructuredDocument)) return null;
        try {
            String string;
            IStructuredDocument iStructuredDocument = (IStructuredDocument)iDocument;
            IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(iRegion.getOffset());
            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iRegion.getOffset());
            if (iStructuredDocumentRegion.getStartOffset() + iTextRegion.getTextEnd() < iRegion.getOffset()) return null;
            CodeData codeData = CodeDataResolver.getCodeData(iTextViewer, iStructuredDocumentRegion.getStartOffset() + iTextRegion.getTextEnd());
            if (codeData == null) return null;
            IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(iTextViewer.getDocument());
            if (!(iStructuredModel instanceof PHPEditorModel)) return null;
            try {
                PHPEditorModel pHPEditorModel = (PHPEditorModel)iStructuredModel;
                PHPProjectModel pHPProjectModel = pHPEditorModel.getProjectModel();
                string = PHPCodeDataHTMLDescriptionUtilities.getHTMLHyperlinkDescriptionText(codeData, pHPProjectModel);
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                iStructuredModel.releaseFromRead();
                throw throwable;
            }
            iStructuredModel.releaseFromRead();
            return string;
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
        return null;
    }
}

