/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.util.TreePath;
import org.eclipse.php.ui.explorer.ExplorerContentProvider;
import org.eclipse.php.ui.explorer.ExplorerPart;
import org.eclipse.php.ui.explorer.IMultiElementTreeContentProvider;
import org.eclipse.php.ui.workingset.WorkingSetModel;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetAwareContentProvider
extends ExplorerContentProvider
implements IMultiElementTreeContentProvider {
    private WorkingSetModel fWorkingSetModel;
    private IPropertyChangeListener fListener;

    public WorkingSetAwareContentProvider(ExplorerPart explorerPart, boolean bl, WorkingSetModel workingSetModel) {
        super(explorerPart, bl);
        this.fWorkingSetModel = workingSetModel;
        this.fListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WorkingSetAwareContentProvider.this.workingSetModelChanged(propertyChangeEvent);
            }
        };
        this.fWorkingSetModel.addPropertyChangeListener(this.fListener);
    }

    public void dispose() {
        this.fWorkingSetModel.removePropertyChangeListener(this.fListener);
        super.dispose();
    }

    public boolean hasChildrenInternal(Object object) {
        if (object instanceof IWorkingSet) {
            return true;
        }
        return super.hasChildrenInternal(object);
    }

    public Object[] getChildrenInternal(Object object) {
        if (object instanceof WorkingSetModel) {
            Assert.isTrue((this.fWorkingSetModel == object ? 1 : 0) != 0);
            return this.fWorkingSetModel.getActiveWorkingSets();
        }
        Object[] objectArray = object instanceof IWorkingSet ? this.filterClosedElements(this.fWorkingSetModel.getChildren((IWorkingSet)object)) : super.getChildrenInternal(object);
        return objectArray;
    }

    private Object[] filterClosedElements(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            IProject iProject;
            Object object = objectArray[n];
            boolean bl = false;
            if (object instanceof IProject) {
                bl = true;
            } else if (object instanceof IResource) {
                iProject = ((IResource)object).getProject();
                bl = iProject == null || iProject.isOpen();
            } else if (object instanceof PHPProjectModel) {
                bl = true;
            } else if (object instanceof PHPCodeData) {
                iProject = this.getProject((PHPCodeData)object);
                boolean bl2 = bl = iProject == null || iProject.isOpen();
            }
            if (bl) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private IProject getProject(PHPCodeData pHPCodeData) {
        if (pHPCodeData == null) {
            return null;
        }
        IResource iResource = PHPModelUtil.getResource((Object)pHPCodeData);
        if (iResource == null) {
            return null;
        }
        return iResource.getProject();
    }

    public TreePath[] getTreePaths(Object object) {
        if (object instanceof IWorkingSet) {
            TreePath treePath = new TreePath(new Object[]{object});
            return new TreePath[]{treePath};
        }
        List list = this.getModelPath(object);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            arrayList.addAll(this.getTreePaths(list, n));
            ++n;
        }
        return arrayList.toArray(new TreePath[arrayList.size()]);
    }

    private List getModelPath(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        Object object2 = super.getParent(object);
        Object object3 = this.getViewerInput();
        while (object2 != null && !object2.equals(object3) && !(object2 instanceof PHPWorkspaceModelManager)) {
            arrayList.add(object2);
            object2 = super.getParent(object2);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private List getTreePaths(List list, int n) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        Object object = this.getViewerInput();
        Object e = list.get(n);
        Object[] objectArray = this.fWorkingSetModel.getAllParents(e);
        int n2 = 0;
        while (n2 < objectArray.length) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (!objectArray[n2].equals(object)) {
                arrayList2.add(objectArray[n2]);
            }
            int n3 = n;
            while (n3 < list.size()) {
                arrayList2.add(list.get(n3));
                ++n3;
            }
            arrayList.add(new TreePath(arrayList2.toArray()));
            ++n2;
        }
        return arrayList;
    }

    public Object internalGetParent(Object object) {
        Object[] objectArray = this.fWorkingSetModel.getAllParents(object);
        if (objectArray.length == 0) {
            return super.internalGetParent(object);
        }
        Object object2 = objectArray[0];
        if (object2 instanceof IWorkingSet && "org.eclipse.php.ui.HistoryWorkingSet".equals(((IWorkingSet)object2).getId())) {
            if (objectArray.length > 1) {
                return objectArray[1];
            }
            return super.internalGetParent(object);
        }
        return object2;
    }

    protected void augmentElementToRefresh(List list, int n, Object object) {
        Object object2;
        if (PHPWorkspaceModelManager.getInstance().equals(object)) {
            list.remove(object);
            list.add(this.fWorkingSetModel);
        } else if (n == 2 && (object2 = this.internalGetParent(object)) != null) {
            list.addAll(Arrays.asList(this.fWorkingSetModel.getAllParents(object2)));
        }
    }

    private void workingSetModelChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        Object object = propertyChangeEvent.getNewValue();
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        if ("workingSetModelChanged".equals(string)) {
            arrayList.add(this.fWorkingSetModel);
        } else if ("workingSetContentChange".equals(string)) {
            arrayList.add(object);
        } else if ("workingSetNameChange".equals(string)) {
            arrayList.add(object);
        }
        this.postRefresh(arrayList, true);
    }
}

