/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.outline;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.core.documentModel.PHPEditorModel;
import org.eclipse.php.core.documentModel.dom.PHPElementImpl;
import org.eclipse.php.core.phpModel.parser.ModelListener;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.StandardPHPElementContentProvider;
import org.eclipse.php.ui.outline.PHPOutlineLabelProvider;
import org.eclipse.php.ui.treecontent.PHPTreeNode;
import org.eclipse.php.ui.util.PHPPluginImages;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;

public class PHPOutlineContentProvider
extends JFaceNodeContentProvider
implements ModelListener {
    private static final Image CLASSES_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_CLASSES_GROUP.createImage();
    private static final Image CONSTANTS_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP.createImage();
    private static final Image FUNCTIONS_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_FUNCTIONS_GROUP.createImage();
    public static final int GROUP_INCLUDES = 1;
    public static final int GROUP_CONSTANTS = 2;
    public static final int GROUP_CLASSES = 3;
    public static final int GROUP_FUNCTIONS = 4;
    private static final Image INCLUDES_GROUP_IMAGE = PHPPluginImages.DESC_OBJS_INCLUDE.createImage();
    public static final int MODE_HTML = 2;
    public static final int MODE_MIXED = 3;
    public static final int MODE_PHP = 1;
    private ISelectionListener fSelectionListener = null;
    PHPEditorModel editorModel;
    GroupNode[] groupNodes;
    int mode;
    StandardPHPElementContentProvider phpContentProvider = new StandardPHPElementContentProvider(true);
    boolean showGroups;
    TreeViewer viewer;
    private PHPOutlineLabelProvider labelProvider;
    static /* synthetic */ Class class$0;

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        if (object == null && object2 != null) {
            PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
            this.postRefresh(object2, true);
        } else if (object != null && object2 == null) {
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
            this.postRefresh(true);
        }
    }

    public void dispose() {
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        PHPUiPlugin.getActiveWorkbenchWindow().getSelectionService().removePostSelectionListener(this.getSelectionServiceListener());
        super.dispose();
    }

    public void dataCleared() {
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        if (this.editorModel != null && this.editorModel.getFileData() != null && this.editorModel.getFileData().getComparableName().equals(pHPFileData.getComparableName())) {
            this.postRefresh(true);
        }
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        if (this.editorModel != null && this.editorModel.getFileData() != null && this.editorModel.getFileData().getComparableName().equals(pHPFileData.getComparableName())) {
            if (this.groupNodes == null) {
                this.postRefresh(true);
            } else {
                int n = 0;
                while (n < this.groupNodes.length) {
                    this.groupNodes[n].reset(pHPFileData);
                    this.postRefresh(this.groupNodes[n], true);
                    ++n;
                }
            }
        }
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
    }

    private void postRefresh(final Object object, final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (PHPOutlineContentProvider.this.viewer == null) {
                    return;
                }
                Control control = PHPOutlineContentProvider.this.viewer.getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                if (object == null) {
                    PHPOutlineContentProvider.this.viewer.refresh(bl);
                } else {
                    PHPOutlineContentProvider.this.viewer.refresh(object, bl);
                }
                if (object instanceof PHPEditorModel) {
                    PHPOutlineContentProvider.this.viewer.expandAll();
                }
            }
        };
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(runnable);
        }
    }

    private void postRefresh(boolean bl) {
        this.postRefresh(null, bl);
    }

    public PHPOutlineContentProvider(TreeViewer treeViewer, PHPOutlineLabelProvider pHPOutlineLabelProvider) {
        this.viewer = treeViewer;
        this.labelProvider = pHPOutlineLabelProvider;
        this.mode = PHPUiPlugin.getDefault().getPreferenceStore().getInt("ChangeOutlineModeAction.selectedMode");
        if (this.mode == 0) {
            this.mode = 1;
            PHPUiPlugin.getDefault().getPreferenceStore().setValue("ChangeOutlineModeAction.selectedMode", this.mode);
        }
        this.showGroups = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("ShowGroupsAction.show");
        PHPUiPlugin.getActiveWorkbenchWindow().getSelectionService().addPostSelectionListener(this.getSelectionServiceListener());
        this.registerMouseTrackListener();
    }

    private void registerMouseTrackListener() {
        final Tree tree = this.viewer.getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent mouseEvent) {
                Object object;
                TreeItem treeItem = tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (treeItem != null && (object = treeItem.getData()) instanceof PHPCodeData) {
                    tree.setToolTipText(PHPOutlineContentProvider.this.labelProvider.getTooltipText(object));
                }
            }
        });
    }

    public Object[] getChildren(Object object) {
        if (object instanceof PHPElementImpl && this.mode == 3) {
            return this.getPHPChildren((PHPElementImpl)object);
        }
        if (object instanceof PHPCodeData) {
            return this.phpContentProvider.getChildren(object);
        }
        if (object instanceof PHPEditorModel && this.mode == 1) {
            Object[] objectArray;
            this.editorModel = (PHPEditorModel)object;
            IDOMDocument iDOMDocument = this.editorModel.getDocument();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iDOMDocument.getAdapterFor((Object)clazz);
            PHPFileData pHPFileData = this.editorModel.getFileData();
            if (pHPFileData != null && (objectArray = this.getGroupNodes(pHPFileData)) != null) {
                return objectArray;
            }
            return this.getChildren(pHPFileData);
        }
        if (object instanceof GroupNode) {
            return ((GroupNode)object).getChildren();
        }
        if (object instanceof PHPTreeNode) {
            return ((PHPTreeNode)object).getChildren();
        }
        return super.getChildren(object);
    }

    public Object[] getElements(Object object) {
        if (object instanceof PHPElementImpl && this.mode == 3) {
            return this.getPHPChildren((PHPElementImpl)object);
        }
        if (object instanceof PHPCodeData) {
            return this.phpContentProvider.getChildren(object);
        }
        if (object instanceof PHPEditorModel && this.mode == 1) {
            this.editorModel = (PHPEditorModel)object;
            IDOMDocument iDOMDocument = this.editorModel.getDocument();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iDOMDocument.getAdapterFor((Object)clazz);
            PHPFileData pHPFileData = this.editorModel.getFileData();
            Object[] objectArray = this.getGroupNodes(pHPFileData);
            if (objectArray != null) {
                return objectArray;
            }
            return this.getElements(pHPFileData);
        }
        return super.getElements(object);
    }

    GroupNode[] getGroupNodes(PHPFileData pHPFileData) {
        if (this.showGroups) {
            if (this.groupNodes != null) {
                int n = 0;
                while (n < this.groupNodes.length) {
                    this.groupNodes[n].setFileData(pHPFileData);
                    ++n;
                }
            } else {
                this.groupNodes = new GroupNode[]{new GroupNode(1, "include files", pHPFileData), new GroupNode(2, "constants", pHPFileData), new GroupNode(3, "classes", pHPFileData), new GroupNode(4, "functions", pHPFileData)};
            }
        } else {
            this.groupNodes = null;
        }
        return this.groupNodes;
    }

    public int getMode() {
        return this.mode;
    }

    public Object getParent(Object object) {
        if (object instanceof PHPCodeData) {
            PHPCodeData pHPCodeData = (PHPCodeData)object;
            PHPCodeData pHPCodeData2 = pHPCodeData.getContainer();
            if (pHPCodeData2 instanceof PHPFileData && this.showGroups) {
                int n = 0;
                while (n < this.groupNodes.length) {
                    Object[] objectArray = this.groupNodes[n].getChildren();
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        if (objectArray[n2] == object) {
                            return this.groupNodes[n];
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else {
                return pHPCodeData2;
            }
        }
        return super.getParent(object);
    }

    private Object[] getPHPChildren(PHPElementImpl pHPElementImpl) {
        String string = pHPElementImpl.getModel().getBaseLocation();
        int n = pHPElementImpl.getStartOffset();
        int n2 = pHPElementImpl.getEndOffset();
        PHPFileData pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(string);
        return this.getPHPChildren((PHPCodeData)pHPFileData, n, n2);
    }

    private Object[] getPHPChildren(PHPCodeData pHPCodeData) {
        return this.phpContentProvider.getChildren(pHPCodeData);
    }

    private Object[] getPHPChildren(PHPCodeData pHPCodeData, int n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (pHPCodeData == null) {
            return new Object[0];
        }
        Object[] objectArray = this.getPHPChildren(pHPCodeData);
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] instanceof PHPCodeData && this.isInside(n, n2, (PHPCodeData)objectArray[n3])) {
                arrayList.add(objectArray[n3]);
            }
            ++n3;
        }
        return arrayList.toArray();
    }

    private ISelectionListener getSelectionServiceListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new PostSelectionServiceListener();
        }
        return this.fSelectionListener;
    }

    public boolean getShowGroups() {
        return this.showGroups;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof PHPElementImpl) {
            Object[] objectArray = this.getPHPChildren((PHPElementImpl)object);
            return objectArray.length > 0;
        }
        if (object instanceof PHPCodeData) {
            Object[] objectArray = this.getPHPChildren((PHPCodeData)object);
            return objectArray.length > 0;
        }
        if (object instanceof GroupNode) {
            return ((GroupNode)object).hasChildren();
        }
        if (object instanceof PHPTreeNode) {
            return ((PHPTreeNode)object).hasChildren();
        }
        return super.hasChildren(object);
    }

    boolean isInside(int n, int n2, PHPCodeData pHPCodeData) {
        UserData userData = pHPCodeData.getUserData();
        if (userData == null) {
            return false;
        }
        return n <= userData.getStartPosition() && n2 >= userData.getEndPosition();
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setShowGroups(boolean bl) {
        this.showGroups = bl;
        this.postRefresh(true);
    }

    public static class GroupNode
    implements Comparable {
        Object[] children;
        PHPFileData fileData;
        String text;
        int type;

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            if (object instanceof GroupNode) {
                GroupNode groupNode = (GroupNode)object;
                return this.type - groupNode.type;
            }
            return 0;
        }

        public void setFileData(PHPFileData pHPFileData) {
            this.fileData = pHPFileData;
            this.loadChildren();
        }

        GroupNode(int n, String string, PHPFileData pHPFileData) {
            this.type = n;
            this.text = string;
            this.fileData = pHPFileData;
        }

        public Object[] getChildren() {
            if (this.children == null) {
                this.loadChildren();
            }
            return this.children;
        }

        public void reset(PHPFileData pHPFileData) {
            this.fileData = pHPFileData;
            this.children = null;
        }

        public Image getImage() {
            switch (this.type) {
                case 3: {
                    return CLASSES_GROUP_IMAGE;
                }
                case 4: {
                    return FUNCTIONS_GROUP_IMAGE;
                }
                case 2: {
                    return CONSTANTS_GROUP_IMAGE;
                }
                case 1: {
                    return INCLUDES_GROUP_IMAGE;
                }
            }
            return null;
        }

        public String getText() {
            return this.text;
        }

        public boolean hasChildren() {
            if (this.children == null) {
                this.loadChildren();
            }
            return this.children.length > 0;
        }

        void loadChildren() {
            if (this.fileData != null) {
                switch (this.type) {
                    case 3: {
                        this.children = this.fileData.getClasses();
                        break;
                    }
                    case 4: {
                        this.children = this.fileData.getFunctions();
                        break;
                    }
                    case 2: {
                        this.children = this.fileData.getConstants();
                        break;
                    }
                    case 1: {
                        this.children = this.fileData.getIncludeFiles();
                    }
                }
            }
            if (this.children == null) {
                this.children = new Object[0];
            }
        }
    }

    private class PostSelectionServiceListener
    implements ISelectionListener {
        private PostSelectionServiceListener() {
        }

        public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        }
    }
}

