/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.ui.preferences.includepath.VariablePathDialogField;
import org.eclipse.php.ui.preferences.includepath.ZipFileSelectionDialog;
import org.eclipse.php.ui.wizards.fields.DialogField;
import org.eclipse.php.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.ui.wizards.fields.LayoutUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EditVariableEntryDialog
extends StatusDialog {
    private IPath fFileVariablePath;
    private IStatus fNameStatus;
    private Set fExistingEntries;
    private VariablePathDialogField fFileNameField;
    private CLabel fFullPathResolvedLabel;

    public EditVariableEntryDialog(Shell shell, IPath iPath, IPath[] iPathArray) {
        super(shell);
        Object object;
        this.setTitle(PHPUIMessages.EditVariableEntryDialog_title);
        this.fExistingEntries = new HashSet();
        if (iPathArray != null) {
            int n = 0;
            while (n < iPathArray.length) {
                object = iPathArray[n];
                if (!object.equals((Object)iPath)) {
                    this.fExistingEntries.add(object);
                }
                ++n;
            }
        }
        SourceAttachmentAdapter sourceAttachmentAdapter = new SourceAttachmentAdapter();
        this.fFileNameField = new VariablePathDialogField(sourceAttachmentAdapter);
        this.fFileNameField.setDialogFieldListener(sourceAttachmentAdapter);
        this.fFileNameField.setLabelText(PHPUIMessages.EditVariableEntryDialog_filename_varlabel);
        this.fFileNameField.setButtonLabel(PHPUIMessages.EditVariableEntryDialog_filename_external_varbutton);
        this.fFileNameField.setVariableButtonLabel(PHPUIMessages.EditVariableEntryDialog_filename_variable_button);
        object = iPath != null ? iPath.toString() : "";
        this.fFileNameField.setText((String)object);
    }

    public IPath getPath() {
        return Path.fromOSString((String)this.fFileNameField.getText());
    }

    protected Control createDialogArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 3;
        int n = this.convertWidthInCharsToPixels(50);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        this.fFileNameField.doFillIntoGrid(composite2, 4);
        LayoutUtil.setHorizontalSpan((Control)this.fFileNameField.getLabelControl(null), 3);
        LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), n);
        LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
        this.fFullPathResolvedLabel = new CLabel(composite2, 16384);
        this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
        this.fFullPathResolvedLabel.setLayoutData((Object)new GridData(256));
        DialogField.createEmptySpace(composite2, 2);
        this.fFileNameField.postSetFocusOnDialogField(composite.getDisplay());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.php.ui.source_attachment_context");
        EditVariableEntryDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void attachmentChangeControlPressed(DialogField dialogField) {
        IPath iPath;
        if (dialogField == this.fFileNameField && (iPath = this.chooseExtZipFile()) != null) {
            this.fFileNameField.setText(iPath.toString());
        }
    }

    private void attachmentDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fFileNameField) {
            this.fNameStatus = this.updateFileNameStatus();
        }
        this.doStatusLineUpdate();
    }

    private IPath chooseExtZipFile() {
        IPath iPath = this.getPath();
        IPath iPath2 = this.getResolvedPath(iPath);
        File file = iPath2 != null ? iPath2.toFile() : null;
        String string = iPath.segment(0);
        ZipFileSelectionDialog zipFileSelectionDialog = new ZipFileSelectionDialog(this.getShell(), false, false);
        zipFileSelectionDialog.setTitle(PHPUIMessages.EditVariableEntryDialog_extvardialog_title);
        zipFileSelectionDialog.setMessage(PHPUIMessages.EditVariableEntryDialog_extvardialog_description);
        zipFileSelectionDialog.setInput(this.fFileVariablePath.toFile());
        zipFileSelectionDialog.setInitialSelection(file);
        if (zipFileSelectionDialog.open() == 0) {
            File file2 = (File)zipFileSelectionDialog.getResult()[0];
            IPath iPath3 = Path.fromOSString((String)file2.getPath()).makeAbsolute();
            return this.modifyPath(iPath3, string);
        }
        return null;
    }

    private IPath getResolvedPath(IPath iPath) {
        IPath iPath2;
        String string;
        if (iPath != null && (string = iPath.segment(0)) != null && (iPath2 = PHPProjectOptions.getIncludePathVariable((String)string)) != null) {
            return iPath2.append(iPath.removeFirstSegments(1));
        }
        return null;
    }

    private IPath modifyPath(IPath object, String string) {
        if (string == null || object == null) {
            return null;
        }
        if (object.isEmpty()) {
            return new Path(string);
        }
        IPath iPath = PHPProjectOptions.getIncludePathVariable((String)string);
        object = iPath != null ? (iPath.isPrefixOf(object) ? object.removeFirstSegments(iPath.segmentCount()) : new Path(object.lastSegment())) : new Path(object.lastSegment());
        return new Path(string).append(object);
    }

    private IStatus updateFileNameStatus() {
        StatusInfo statusInfo = new StatusInfo();
        this.fFileVariablePath = null;
        String string = this.fFileNameField.getText();
        if (string.length() == 0) {
            statusInfo.setError(PHPUIMessages.EditVariableEntryDialog_filename_empty);
            return statusInfo;
        }
        if (!Path.EMPTY.isValidPath(string)) {
            statusInfo.setError(PHPUIMessages.EditVariableEntryDialog_filename_error_notvalid);
            return statusInfo;
        }
        IPath iPath = Path.fromOSString((String)string);
        if (iPath.getDevice() != null) {
            statusInfo.setError(PHPUIMessages.EditVariableEntryDialog_filename_error_deviceinpath);
            return statusInfo;
        }
        String string2 = iPath.segment(0);
        if (string2 == null) {
            statusInfo.setError(PHPUIMessages.EditVariableEntryDialog_filename_error_notvalid);
            return statusInfo;
        }
        this.fFileVariablePath = PHPProjectOptions.getIncludePathVariable((String)string2);
        if (this.fFileVariablePath == null) {
            statusInfo.setError(PHPUIMessages.EditVariableEntryDialog_filename_error_varnotexists);
            return statusInfo;
        }
        IPath iPath2 = this.fFileVariablePath.append(iPath.removeFirstSegments(1));
        if (iPath2.isEmpty()) {
            statusInfo.setWarning(PHPUIMessages.EditVariableEntryDialog_filename_warning_varempty);
            return statusInfo;
        }
        File file = iPath2.toFile();
        if (!file.isFile()) {
            String string3 = MessageFormat.format(PHPUIMessages.EditVariableEntryDialog_filename_error_filenotexists, iPath2.toOSString());
            statusInfo.setInfo(string3);
            return statusInfo;
        }
        return statusInfo;
    }

    private String getResolvedLabelString() {
        IPath iPath = this.getResolvedPath(this.getPath());
        if (iPath != null) {
            return iPath.toOSString();
        }
        return "";
    }

    private boolean canBrowseFileName() {
        if (this.fFileVariablePath != null) {
            return this.fFileVariablePath.toFile().isDirectory();
        }
        return false;
    }

    private void doStatusLineUpdate() {
        IPath iPath;
        IStatus iStatus;
        this.fFileNameField.enableButton(this.canBrowseFileName());
        if (this.fFullPathResolvedLabel != null) {
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
        }
        if (!(iStatus = this.fNameStatus).matches(4) && this.fExistingEntries.contains(iPath = this.getPath())) {
            String string = PHPUIMessages.EditVariableEntryDialog_filename_error_alreadyexists;
            iStatus = new StatusInfo(4, string);
        }
        this.updateStatus(iStatus);
    }

    private class SourceAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceAttachmentAdapter() {
        }

        public void changeControlPressed(DialogField dialogField) {
            EditVariableEntryDialog.this.attachmentChangeControlPressed(dialogField);
        }

        public void dialogFieldChanged(DialogField dialogField) {
            EditVariableEntryDialog.this.attachmentDialogFieldChanged(dialogField);
        }
    }
}

