/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.includepath.ZipFileFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ZipFileSelectionDialog
extends ElementTreeSelectionDialog {
    public ZipFileSelectionDialog(Shell shell, boolean bl, boolean bl2) {
        super(shell, (ILabelProvider)new FileLabelProvider(), (ITreeContentProvider)new FileContentProvider());
        this.setSorter(new FileViewerSorter());
        this.addFilter(new FileArchiveFileFilter());
        this.setValidator(new FileSelectionValidator(bl, bl2));
    }

    private static boolean isArchive(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return n != -1 && ZipFileFilter.isArchiveFileExtension(string.substring(n + 1));
    }

    private static class FileArchiveFileFilter
    extends ViewerFilter {
        private FileArchiveFileFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof File) {
                File file = (File)object2;
                if (file.isFile()) {
                    return ZipFileSelectionDialog.isArchive(file);
                }
                return true;
            }
            return false;
        }
    }

    private static class FileContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTY = new Object[0];

        private FileContentProvider() {
        }

        public Object[] getChildren(Object object) {
            Object[] objectArray;
            if (object instanceof File && (objectArray = ((File)object).listFiles()) != null) {
                return objectArray;
            }
            return this.EMPTY;
        }

        public Object getParent(Object object) {
            if (object instanceof File) {
                return ((File)object).getParentFile();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class FileLabelProvider
    extends LabelProvider {
        private final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private final Image IMG_ZIP = PHPUiPlugin.getDefault().getImageRegistry().get("org.eclipse.php.ui.zip_l_obj.gif");

        private FileLabelProvider() {
        }

        public Image getImage(Object object) {
            if (object instanceof File) {
                File file = (File)object;
                if (file.isDirectory()) {
                    return this.IMG_FOLDER;
                }
                return this.IMG_ZIP;
            }
            return null;
        }

        public String getText(Object object) {
            if (object instanceof File) {
                return ((File)object).getName();
            }
            return super.getText(object);
        }
    }

    private static class FileSelectionValidator
    implements ISelectionStatusValidator {
        private boolean fMultiSelect;
        private boolean fAcceptFolders;

        public FileSelectionValidator(boolean bl, boolean bl2) {
            this.fMultiSelect = bl;
            this.fAcceptFolders = bl2;
        }

        public IStatus validate(Object[] objectArray) {
            int n = objectArray.length;
            if (n == 0 || n > 1 && !this.fMultiSelect) {
                return new StatusInfo(4, "");
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object object = objectArray[n2];
                if (object instanceof File) {
                    File file = (File)object;
                    if (!this.fAcceptFolders && !file.isFile()) {
                        return new StatusInfo(4, "");
                    }
                }
                ++n2;
            }
            return new StatusInfo();
        }
    }

    private static class FileViewerSorter
    extends ViewerSorter {
        private FileViewerSorter() {
        }

        public int category(Object object) {
            if (object instanceof File && ((File)object).isFile()) {
                return 1;
            }
            return 0;
        }
    }
}

