/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.ui;

import java.io.Reader;
import java.util.Enumeration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.ui.util.PHPColorHelper;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.ui.StyledTextColorPicker;

public class PHPStyledTextColorPicker
extends StyledTextColorPicker {
    protected IStructuredDocumentRegion fNodes = null;
    protected IPreferenceStore fPreferenceStore;
    protected Button fUnderline;
    protected SelectionListener buttonListener;

    public PHPStyledTextColorPicker(Composite composite, int n) {
        super(composite, n);
    }

    protected RGB changeColor(RGB rGB) {
        ColorDialog colorDialog = new ColorDialog(this.getShell());
        if (rGB != null) {
            colorDialog.setRGB(rGB);
        }
        colorDialog.open();
        RGB rGB2 = colorDialog.getRGB();
        if (rGB2 != null) {
            return rGB2;
        }
        return rGB;
    }

    protected String changeColor(String string) {
        String string2 = "null";
        RGB rGB = this.changeColor(PHPColorHelper.toRGB((String)string));
        if (rGB != null) {
            string2 = PHPColorHelper.toRGBString((RGB)rGB);
        }
        return string2;
    }

    protected SelectionListener initButtonListener() {
        if (this.buttonListener != null) {
            return this.buttonListener;
        }
        this.buttonListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = PHPStyledTextColorPicker.this.getStyleName(PHPStyledTextColorPicker.this.fStyleCombo.getItem(PHPStyledTextColorPicker.this.fStyleCombo.getSelectionIndex()));
                if (string != null) {
                    if (selectionEvent.widget == PHPStyledTextColorPicker.this.fForeground) {
                        String string2;
                        String string3;
                        String string4 = PHPStyledTextColorPicker.this.getPreferenceStore().getString(string);
                        String[] stringArray = PHPColorHelper.unpackStylePreferences(string4);
                        if (stringArray != null && !(string3 = PHPStyledTextColorPicker.this.changeColor(string2 = stringArray[0])).equals(string2)) {
                            stringArray[0] = string3;
                            String string5 = PHPColorHelper.packStylePreferences(stringArray);
                            PHPStyledTextColorPicker.this.getPreferenceStore().setValue(string, string5);
                            PHPStyledTextColorPicker.this.refresh();
                        }
                    } else if (selectionEvent.widget == PHPStyledTextColorPicker.this.fBackground) {
                        String string6;
                        String string7;
                        String string8 = PHPStyledTextColorPicker.this.getPreferenceStore().getString(string);
                        String[] stringArray = PHPColorHelper.unpackStylePreferences(string8);
                        if (stringArray != null && !(string7 = PHPStyledTextColorPicker.this.changeColor(string6 = stringArray[1])).equals(string6)) {
                            stringArray[1] = string7;
                            String string9 = PHPColorHelper.packStylePreferences(stringArray);
                            PHPStyledTextColorPicker.this.getPreferenceStore().setValue(string, string9);
                            PHPStyledTextColorPicker.this.refresh();
                        }
                    } else if (selectionEvent.widget == PHPStyledTextColorPicker.this.fBold) {
                        String string10 = PHPStyledTextColorPicker.this.getPreferenceStore().getString(string);
                        String[] stringArray = PHPColorHelper.unpackStylePreferences(string10);
                        if (stringArray != null) {
                            String string11 = stringArray[2];
                            String string12 = String.valueOf(PHPStyledTextColorPicker.this.fBold.getSelection());
                            if (!string12.equals(string11)) {
                                stringArray[2] = string12;
                                String string13 = PHPColorHelper.packStylePreferences(stringArray);
                                PHPStyledTextColorPicker.this.getPreferenceStore().setValue(string, string13);
                                PHPStyledTextColorPicker.this.refresh();
                            }
                        }
                    } else if (selectionEvent.widget == PHPStyledTextColorPicker.this.fItalic) {
                        String string14 = PHPStyledTextColorPicker.this.getPreferenceStore().getString(string);
                        String[] stringArray = PHPColorHelper.unpackStylePreferences(string14);
                        if (stringArray != null) {
                            String string15 = stringArray[3];
                            String string16 = String.valueOf(PHPStyledTextColorPicker.this.fItalic.getSelection());
                            if (!string16.equals(string15)) {
                                stringArray[3] = string16;
                                String string17 = PHPColorHelper.packStylePreferences(stringArray);
                                PHPStyledTextColorPicker.this.getPreferenceStore().setValue(string, string17);
                                PHPStyledTextColorPicker.this.refresh();
                            }
                        }
                    } else if (selectionEvent.widget == PHPStyledTextColorPicker.this.fUnderline) {
                        String string18 = PHPStyledTextColorPicker.this.getPreferenceStore().getString(string);
                        String[] stringArray = PHPColorHelper.unpackStylePreferences(string18);
                        if (stringArray != null) {
                            String string19 = stringArray[4];
                            String string20 = String.valueOf(PHPStyledTextColorPicker.this.fUnderline.getSelection());
                            if (!string20.equals(string19)) {
                                stringArray[4] = string20;
                                String string21 = PHPColorHelper.packStylePreferences(stringArray);
                                PHPStyledTextColorPicker.this.getPreferenceStore().setValue(string, string21);
                                PHPStyledTextColorPicker.this.refresh();
                            }
                        }
                    } else if (selectionEvent.widget == PHPStyledTextColorPicker.this.fClearStyle) {
                        PHPStyledTextColorPicker.this.getPreferenceStore().setToDefault(string);
                        PHPStyledTextColorPicker.this.refresh();
                    }
                }
            }
        };
        return this.buttonListener;
    }

    protected String getStyleName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        Enumeration enumeration = this.getDescriptions().keys();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement().toString();
            if (!this.getDescriptions().get(string3).equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    protected void activate(String string) {
        super.activate(string);
        if (string == null) {
            this.fItalic.setEnabled(false);
            this.fUnderline.setEnabled(false);
        } else {
            this.fItalic.setEnabled(true);
            this.fUnderline.setEnabled(true);
        }
        TextAttribute textAttribute = this.getAttribute(string);
        this.fItalic.setSelection((textAttribute.getStyle() & 2) != 0);
        this.fUnderline.setSelection((textAttribute.getStyle() & 0x40000000) != 0);
    }

    protected Button createCheckBox(Composite composite, String string) {
        Button button = new Button(composite, 0x1000020);
        if (string != null) {
            button.setText(string);
        }
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = 128;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected void createControls(Composite composite) {
        super.createControls(composite);
        this.initButtonListener();
        this.fForeground.removeSelectionListener(((StyledTextColorPicker)this).buttonListener);
        this.fBackground.removeSelectionListener(((StyledTextColorPicker)this).buttonListener);
        this.fClearStyle.removeSelectionListener(((StyledTextColorPicker)this).buttonListener);
        this.fBold.removeSelectionListener(((StyledTextColorPicker)this).buttonListener);
        this.fForeground.addSelectionListener(this.buttonListener);
        this.fBackground.addSelectionListener(this.buttonListener);
        this.fClearStyle.addSelectionListener(this.buttonListener);
        this.fBold.addSelectionListener(this.buttonListener);
        Composite composite2 = this.fBold.getParent();
        ++((GridLayout)composite2.getLayout()).numColumns;
        this.fItalic = this.createCheckBox(composite2, SSEUIMessages.Italics_UI);
        this.fItalic.setEnabled(false);
        this.fItalic.addSelectionListener(this.buttonListener);
        ++((GridLayout)composite2.getLayout()).numColumns;
        this.fUnderline = this.createCheckBox(composite2, PHPUIMessages.ColorPage_Underline);
        this.fUnderline.setEnabled(false);
        this.fUnderline.addSelectionListener(this.buttonListener);
    }

    protected TextAttribute getAttribute(String string) {
        String string2;
        String[] stringArray;
        TextAttribute textAttribute = new TextAttribute(this.getDefaultForeground(), this.getDefaultBackground(), 0);
        if (string != null && this.getPreferenceStore() != null && (stringArray = PHPColorHelper.unpackStylePreferences(string2 = this.getPreferenceStore().getString(string))) != null) {
            textAttribute = PHPColorHelper.createTextAttribute(stringArray);
        }
        return textAttribute;
    }

    protected void applyStyles() {
        if (this.fText == null || this.fText.isDisposed() || this.fInput == null || this.fInput.length() == 0) {
            return;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = this.fNodes;
        while (iStructuredDocumentRegion != null) {
            ITextRegionList iTextRegionList = iStructuredDocumentRegion.getRegions();
            int n = 0;
            while (n < iTextRegionList.size()) {
                TextAttribute textAttribute;
                ITextRegion iTextRegion = iTextRegionList.get(n);
                String string = (String)this.getContextStyleMap().get(iTextRegion.getType());
                if (string != null && (textAttribute = this.getAttribute(string)) != null) {
                    StyleRange styleRange = new StyleRange(iStructuredDocumentRegion.getStartOffset(iTextRegion), iTextRegion.getLength(), textAttribute.getForeground(), textAttribute.getBackground(), textAttribute.getStyle());
                    if ((textAttribute.getStyle() & 0x40000000) != 0) {
                        styleRange.underline = true;
                        styleRange.fontStyle &= 0xBFFFFFFF;
                    }
                    this.fText.setStyleRange(styleRange);
                }
                ++n;
            }
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
    }

    protected String getNamedStyleAtOffset(int n) {
        if (n >= this.fInput.length()) {
            return this.getNamedStyleAtOffset(this.fInput.length() - 1);
        }
        if (n < 0) {
            return this.getNamedStyleAtOffset(0);
        }
        if (this.fNodes == null) {
            return null;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = this.fNodes;
        while (iStructuredDocumentRegion != null && !iStructuredDocumentRegion.containsOffset(n)) {
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
        if (iStructuredDocumentRegion != null) {
            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
            if (iTextRegion == null) {
                return null;
            }
            if (n > iStructuredDocumentRegion.getTextEndOffset(iTextRegion)) {
                return null;
            }
            String string = iTextRegion.getType();
            if (string == null) {
                return null;
            }
            String string2 = (String)this.getContextStyleMap().get(string);
            if (string2 != null) {
                return string2;
            }
        }
        return null;
    }

    public void setText(String string) {
        this.fInput = string;
        DocumentReader documentReader = new DocumentReader((IDocument)new Document(this.fInput));
        this.getParser().reset((Reader)documentReader);
        this.fNodes = this.getParser().getDocumentRegions();
        if (this.fText != null) {
            this.fText.setText(string);
        }
        this.applyStyles();
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        this.fPreferenceStore = iPreferenceStore;
        super.setPreferenceStore(iPreferenceStore);
    }
}

