/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Assert;
import org.eclipse.php.ui.util.PHPManualDirector;

public class PHPManualDirectorDescriptor {
    private static final String PHP_MANUAL_DIRECTORS_EXTENSION_POINT = "org.eclipse.php.ui.phpManualDirectors";
    private static final String DIRECTOR_TAG = "director";
    private static final String ID_ATTRIBUTE = "id";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String ELEMENT_TAG = "element";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String PATH_ATTRIBUTE = "path";
    private IConfigurationElement fElement;

    public PHPManualDirectorDescriptor(IConfigurationElement iConfigurationElement) {
        Assert.isNotNull((Object)iConfigurationElement);
        this.fElement = iConfigurationElement;
    }

    public static PHPManualDirectorDescriptor[] getContributedDirectors() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHP_MANUAL_DIRECTORS_EXTENSION_POINT);
        PHPManualDirectorDescriptor[] pHPManualDirectorDescriptorArray = PHPManualDirectorDescriptor.createDescriptors(iConfigurationElementArray);
        PHPManualDirectorDescriptor.initializeFromPreferences(pHPManualDirectorDescriptorArray);
        return pHPManualDirectorDescriptorArray;
    }

    public PHPManualDirector createDirector() {
        PHPManualDirector pHPManualDirector = new PHPManualDirector(this.getLabel());
        IConfigurationElement[] iConfigurationElementArray = this.fElement.getChildren(ELEMENT_TAG);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            pHPManualDirector.addPath(iConfigurationElementArray[n].getAttribute(NAME_ATTRIBUTE), iConfigurationElementArray[n].getAttribute(PATH_ATTRIBUTE));
            ++n;
        }
        return pHPManualDirector;
    }

    public String getID() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getLabel() {
        return this.fElement.getAttribute(LABEL_ATTRIBUTE);
    }

    private static PHPManualDirectorDescriptor[] createDescriptors(IConfigurationElement[] iConfigurationElementArray) {
        ArrayList<PHPManualDirectorDescriptor> arrayList = new ArrayList<PHPManualDirectorDescriptor>(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (DIRECTOR_TAG.equals(iConfigurationElement.getName())) {
                PHPManualDirectorDescriptor pHPManualDirectorDescriptor = new PHPManualDirectorDescriptor(iConfigurationElement);
                arrayList.add(pHPManualDirectorDescriptor);
            }
            ++n;
        }
        return arrayList.toArray(new PHPManualDirectorDescriptor[arrayList.size()]);
    }

    private static void initializeFromPreferences(PHPManualDirectorDescriptor[] pHPManualDirectorDescriptorArray) {
    }
}

