/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDRepeatableFacetImpl;
import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDEnumerationFacetImpl
extends XSDRepeatableFacetImpl
implements XSDEnumerationFacet {
    protected EList value = null;
    static /* synthetic */ Class class$0;

    public static XSDEnumerationFacet createEnumerationFacet(Node node) {
        if (XSDConstants.nodeType(node) == 12) {
            XSDEnumerationFacet xsdEnumerationFacet = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
            xsdEnumerationFacet.setElement((Element)node);
            return xsdEnumerationFacet;
        }
        return null;
    }

    protected XSDEnumerationFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_ENUMERATION_FACET;
    }

    public EList getValue() {
        if (this.value == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.value = new EDataTypeUniqueEList((Class)clazz, (InternalEObject)this, 11);
        }
        return this.value;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.getValue().clear();
                this.getValue().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.getValue().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.value != null && !this.value.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(12);
        this.setElement(newElement);
        return newElement;
    }

    public void validateValue() {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer();
        XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
        if (baseTypeDefinition != null) {
            XSDSimpleTypeDefinitionImpl.AssessmentImpl assessment = (XSDSimpleTypeDefinitionImpl.AssessmentImpl)baseTypeDefinition.assess(this.getLexicalValue());
            if (!assessment.getDiagnostics().isEmpty()) {
                assessment.assignDiagnostics(this, this.getElement(), "value");
                this.getDiagnostics().addAll(assessment.getDiagnostics());
            } else if (assessment.getValue() == null) {
                this.createRequiredAttributeDiagnostic("http://www.w3.org/TR/xmlschema-2/", "element-enumeration", this.getElement(), "value");
            }
        }
    }

    protected boolean analyze() {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition;
        super.analyze();
        String theLexicalValue = this.getLexicalValue();
        Object newValue = null;
        if (theLexicalValue != null && (xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer()) != null) {
            try {
                newValue = xsdSimpleTypeDefinition.getValue(theLexicalValue);
            }
            catch (RuntimeException runtimeException) {}
        }
        if (!this.getValue().contains(newValue)) {
            this.getValue().clear();
            if (newValue != null) {
                this.getValue().add(newValue);
            }
        }
        return true;
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.Literals.XSD_FACET__LEXICAL_VALUE) {
            this.traverseToRootForAnalysis();
        }
    }

    public boolean isConstraintSatisfied(Object value) {
        Iterator values = this.getValue().iterator();
        while (values.hasNext()) {
            Object object = values.next();
            if (!this.getSimpleTypeDefinition().equalValues(object, value)) continue;
            return true;
        }
        return false;
    }

    public Object getEffectiveValue() {
        return this.getValue();
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDEnumerationFacetImpl clonedEnumerationFacet = (XSDEnumerationFacetImpl)this.getXSDFactory().createXSDEnumerationFacet();
        clonedEnumerationFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedEnumerationFacet.setLexicalValue(this.getLexicalValue());
        }
        if (deep && this.getAnnotation() != null) {
            clonedEnumerationFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedEnumerationFacet.setElement(this.getElement());
        }
        clonedEnumerationFacet.isReconciling = shareDOM;
        return clonedEnumerationFacet;
    }
}

