/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.outline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDMultiPageEditor;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObjectListener;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IDescription;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.INamedObject;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;

public class ASDContentOutlineProvider
implements ITreeContentProvider,
ILabelProvider,
IASDObjectListener {
    protected Viewer viewer;
    protected ASDMultiPageEditor editor;
    protected List listeners = new ArrayList();
    protected IDescription description;

    public ASDContentOutlineProvider(ASDMultiPageEditor editor, IDescription description) {
        this.editor = editor;
        this.description = description;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ITreeElement) {
            Object[] kids = ((ITreeElement)parentElement).getChildren();
            int index = 0;
            while (index < kids.length) {
                this.attachListener(kids[index]);
                ++index;
            }
            return kids;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof ITreeElement) {
            return ((ITreeElement)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.unattachAllListeners();
        this.viewer = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        this.unattachAllListeners();
    }

    public Image getImage(Object element) {
        if (element instanceof ITreeElement) {
            return ((ITreeElement)element).getImage();
        }
        return null;
    }

    public String getText(Object element) {
        String text = null;
        text = element instanceof INamedObject ? ((INamedObject)element).getName() : (element instanceof ITreeElement ? ((ITreeElement)element).getText() : element.toString());
        if (text == null) {
            text = "";
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected void attachListener(Object object) {
        if (object instanceof IASDObject && !this.listeners.contains(object)) {
            ((IASDObject)object).registerListener(this);
            this.listeners.add(object);
        }
    }

    protected void unattachAllListeners() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            ((IASDObject)item).unregisterListener(this);
        }
    }

    public void propertyChanged(Object object, String property) {
        if (this.viewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)this.viewer;
            treeViewer.refresh(object);
            treeViewer.reveal(object);
        }
    }
}

