/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.views;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.debug.core.debugger.DefaultExpressionsManager;
import org.eclipse.php.debug.core.debugger.Expression;
import org.eclipse.php.debug.core.debugger.ExpressionValue;
import org.eclipse.php.debug.core.model.PHPDebugTarget;
import org.eclipse.php.debug.core.model.PHPStackFrame;
import org.eclipse.php.debug.core.model.PHPThread;
import org.eclipse.php.debug.ui.Logger;
import org.eclipse.php.debug.ui.views.PHPStackLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class PHPStackView
extends AbstractDebugView
implements ISelectionListener {
    private PHPDebugTarget fTarget;
    static /* synthetic */ Class class$0;

    protected Viewer createViewer(Composite composite) {
        TreeViewer treeViewer = new TreeViewer(composite);
        treeViewer.setLabelProvider((IBaseLabelProvider)new PHPStackLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new StackViewContentProvider());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)treeViewer);
        return treeViewer;
    }

    protected String getHelpContextId() {
        return null;
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.fTarget = null;
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        this.update();
    }

    private synchronized void update() {
        IAdaptable iAdaptable = DebugUITools.getDebugContext();
        this.fTarget = null;
        IDebugElement iDebugElement = null;
        if (iAdaptable != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDebugElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iDebugElement = (IDebugElement)iAdaptable.getAdapter((Class)clazz)) != null && iDebugElement.getModelIdentifier().equals("org.eclipse.php.debug.core")) {
                this.fTarget = (PHPDebugTarget)iDebugElement.getDebugTarget();
            }
        }
        IDebugElement iDebugElement2 = null;
        if (this.fTarget != null && this.fTarget.isSuspended()) {
            iDebugElement2 = iDebugElement;
        }
        this.getViewer().setInput(iDebugElement2);
        this.getViewer().refresh();
    }

    protected void createActions() {
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    public void updateObjects() {
        super.updateObjects();
        this.update();
    }

    class StackViewContentProvider
    implements ITreeContentProvider {
        StackViewContentProvider() {
        }

        public Object[] getChildren(Object object) {
            try {
                if (object instanceof PHPDebugTarget) {
                    IThread[] iThreadArray = ((PHPDebugTarget)object).getThreads();
                    if (iThreadArray != null && iThreadArray[0] != null) {
                        IStackFrame iStackFrame = iThreadArray[0].getTopStackFrame();
                        if (iStackFrame == null) {
                            return new Expression[0];
                        }
                        Object[] objectArray = ((PHPStackFrame)iStackFrame).getStackVariables();
                        if (objectArray == null) {
                            return new Expression[0];
                        }
                        return objectArray;
                    }
                } else {
                    if (object instanceof PHPThread) {
                        IStackFrame iStackFrame = ((PHPThread)object).getTopStackFrame();
                        if (iStackFrame == null) {
                            return new Expression[0];
                        }
                        Object[] objectArray = ((PHPStackFrame)iStackFrame).getStackVariables();
                        if (objectArray == null) {
                            return new Expression[0];
                        }
                        return objectArray;
                    }
                    if (object instanceof PHPStackFrame) {
                        Object[] objectArray = ((PHPStackFrame)object).getStackVariables();
                        if (objectArray == null) {
                            return new Expression[0];
                        }
                        return objectArray;
                    }
                    if (object instanceof Expression) {
                        Expression expression = (Expression)object;
                        ExpressionValue expressionValue = expression.getValue();
                        Object[] objectArray = expressionValue.getChildren();
                        if (objectArray == null) {
                            return new Expression[0];
                        }
                        if (objectArray.length == 0) {
                            DefaultExpressionsManager defaultExpressionsManager = PHPStackView.this.fTarget.getExpressionManager();
                            defaultExpressionsManager.update(expression, 1);
                            expressionValue = expression.getValue();
                            objectArray = expressionValue.getChildren();
                            if (objectArray == null) {
                                objectArray = new Expression[]{};
                            }
                        }
                        return objectArray;
                    }
                }
            }
            catch (DebugException debugException) {
                Logger.logException("StackViewContentProvider unexpected error", debugException);
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof IDebugTarget) {
                return null;
            }
            if (object instanceof IDebugElement) {
                return ((IDebugElement)object).getDebugTarget();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof IDebugElement) {
                return this.getChildren(object).length > 0;
            }
            if (object instanceof Expression) {
                Expression expression = (Expression)object;
                ExpressionValue expressionValue = expression.getValue();
                Expression[] expressionArray = expressionValue.getChildren();
                return expressionArray != null;
            }
            return false;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

