/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.core.BeaninfosDoc;
import org.eclipse.jem.internal.beaninfo.core.IBeaninfosDocEntry;
import org.eclipse.jem.internal.beaninfo.core.SearchpathEntry;
import org.eclipse.jem.internal.beaninfo.ui.BPBeaninfoListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPSearchListElement;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfosWorkbookPage;
import org.eclipse.jem.internal.beaninfo.ui.IBuildSearchPage;
import org.eclipse.jem.internal.beaninfo.ui.IStatusChangeListener;
import org.eclipse.jem.internal.beaninfo.ui.PackagesWorkbookPage;
import org.eclipse.jem.internal.beaninfo.ui.SearchpathOrderingWorkbookPage;
import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

public class BeaninfoPathsBlock {
    private Composite top = null;
    private TabFolder tabFolder = null;
    private Button enableBeaninfoCheckbox = null;
    private PackagesWorkbookPage packagesWorkbookPage2 = null;
    private SearchpathOrderingWorkbookPage searchpathOrderingWorkbookPage2 = null;
    private BeaninfosWorkbookPage beaninfosPropertyPage2 = null;
    private Control packagesPageControl = null;
    private Control searchpathPageControl = null;
    private Control beaninfosPageControl = null;
    private Image packagesTabImage;
    private Image beaninfosTabImage;
    private Image searchPathTabImage;
    private IWorkspaceRoot workspaceRoot;
    private IStatusChangeListener statusChangeListener;
    private IBuildSearchPage currentPage;
    private IJavaProject javaProject;
    private boolean enableBeaninfo = true;

    public BeaninfoPathsBlock(IWorkspaceRoot workspaceRoot, IStatusChangeListener statusChangeListener) {
        this.workspaceRoot = workspaceRoot;
        this.statusChangeListener = statusChangeListener;
    }

    private void setEnableBeaninfo(boolean enable) {
        this.enableBeaninfo = enable;
        if (this.enableBeaninfoCheckbox != null && !this.enableBeaninfoCheckbox.isDisposed()) {
            this.enableBeaninfoCheckbox.setSelection(enable);
        }
    }

    public Control createControl(Composite parent) {
        this.top = new Composite(parent, 0);
        this.top.setLayout((Layout)new GridLayout());
        this.createTabFolder();
        this.enableBeaninfoCheckbox = new Button(this.top, 32);
        this.enableBeaninfoCheckbox.setText(BeanInfoUIMessages.BeaninfoPathsBlock_UI__enablebeaninfo);
        this.enableBeaninfoCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BeaninfoPathsBlock.this.enableBeaninfo = BeaninfoPathsBlock.this.enableBeaninfoCheckbox.getSelection();
                BeaninfoPathsBlock.this.packagesWorkbookPage2.setBeaninfoEnabled(BeaninfoPathsBlock.this.enableBeaninfo);
                BeaninfoPathsBlock.this.beaninfosPropertyPage2.setBeaninfoEnabled(BeaninfoPathsBlock.this.enableBeaninfo);
                BeaninfoPathsBlock.this.searchpathOrderingWorkbookPage2.setBeaninfoEnabled(BeaninfoPathsBlock.this.enableBeaninfo);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.enableBeaninfoCheckbox.setSelection(this.enableBeaninfo);
        if (this.javaProject != null) {
            this.getPackagesPage().init(this.javaProject);
            this.getBeaninfosPage().init(this.javaProject);
            this.getSearchpathOrderingPage().init(this.javaProject);
        }
        return this.top;
    }

    private void createTabFolder() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.tabFolder = new TabFolder(this.top, 0);
        this.tabFolder.setLayoutData((Object)gridData);
        this.createPackagesWorkbookPage2();
        this.createBeaninfosPropertyPage2();
        this.createSearchpathOrderingWorkbookPage2();
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeaninfoPathsBlock.this.tabChanged(e.item);
            }
        });
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(BeanInfoUIMessages.BeanInfoPathsBlock_Page_Tab_Packages);
        tabItem.setImage(this.getPackagesTabImage());
        tabItem.setControl(this.packagesPageControl);
        TabItem tabItem1 = new TabItem(this.tabFolder, 0);
        tabItem1.setText(BeanInfoUIMessages.BeanInfoPathsBlock_Page_Tab_Classes);
        tabItem1.setImage(this.getBeaninfosTabImage());
        tabItem1.setControl(this.beaninfosPageControl);
        TabItem tabItem2 = new TabItem(this.tabFolder, 0);
        tabItem2.setImage(this.getSearchPathTabImage());
        tabItem2.setText(BeanInfoUIMessages.BeaninfoPathsBlock_UI__serachpath_tab_order);
        tabItem2.setControl(this.searchpathPageControl);
        this.tabFolder.setSelection(2);
    }

    private Image getSearchPathTabImage() {
        if (this.searchPathTabImage == null) {
            this.searchPathTabImage = JEMUIPlugin.imageDescriptorFromPlugin((String)JEMUIPlugin.getPlugin().getBundle().getSymbolicName(), (String)"icons/cp_order_obj.gif").createImage();
        }
        return this.searchPathTabImage;
    }

    private Image getPackagesTabImage() {
        if (this.packagesTabImage == null) {
            this.packagesTabImage = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }
        return this.packagesTabImage;
    }

    private Image getBeaninfosTabImage() {
        if (this.beaninfosTabImage == null) {
            URL imageURL = FileLocator.find((Bundle)JEMUIPlugin.getPlugin().getBundle(), (IPath)new Path("icons/javabean.gif"), null);
            this.beaninfosTabImage = imageURL != null ? ImageDescriptor.createFromURL((URL)imageURL).createImage() : ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.beaninfosTabImage;
    }

    private void createPackagesWorkbookPage2() {
        this.packagesPageControl = this.getPackagesPage().createControl((Composite)this.tabFolder);
    }

    private void createSearchpathOrderingWorkbookPage2() {
        this.searchpathPageControl = this.getSearchpathOrderingPage().createControl((Composite)this.tabFolder);
        this.searchpathPageControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BeaninfoPathsBlock.this.searchPathTabImage != null) {
                    if (!BeaninfoPathsBlock.this.searchPathTabImage.isDisposed()) {
                        BeaninfoPathsBlock.this.searchPathTabImage.dispose();
                    }
                    BeaninfoPathsBlock.this.searchPathTabImage = null;
                }
            }
        });
    }

    private void createBeaninfosPropertyPage2() {
        this.beaninfosPageControl = this.getBeaninfosPage().createControl((Composite)this.tabFolder);
        this.beaninfosPageControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BeaninfoPathsBlock.this.beaninfosTabImage != null) {
                    if (!BeaninfoPathsBlock.this.beaninfosTabImage.isDisposed()) {
                        BeaninfoPathsBlock.this.beaninfosTabImage.dispose();
                    }
                    BeaninfoPathsBlock.this.beaninfosTabImage = null;
                }
            }
        });
    }

    PackagesWorkbookPage getPackagesPage() {
        if (this.packagesWorkbookPage2 == null) {
            this.packagesWorkbookPage2 = new PackagesWorkbookPage(this.workspaceRoot, this);
        }
        return this.packagesWorkbookPage2;
    }

    BeaninfosWorkbookPage getBeaninfosPage() {
        if (this.beaninfosPropertyPage2 == null) {
            this.beaninfosPropertyPage2 = new BeaninfosWorkbookPage(this.workspaceRoot, this);
        }
        return this.beaninfosPropertyPage2;
    }

    SearchpathOrderingWorkbookPage getSearchpathOrderingPage() {
        if (this.searchpathOrderingWorkbookPage2 == null) {
            this.searchpathOrderingWorkbookPage2 = new SearchpathOrderingWorkbookPage(this);
        }
        return this.searchpathOrderingWorkbookPage2;
    }

    private void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List selection;
            IBuildSearchPage newPage = (IBuildSearchPage)((TabItem)widget).getData();
            if (this.currentPage != null && !(selection = this.currentPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection);
            }
            this.currentPage = newPage;
        }
    }

    public IRunnableWithProgress getRunnable() {
        final boolean wantNature = this.enableBeaninfo;
        final List searchPathEntries = wantNature ? this.getSearchpathOrderingPage().getElements() : null;
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(BeanInfoUIMessages.BeaninfoPathsBlock_UI__searchpath_operationdescription, 10);
                try {
                    try {
                        BeaninfoPathsBlock.this.setBeaninfoSearchpath(wantNature, searchPathEntries, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
    }

    private void setBeaninfoSearchpath(boolean wantNature, List searchPathEntries, IProgressMonitor monitor) throws CoreException {
        if (wantNature) {
            if (!this.javaProject.getProject().hasNature("org.eclipse.jem.beaninfo.BeanInfoNature")) {
                this.addNatureIDToProject(this.javaProject.getProject(), "org.eclipse.jem.beaninfo.BeanInfoNature", monitor);
            }
            BeaninfoNature nature = BeaninfoNature.getRuntime((IProject)this.javaProject.getProject());
            if (searchPathEntries.size() > 0) {
                IBeaninfosDocEntry[] sparray = new IBeaninfosDocEntry[searchPathEntries.size()];
                Iterator itr = searchPathEntries.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    BPListElement elem = (BPListElement)itr.next();
                    sparray[i++] = elem.getEntry();
                }
                nature.setSearchPath(new BeaninfosDoc(sparray), monitor);
            } else {
                nature.setSearchPath(null, monitor);
            }
        } else {
            this.removeNatureIDFromProject(this.javaProject.getProject(), "org.eclipse.jem.beaninfo.BeanInfoNature", monitor);
        }
    }

    public void init(IJavaProject jproject) {
        block17: {
            this.javaProject = jproject;
            try {
                boolean haveConfigFile = jproject.getProject().getFile(".beaninfoConfig").exists();
                boolean haveNature = this.javaProject.getProject().hasNature("org.eclipse.jem.beaninfo.BeanInfoNature");
                boolean bl = this.enableBeaninfo = haveConfigFile || haveNature;
                if (haveNature || haveConfigFile) {
                    BeaninfosDoc doc = BeaninfoNature.getRuntime((IProject)this.javaProject.getProject()).getSearchPath();
                    IClasspathEntry[] raw = this.javaProject.getRawClasspath();
                    ArrayList<BPBeaninfoListElement> newSearchpath = new ArrayList<BPBeaninfoListElement>();
                    if (doc != null) {
                        IBeaninfosDocEntry[] sp = doc.getSearchpath();
                        int i = 0;
                        while (i < sp.length) {
                            IBeaninfosDocEntry curr = sp[i];
                            boolean isMissing = false;
                            BPListElement elem = null;
                            if (curr instanceof BeaninfoEntry) {
                                BeaninfoEntry be = (BeaninfoEntry)curr;
                                Object[] paths = be.getClasspath(this.javaProject);
                                if (paths != null && paths.length > 0) {
                                    int j = 0;
                                    while (!isMissing && j < paths.length) {
                                        File f;
                                        Object path = paths[j];
                                        isMissing = path instanceof IProject ? !((IProject)path).exists() : (path instanceof String ? !(f = new File((String)path)).exists() : (path instanceof IPath ? true : true));
                                        ++j;
                                    }
                                } else {
                                    isMissing = true;
                                }
                                elem = new BPBeaninfoListElement(be, this.getInitialSearchpaths(be), isMissing);
                            } else {
                                boolean isExported = false;
                                boolean isPackageMissing = true;
                                isMissing = true;
                                SearchpathEntry ce = (SearchpathEntry)curr;
                                int kind = ce.getKind();
                                IPath path = ce.getPath();
                                int j = 0;
                                block5: while (j < raw.length) {
                                    if (raw[j].getEntryKind() == kind && raw[j].getPath().equals((Object)path)) {
                                        isMissing = false;
                                        isExported = raw[j].isExported() || raw[j].getEntryKind() == 3;
                                        String packageName = ce.getPackage();
                                        if (packageName != null) {
                                            IPackageFragmentRoot[] roots = this.javaProject.findPackageFragmentRoots(raw[j]);
                                            int k = 0;
                                            while (k < roots.length) {
                                                IPackageFragmentRoot iroot = roots[k];
                                                if (iroot.getPackageFragment(packageName).exists()) {
                                                    isPackageMissing = false;
                                                    break block5;
                                                }
                                                ++k;
                                            }
                                            break;
                                        }
                                        isPackageMissing = false;
                                        break;
                                    }
                                    ++j;
                                }
                                elem = new BPSearchListElement(ce, isMissing, isPackageMissing, isExported);
                            }
                            newSearchpath.add((BPBeaninfoListElement)elem);
                            ++i;
                        }
                    }
                    this.setSearchOrderElements(newSearchpath);
                    if (this.getPackagesPage() != null) {
                        this.getPackagesPage().init(this.javaProject);
                        this.getBeaninfosPage().init(this.javaProject);
                        this.getSearchpathOrderingPage().init(this.javaProject);
                    }
                    break block17;
                }
                this.setEnableBeaninfo(false);
            }
            catch (JavaModelException javaModelException) {
                this.setEnableBeaninfo(false);
            }
            catch (CoreException coreException) {
                this.setEnableBeaninfo(false);
            }
        }
        this.doStatusLineUpdate();
    }

    private void addNatureIDToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private void removeNatureIDFromProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        int indx = -1;
        int i = 0;
        while (i < prevNatures.length) {
            if (prevNatures[i].equals(natureId)) {
                indx = i;
                break;
            }
            ++i;
        }
        if (indx == -1) {
            return;
        }
        String[] newNatures = new String[prevNatures.length - 1];
        if (newNatures.length != 0) {
            System.arraycopy(prevNatures, 0, newNatures, 0, indx);
            if (indx < newNatures.length) {
                System.arraycopy(prevNatures, indx + 1, newNatures, indx, newNatures.length - indx);
            }
        }
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    void doStatusLineUpdate() {
        this.statusChangeListener.statusChanged(this.getSearchpathOrderingPage().getStatus());
    }

    public void setSearchOrderElements(List newElements) {
        ArrayList<BPListElement> exportedEntries = new ArrayList<BPListElement>(newElements.size());
        Iterator iter = newElements.iterator();
        while (iter.hasNext()) {
            BPListElement element = (BPListElement)iter.next();
            if (!element.isExported()) continue;
            exportedEntries.add(element);
        }
        this.getSearchpathOrderingPage().setElements(newElements);
        this.getSearchpathOrderingPage().setCheckedElements(exportedEntries);
    }

    private BPSearchListElement[] getInitialSearchpaths(BeaninfoEntry infoEntry) {
        IClasspathEntry resolved;
        IResource res;
        IPackageFragmentRoot[] roots = null;
        if (infoEntry.getKind() != 100 && (res = this.workspaceRoot.findMember((resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)infoEntry.getClasspathEntry())).getPath())) != null && res.exists()) {
            if (res instanceof IProject) {
                IJavaProject jp = (IJavaProject)JavaCore.create((IResource)res);
                try {
                    if (jp != null) {
                        roots = jp.getPackageFragmentRoots();
                    }
                }
                catch (JavaModelException javaModelException) {}
            } else {
                IProject containingProject = res.getProject();
                IJavaProject jp = JavaCore.create((IProject)containingProject);
                if (jp != null) {
                    try {
                        IPackageFragmentRoot root = jp.findPackageFragmentRoot(resolved.getPath());
                        if (root != null) {
                            roots = new IPackageFragmentRoot[]{root};
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        }
        SearchpathEntry[] entries = infoEntry.getSearchPaths();
        BPSearchListElement[] packageElements = new BPSearchListElement[entries.length];
        int i = 0;
        while (i < entries.length) {
            boolean isPackageMissing = roots != null;
            SearchpathEntry ce = entries[i];
            if (roots != null) {
                String packageName = ce.getPackage();
                int k = 0;
                while (k < roots.length) {
                    IPackageFragmentRoot iroot = roots[k];
                    if (iroot.getPackageFragment(packageName).exists()) {
                        isPackageMissing = false;
                        break;
                    }
                    ++k;
                }
            }
            packageElements[i] = new BPSearchListElement(ce, false, isPackageMissing, false);
            ++i;
        }
        return packageElements;
    }

    public static List getSelectedList(ISelection selection) {
        ArrayList<Object> selectedList = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selectedList = new ArrayList<Object>(Arrays.asList(structuredSelection.toArray()));
        }
        return selectedList;
    }

    public boolean isBeaninfoEnabled() {
        return this.enableBeaninfo;
    }
}

