/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMSelector;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMMTypeCollector;
import org.eclipse.wst.css.core.internal.parser.CSSRegionUtil;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPageRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.ui.internal.contentassist.CSSCACandidate;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistContext;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGenerator;
import org.eclipse.wst.css.ui.internal.image.CSSImageType;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

class CSSProposalGeneratorForPseudoSelector
extends CSSProposalGenerator {
    CSSProposalGeneratorForPseudoSelector(CSSContentAssistContext context) {
        super(context);
    }

    protected Iterator getCandidates() {
        String type;
        ArrayList<CSSCACandidate> candidates = new ArrayList<CSSCACandidate>();
        boolean hasLeadingColon = this.checkLeadingColon();
        String textToReplace = this.fContext.getTextToReplace();
        if (!hasLeadingColon && textToReplace.length() > 0 && !textToReplace.equals(this.fContext.getTextToCompare())) {
            return candidates.iterator();
        }
        ITextRegion region = this.fContext.getTargetRegion();
        if (region != null && (type = region.getType()) != "S" && !CSSRegionUtil.isSelectorBegginingType((String)type)) {
            return candidates.iterator();
        }
        boolean useUpperCase = CSSCorePlugin.getDefault().getPluginPreferences().getInt("identifierCase") == 2;
        List tags = this.getSelectorTags();
        Collections.sort(tags);
        Iterator i = tags.iterator();
        while (i.hasNext()) {
            boolean inRule;
            String text = (String)i.next();
            if (hasLeadingColon && !this.isMatch(text)) continue;
            text = useUpperCase ? text.toUpperCase() : text.toLowerCase();
            int cursorPos = 0;
            StringBuffer buf = new StringBuffer();
            if (hasLeadingColon) {
                buf.append(text.substring(1));
            } else {
                buf.append(textToReplace);
                buf.append(text);
            }
            cursorPos += buf.length();
            if (buf.length() <= 0) continue;
            boolean bl = inRule = this.fContext.getTargetNode() instanceof ICSSStyleRule || this.fContext.getTargetNode() instanceof ICSSPageRule;
            if (!inRule || textToReplace.length() == 0 && !hasLeadingColon) {
                buf.append(" ");
                ++cursorPos;
            }
            if (!inRule) {
                CSSProposalGenerator.StringAndOffset sao = this.generateBraces();
                buf.append(sao.fString);
                cursorPos += sao.fOffset;
            }
            CSSCACandidate item = new CSSCACandidate();
            item.setReplacementString(buf.toString());
            item.setCursorPosition(cursorPos);
            item.setDisplayString(text);
            item.setImageType(CSSImageType.SELECTOR_PSEUDO);
            candidates.add(item);
        }
        return candidates.iterator();
    }

    List getSelectorTags() {
        ArrayList<String> tagList = new ArrayList<String>();
        ICSSNode targetNode = this.fContext.getTargetNode();
        String rootType = targetNode instanceof ICSSPageRule ? "CSSMM.PageRule" : "CSSMM.StyleRule";
        CSSMMTypeCollector collector = new CSSMMTypeCollector();
        collector.collectNestedType(false);
        collector.apply((CSSMMNode)this.fContext.getMetaModel(), rootType);
        Iterator i = collector.getNodes();
        if (!i.hasNext()) {
            return tagList;
        }
        CSSMMNode node = (CSSMMNode)i.next();
        i = node.getChildNodes();
        while (i.hasNext()) {
            String selType;
            CSSMMNode child = (CSSMMNode)i.next();
            if (child.getType() != "CSSMM.Selector" || (selType = ((CSSMMSelector)child).getSelectorType()) != "PseudoClass" && selType != "PseudoElement") continue;
            tagList.add(((CSSMMSelector)child).getSelectorString());
        }
        return tagList;
    }

    protected boolean isMatch(String text) {
        if (!super.isMatch(text)) {
            ITextRegion region = this.fContext.getTargetRegion();
            return region != null && region.getType() == "SELECTOR_PSEUDO";
        }
        return true;
    }
}

