/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.util.HashMap;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;

public class OutputItem {
    public static final int STATUS_START = 1;
    public static final int STATUS_SUCCESS = 2;
    public static final int STATUS_WARNING = 3;
    public static final int STATUS_FAILURE = 4;
    public static final int STATUS_IN_PROGRESS = 5;
    public static final int STATUS_CRITICAL_ERROR = 6;
    public static final int ACTION_RUN = 20;
    public static final int ACTION_BUILD = 21;
    public static final int ACTION_CALL = 22;
    public static final int ACTION_EXECUTE = 23;
    public static final int ACTION_OPEN = 24;
    public static final int ACTION_SAVE = 25;
    public static final int ACTION_CLOSE = 26;
    public static final int ACTION_SELECT = 27;
    public static final int ACTION_CREATE = 28;
    public static final int ACTION_PRINT = 29;
    public static final int ACTION_VIEW = 30;
    public static final int ACTION_EDIT = 31;
    public static final int ACTION_DELETE = 32;
    public static final int ACTION_DROP = 33;
    public static final int ACTION_BUILD_FOR_DEBUG = 34;
    public static final int ACTION_DEBUG = 35;
    public static final int ACTION_DEPLOY = 36;
    public static final int ACTION_EXPORT = 37;
    public static final int ACTION_IMPORT = 38;
    public static final int ACTION_GENERATE_DDL = 39;
    public static final int ACTION_ALTER = 40;
    public static final int ACTION_BEFORE_RUN = 41;
    public static final int ACTION_AFTER_RUN = 42;
    public static final int ACTION_EXTRACT = 43;
    public static final int ACTION_LOAD = 44;
    public static final int ACTION_VALIDATE = 45;
    public static int nextUserAction = 100;
    protected static HashMap actionMap;
    protected static HashMap hasContents;
    protected String objName;
    protected String action;
    protected String status;
    protected String messages;
    protected String nameQualifier;
    protected String signature;
    protected String uniqueName;
    protected boolean hasParms;
    protected boolean hasResults;
    protected int actionCode;
    protected int statusCode;

    public static int getActionCode(String action) {
        if (actionMap == null) {
            return -1;
        }
        Integer mappedAct = (Integer)actionMap.get(action);
        if (mappedAct == null) {
            return -1;
        }
        return mappedAct;
    }

    public OutputItem(int statusCode, int actionCode, String objectName, String uniqueName) {
        this.setStatus(statusCode);
        this.setAction(actionCode);
        this.setObjName(objectName);
        this.setUniqueName(uniqueName);
        this.init();
    }

    public OutputItem(int statusCode, int actionCode, String objectName) {
        this.setStatus(statusCode);
        this.setAction(actionCode);
        this.setObjName(objectName);
        this.init();
    }

    public OutputItem(int statusCode, int actionCode, String objectName, String message, String uniqueName) {
        this.setStatus(statusCode);
        this.setAction(actionCode);
        this.setObjName(objectName);
        this.setMessage(message);
        this.setUniqueName(uniqueName);
        this.init();
    }

    public OutputItem(int statusCode, String action, String objectName, String uniqueName) {
        this.setStatus(statusCode);
        this.setObjName(objectName);
        this.setUniqueName(uniqueName);
        this.init();
        this.setAction(action);
    }

    public OutputItem(int statusCode, String action, String objectName) {
        this.setStatus(statusCode);
        this.setObjName(objectName);
        this.init();
        this.setAction(action);
    }

    public OutputItem(int statusCode, String action, String objectName, String message, String uniqueName) {
        this.setStatus(statusCode);
        this.setObjName(objectName);
        this.setMessage(message);
        this.setUniqueName(uniqueName);
        this.init();
        this.setAction(action);
    }

    private void init() {
        this.messages = "";
        this.hasParms = false;
        this.hasResults = false;
        if (actionMap == null) {
            actionMap = new HashMap();
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_RUN"), new Integer(20));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_BUILD"), new Integer(21));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_CREATE"), new Integer(28));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_OPEN"), new Integer(24));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_SAVE"), new Integer(25));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_CLOSE"), new Integer(26));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_CALL"), new Integer(22));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_EXECUTE"), new Integer(23));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_SELECT"), new Integer(27));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_PRINT"), new Integer(29));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_VIEW"), new Integer(30));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_EDIT"), new Integer(31));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_DELETE"), new Integer(32));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_DROP"), new Integer(33));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_DEBUG"), new Integer(35));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_BUILD_FOR_DEBUG"), new Integer(34));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_DEPLOY"), new Integer(36));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_EXPORT"), new Integer(37));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_IMPORT"), new Integer(38));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_GENERATEDDL"), new Integer(39));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_ALTER"), new Integer(40));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_BEFORE_RUN"), new Integer(41));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_AFTER_RUN"), new Integer(42));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_EXTRACT"), new Integer(43));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_LOAD"), new Integer(44));
            actionMap.put(OutputViewPlugin.getString("OV_ACTION_VALIDATE"), new Integer(45));
        }
        hasContents = new HashMap();
    }

    protected String getObjName() {
        return this.objName;
    }

    protected String getMessages() {
        return this.messages;
    }

    protected String getStatus() {
        return this.status;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    protected String getAction() {
        return this.action;
    }

    protected int getActionCode() {
        return this.actionCode;
    }

    protected String getUniqueName() {
        if (this.uniqueName == null || this.uniqueName.equals("")) {
            return this.objName;
        }
        return this.uniqueName;
    }

    protected boolean isStatusSuccess() {
        return this.statusCode == 2;
    }

    protected boolean hasParameters() {
        return this.hasParms;
    }

    protected boolean hasResults() {
        return this.hasResults;
    }

    protected void setHasParameters(boolean value) {
        this.hasParms = value;
    }

    protected void setHasResults(boolean value) {
        this.hasResults = value;
    }

    protected void setHasContents(String id, boolean value) {
        hasContents.put(id, new Boolean(value));
    }

    protected boolean hasContents(String id) {
        if (hasContents.containsKey(id)) {
            return (Boolean)hasContents.get(id);
        }
        return false;
    }

    protected void setObjName(String name) {
        this.objName = name;
    }

    protected void setNameQualifier(String qualifier) {
        this.nameQualifier = qualifier;
    }

    protected void setMessage(String msg) {
        this.messages = msg;
    }

    protected void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    protected void appendMessage(String msgs) {
        this.messages = this.messages.length() == 0 ? msgs : String.valueOf(this.messages) + "\n\n" + msgs;
    }

    public void setStatus(int statusCode) {
        this.statusCode = statusCode;
        this.status = this.statusFlagToString(statusCode);
    }

    protected void setAction(int actionCode) {
        this.actionCode = actionCode;
        this.action = this.actionFlagToString(actionCode);
    }

    protected void setAction(String action) {
        this.action = action;
        Integer mappedAct = (Integer)actionMap.get(action);
        if (mappedAct == null) {
            this.actionCode = nextUserAction++;
            actionMap.put(action, new Integer(this.actionCode));
        } else {
            this.actionCode = mappedAct;
        }
    }

    public Image getStatusImage() {
        switch (this.statusCode) {
            case 1: {
                return OutputViewPlugin.getPlugin().getImage("task_inprogress_misc");
            }
            case 2: {
                return OutputViewPlugin.getPlugin().getImage("task_success_misc");
            }
            case 3: {
                return OutputViewPlugin.getPlugin().getImage("task_warning_misc");
            }
            case 4: {
                return OutputViewPlugin.getPlugin().getImage("task_error_misc");
            }
            case 5: {
                return OutputViewPlugin.getPlugin().getImage("task_inprogress_misc");
            }
            case 6: {
                return OutputViewPlugin.getPlugin().getImage("task_error_misc");
            }
        }
        return OutputViewPlugin.getPlugin().getImage("task_inprogress_misc");
    }

    private String statusFlagToString(int statusFlag) {
        switch (statusFlag) {
            case 1: {
                return OutputViewPlugin.getString("OV_STATUS_START");
            }
            case 2: {
                return OutputViewPlugin.getString("OV_STATUS_SUCCESS");
            }
            case 3: {
                return OutputViewPlugin.getString("OV_STATUS_WARNING");
            }
            case 4: {
                return OutputViewPlugin.getString("OV_STATUS_FAILURE");
            }
            case 5: {
                return OutputViewPlugin.getString("OV_STATUS_IN_PROGRESS");
            }
            case 6: {
                return OutputViewPlugin.getString("OV_STATUS_CRITICAL_ERROR");
            }
        }
        return OutputViewPlugin.getString("OV_STATUS_UNKNOWN");
    }

    private String actionFlagToString(int actionFlag) {
        switch (actionFlag) {
            case 20: {
                return OutputViewPlugin.getString("OV_ACTION_RUN");
            }
            case 21: {
                return OutputViewPlugin.getString("OV_ACTION_BUILD");
            }
            case 28: {
                return OutputViewPlugin.getString("OV_ACTION_CREATE");
            }
            case 24: {
                return OutputViewPlugin.getString("OV_ACTION_OPEN");
            }
            case 25: {
                return OutputViewPlugin.getString("OV_ACTION_SAVE");
            }
            case 26: {
                return OutputViewPlugin.getString("OV_ACTION_CLOSE");
            }
            case 22: {
                return OutputViewPlugin.getString("OV_ACTION_CALL");
            }
            case 23: {
                return OutputViewPlugin.getString("OV_ACTION_RUN");
            }
            case 27: {
                return OutputViewPlugin.getString("OV_ACTION_SELECT");
            }
            case 29: {
                return OutputViewPlugin.getString("OV_ACTION_PRINT");
            }
            case 30: {
                return OutputViewPlugin.getString("OV_ACTION_VIEW");
            }
            case 31: {
                return OutputViewPlugin.getString("OV_ACTION_EDIT");
            }
            case 32: {
                return OutputViewPlugin.getString("OV_ACTION_DELETE");
            }
            case 33: {
                return OutputViewPlugin.getString("OV_ACTION_DROP");
            }
            case 35: {
                return OutputViewPlugin.getString("OV_ACTION_DEBUG");
            }
            case 34: {
                return OutputViewPlugin.getString("OV_ACTION_BUILD_FOR_DEBUG");
            }
            case 36: {
                return OutputViewPlugin.getString("OV_ACTION_DEPLOY");
            }
            case 37: {
                return OutputViewPlugin.getString("OV_ACTION_EXPORT");
            }
            case 38: {
                return OutputViewPlugin.getString("OV_ACTION_IMPORT");
            }
            case 39: {
                return OutputViewPlugin.getString("OV_ACTION_GENERATEDDL");
            }
            case 40: {
                return OutputViewPlugin.getString("OV_ACTION_ALTER");
            }
            case 41: {
                return OutputViewPlugin.getString("OV_ACTION_BEFORE_RUN");
            }
            case 42: {
                return OutputViewPlugin.getString("OV_ACTION_AFTER_RUN");
            }
            case 43: {
                return OutputViewPlugin.getString("OV_ACTION_EXTRACT");
            }
            case 44: {
                return OutputViewPlugin.getString("OV_ACTION_LOAD");
            }
            case 45: {
                return OutputViewPlugin.getString("OV_ACTION_VALIDATE");
            }
        }
        return OutputViewPlugin.getString("OV_STATUS_UNKNOWN");
    }

    public boolean equals(OutputItem obj) {
        return obj.getObjName().equals(this.getObjName()) && obj.getUniqueName().equals(this.getUniqueName()) && obj.getActionCode() == this.getActionCode();
    }
}

