/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;

class VAJBuildInfo
implements Runnable {
    private String vajProjectName = "";
    private String buildFileName = "";
    private Vector projectTargets = new Vector();
    private String target = "";
    private int outputMessageLevel = 2;
    private transient Project project;
    private transient boolean projectInitialized = false;
    protected transient PropertyChangeSupport propertyChange;
    private Thread buildThread;
    private BuildListener projectLogger;

    VAJBuildInfo() {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChange().addPropertyChangeListener(listener);
    }

    public String asDataString() {
        String result = this.getOutputMessageLevel() + "|" + this.getBuildFileName() + "|" + this.getTarget();
        Enumeration e = this.getProjectTargets().elements();
        while (e.hasMoreElements()) {
            result = result + "|" + e.nextElement();
        }
        return result;
    }

    private static int findTargetPosition(Vector names, String name) {
        int res = names.size();
        int i = 0;
        while (i < names.size() && res == names.size()) {
            if (name.compareTo((String)names.elementAt(i)) < 0) {
                res = i;
            }
            ++i;
        }
        return res;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
    }

    public String getBuildFileName() {
        return this.buildFileName;
    }

    public int getOutputMessageLevel() {
        return this.outputMessageLevel;
    }

    private Project getProject() {
        if (this.project == null) {
            this.project = new Project();
        }
        return this.project;
    }

    public Vector getProjectTargets() {
        return this.projectTargets;
    }

    protected PropertyChangeSupport getPropertyChange() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    public String getTarget() {
        return this.target;
    }

    public String getVAJProjectName() {
        return this.vajProjectName;
    }

    private void initProject() {
        try {
            this.project.init();
            File buildFile = new File(this.getBuildFileName());
            this.project.setUserProperty("ant.file", buildFile.getAbsolutePath());
            ProjectHelper.configureProject((Project)this.project, (File)buildFile);
            this.setProjectInitialized(true);
        }
        catch (RuntimeException exc) {
            this.setProjectInitialized(false);
            throw exc;
        }
        catch (Error err) {
            this.setProjectInitialized(false);
            throw err;
        }
    }

    public boolean isProjectInitialized() {
        return this.projectInitialized;
    }

    public static VAJBuildInfo parse(String data) {
        VAJBuildInfo result = new VAJBuildInfo();
        try {
            StringTokenizer tok = new StringTokenizer(data, "|");
            result.setOutputMessageLevel(tok.nextToken());
            result.setBuildFileName(tok.nextToken());
            result.setTarget(tok.nextToken());
            while (tok.hasMoreTokens()) {
                result.projectTargets.addElement(tok.nextToken());
            }
        }
        catch (Throwable t) {}
        return result;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChange().removePropertyChangeListener(listener);
    }

    public void setBuildFileName(String newBuildFileName) {
        String oldValue = this.buildFileName;
        this.buildFileName = newBuildFileName;
        this.setProjectInitialized(false);
        this.firePropertyChange("buildFileName", oldValue, this.buildFileName);
    }

    public void setOutputMessageLevel(int newOutputMessageLevel) {
        int oldValue = this.outputMessageLevel;
        this.outputMessageLevel = newOutputMessageLevel;
        this.firePropertyChange("outputMessageLevel", new Integer(oldValue), new Integer(this.outputMessageLevel));
    }

    private void setOutputMessageLevel(String outputMessageLevel) {
        int level = Integer.parseInt(outputMessageLevel);
        this.setOutputMessageLevel(level);
    }

    private void setProjectInitialized(boolean initialized) {
        Boolean oldValue = new Boolean(this.projectInitialized);
        this.projectInitialized = initialized;
        this.firePropertyChange("projectInitialized", oldValue, new Boolean(this.projectInitialized));
    }

    public void setTarget(String newTarget) {
        String oldValue = this.target;
        this.target = newTarget;
        this.firePropertyChange("target", oldValue, this.target);
    }

    public void setVAJProjectName(String newVAJProjectName) {
        String oldValue = this.vajProjectName;
        this.vajProjectName = newVAJProjectName;
        this.firePropertyChange("VAJProjectName", oldValue, this.vajProjectName);
    }

    public void updateTargetList() {
        this.project = new Project();
        this.initProject();
        this.projectTargets.removeAllElements();
        Enumeration ptargets = this.project.getTargets().elements();
        while (ptargets.hasMoreElements()) {
            Target currentTarget = (Target)ptargets.nextElement();
            if (currentTarget.getDescription() == null) continue;
            String targetName = currentTarget.getName();
            int pos = VAJBuildInfo.findTargetPosition(this.projectTargets, targetName);
            this.projectTargets.insertElementAt(targetName, pos);
        }
    }

    public void cancelBuild() {
        this.buildThread.interrupt();
    }

    public void executeProject(BuildListener logger) {
        this.projectLogger = logger;
        try {
            this.buildThread = new Thread(this);
            this.buildThread.setPriority(1);
            this.buildThread.start();
        }
        catch (RuntimeException exc) {
            RuntimeException error = exc;
            throw exc;
        }
        catch (Error err) {
            Error error = err;
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            InterruptedChecker ic = new InterruptedChecker(this.projectLogger);
            BuildEvent e = new BuildEvent(this.getProject());
            try {
                try {
                    ic.buildStarted(e);
                    if (!this.isProjectInitialized()) {
                        this.initProject();
                    }
                    this.project.addBuildListener((BuildListener)ic);
                    this.project.executeTarget(this.target);
                    ic.buildFinished(e);
                }
                catch (Throwable t) {
                    e.setException(t);
                    ic.buildFinished(e);
                    Object var5_5 = null;
                    this.project.removeBuildListener((BuildListener)ic);
                    return;
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.project.removeBuildListener((BuildListener)ic);
                throw throwable;
            }
            this.project.removeBuildListener((BuildListener)ic);
            return;
        }
        catch (Throwable t2) {
            System.out.println("unexpected exception!");
            t2.printStackTrace();
            return;
        }
    }

    public static class BuildInterruptedException
    extends BuildException {
        public String toString() {
            return "BUILD INTERRUPTED";
        }
    }

    private class InterruptedChecker
    implements BuildListener {
        BuildListener wrappedListener;

        public InterruptedChecker(BuildListener listener) {
            this.wrappedListener = listener;
        }

        protected void checkInterrupted() {
            if (VAJBuildInfo.this.buildThread.isInterrupted()) {
                throw new BuildInterruptedException();
            }
        }

        public void buildFinished(BuildEvent event) {
            this.wrappedListener.buildFinished(event);
            this.checkInterrupted();
        }

        public void buildStarted(BuildEvent event) {
            this.wrappedListener.buildStarted(event);
            this.checkInterrupted();
        }

        public void messageLogged(BuildEvent event) {
            this.wrappedListener.messageLogged(event);
            this.checkInterrupted();
        }

        public void targetFinished(BuildEvent event) {
            this.wrappedListener.targetFinished(event);
            this.checkInterrupted();
        }

        public void targetStarted(BuildEvent event) {
            this.wrappedListener.targetStarted(event);
            this.checkInterrupted();
        }

        public void taskFinished(BuildEvent event) {
            this.wrappedListener.taskFinished(event);
            this.checkInterrupted();
        }

        public void taskStarted(BuildEvent event) {
            this.wrappedListener.taskStarted(event);
            this.checkInterrupted();
        }
    }
}

