/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.wsil;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.wsil.Abstract;
import org.apache.wsil.Description;
import org.apache.wsil.Inspection;
import org.apache.wsil.QName;
import org.apache.wsil.Service;
import org.apache.wsil.WSILDocument;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionBuilder;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.wsdl.ImplementedBinding;
import org.apache.wsil.extension.wsdl.Reference;
import org.apache.wsil.extension.wsdl.ReferencedService;
import org.apache.wsil.xml.XMLWriter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.uri.IURIFactory;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.IllegalArgumentsException;
import org.eclipse.wst.ws.internal.parser.wsil.WSILMessages;
import org.eclipse.wst.ws.internal.parser.wsil.WWWAuthenticationException;
import org.eclipse.wst.ws.internal.parser.wsil.WWWAuthenticationHandler;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AddWSDLToWSILCommand
extends AbstractDataModelOperation {
    public static final String ARG_WSIL = "-wsil";
    public static final String ARG_WSDL = "-wsdl";
    public static final String ARG_RESOLVE_WSDL = "-resolvewsdl";
    public static final String ARG_HTTP_BASIC_AUTH_USERNAME = "-httpusername";
    public static final String ARG_HTTP_BASIC_AUTH_PASSWORD = "-httppassword";
    private WWWAuthenticationHandler wwwAuthHandler_ = null;
    private String[] args_;
    private String wsil_;
    private ArrayList wsdls_;
    private boolean resolveWSDL_;
    private String httpUsername_;
    private String httpPassword_;
    private final char FWD_SLASH = (char)47;
    private final char BWD_SLASH = (char)92;
    private final String parentDir = "../";

    public AddWSDLToWSILCommand() {
        this.args_ = new String[0];
        this.clearParsedArgs();
    }

    private void clearParsedArgs() {
        this.wsil_ = null;
        if (this.wsdls_ == null) {
            this.wsdls_ = new ArrayList();
        } else {
            this.wsdls_.clear();
        }
        this.resolveWSDL_ = false;
        this.httpUsername_ = null;
        this.httpPassword_ = null;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status;
        IEnvironment environment = this.getEnvironment();
        IURIFactory uriFactory = environment.getURIFactory();
        try {
            this.parseArguments();
        }
        catch (IllegalArgumentsException iae) {
            return StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_ILLEGAL_ARGUMENTS, (Throwable)iae);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_INVALID_ARGUMENTS, (Throwable)e);
        }
        WSILDocument wsilDocument = null;
        URL wsilURL = null;
        try {
            wsilDocument = WSILDocument.newInstance();
            wsilURL = new URL(this.wsil_);
        }
        catch (MalformedURLException murle) {
            IStatus status2 = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_INVALID_WSIL_URI, (Throwable)murle);
            environment.getStatusHandler().reportError(status2);
            return status2;
        }
        catch (WSILException wsile) {
            IStatus status3 = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_UNEXPECTED_EXCEPTION, (Throwable)wsile);
            environment.getStatusHandler().reportError(status3);
            return status3;
        }
        try {
            InputStream is = uriFactory.newURI(wsilURL).getInputStream();
            if (is != null) {
                wsilDocument.read((Reader)new InputStreamReader(is));
                is.close();
            }
        }
        catch (URIException urie) {
            IStatus status4 = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_UNEXPECTED_EXCEPTION, (Throwable)urie);
            environment.getStatusHandler().reportError(status4);
            return status4;
        }
        catch (IOException ioe) {
            IStatus status5 = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_UNEXPECTED_EXCEPTION, (Throwable)ioe);
            environment.getStatusHandler().reportError(status5);
            return status5;
        }
        catch (WSILException wsile) {
            IStatus status6 = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_UNEXPECTED_EXCEPTION, (Throwable)wsile);
            environment.getStatusHandler().reportError(status6);
            return status6;
        }
        String httpUsername = null;
        String httpPassword = null;
        if (this.wsdls_.size() == 1 && this.httpUsername_ != null && this.httpPassword_ != null) {
            httpUsername = this.httpUsername_;
            httpPassword = this.httpPassword_;
        }
        Iterator it = this.wsdls_.iterator();
        while (it.hasNext()) {
            IStatus status7;
            block24: {
                String wsdl = (String)it.next();
                status7 = null;
                try {
                    status7 = this.internalExecute(environment, wsilDocument, this.platform2File(uriFactory, this.wsil_), wsdl, httpUsername, httpPassword);
                }
                catch (WWWAuthenticationException wwwae) {
                    if (this.wwwAuthHandler_ != null && httpUsername == null && httpPassword == null) {
                        this.wwwAuthHandler_.handleWWWAuthentication(wwwae);
                        String handlerUsername = this.wwwAuthHandler_.getUsername();
                        String handlerPassword = this.wwwAuthHandler_.getPassword();
                        if (handlerUsername != null && handlerPassword != null) {
                            try {
                                status7 = this.internalExecute(environment, wsilDocument, this.platform2File(uriFactory, this.wsil_), wsdl, handlerUsername, handlerPassword);
                            }
                            catch (WWWAuthenticationException wwwae2) {
                                IStatus wwwaeStatus = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_UNRESOLVABLE_WSDL, (Throwable)wwwae2.getIOException());
                                environment.getStatusHandler().reportError(wwwaeStatus);
                                return wwwaeStatus;
                            }
                        }
                    }
                    if (status7 != null) break block24;
                    IStatus s = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_UNRESOLVABLE_WSDL, (Throwable)wwwae.getIOException());
                    environment.getStatusHandler().reportError(s);
                    return s;
                }
            }
            if (status7.getSeverity() == 0) continue;
            return status7;
        }
        try {
            XMLWriter xmlWriter = new XMLWriter();
            OutputStream os = uriFactory.newURI(wsilURL).getOutputStream();
            if (os == null) {
                throw new IOException();
            }
            xmlWriter.writeDocument(wsilDocument, os);
            os.close();
        }
        catch (URIException urie) {
            status = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_WRITE_WSIL, (Throwable)urie);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        catch (IOException ioe) {
            status = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_WRITE_WSIL, (Throwable)ioe);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        catch (WSILException wsile) {
            status = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_WRITE_WSIL, (Throwable)wsile);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus internalExecute(IEnvironment environment, WSILDocument wsilDocument, String wsil, String wsdl, String httpUsername, String httpPassword) throws WWWAuthenticationException {
        Definition definition = null;
        ArrayList wsdlService = new ArrayList();
        ArrayList wsdlBinding = new ArrayList();
        if (this.resolveWSDL_) {
            try {
                definition = this.parseWSDL(wsdl, wsdlService, wsdlBinding, httpUsername, httpPassword);
            }
            catch (MalformedURLException murle) {
                IStatus status = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_INVALID_WSDL_URI, (Throwable)murle);
                environment.getStatusHandler().reportError(status);
                return status;
            }
            catch (IOException ioe) {
                IStatus status = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_UNRESOLVABLE_WSDL, (Throwable)ioe);
                environment.getStatusHandler().reportError(status);
                return status;
            }
            catch (ParserConfigurationException pce) {
                IStatus status = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_UNEXPECTED_EXCEPTION, (Throwable)pce);
                environment.getStatusHandler().reportError(status);
                return status;
            }
            catch (SAXException saxe) {
                IStatus status = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_MALFORMED_WSDL, (Throwable)saxe);
                environment.getStatusHandler().reportError(status);
                return status;
            }
        }
        try {
            Inspection inspection = wsilDocument.getInspection();
            Service service = wsilDocument.createService();
            if (definition != null) {
                Element documentation = definition.getDocumentationElement();
                Abstract serviceAbstract = wsilDocument.createAbstract();
                serviceAbstract.setText(this.Element2String(documentation));
                service.addAbstract(serviceAbstract);
            }
            Description desc = wsilDocument.createDescription();
            desc.setReferencedNamespace("http://schemas.xmlsoap.org/wsdl/");
            desc.setLocation(this.getRelativeURI(wsil, wsdl));
            ExtensionBuilder extBuilder = wsilDocument.getExtensionRegistry().getBuilder("http://schemas.xmlsoap.org/ws/2001/10/inspection/wsdl/");
            if (definition == null || this.endpointPresent(definition)) {
                Iterator it = wsdlService.iterator();
                while (it.hasNext()) {
                    Reference reference = (Reference)extBuilder.createElement(new QName("http://schemas.xmlsoap.org/ws/2001/10/inspection/wsdl/", "reference"));
                    reference.setEndpointPresent(new Boolean(true));
                    ReferencedService refService = (ReferencedService)extBuilder.createElement(new QName("http://schemas.xmlsoap.org/ws/2001/10/inspection/wsdl/", "referencedService"));
                    refService.setReferencedServiceName((QName)it.next());
                    reference.setReferencedService(refService);
                    desc.setExtensionElement((ExtensionElement)reference);
                }
            } else {
                Reference reference = (Reference)extBuilder.createElement(new QName("http://schemas.xmlsoap.org/ws/2001/10/inspection/wsdl/", "reference"));
                reference.setEndpointPresent(new Boolean(false));
                Iterator it = wsdlBinding.iterator();
                while (it.hasNext()) {
                    ImplementedBinding binding = (ImplementedBinding)extBuilder.createElement(new QName("http://schemas.xmlsoap.org/ws/2001/10/inspection/wsdl/", "implementedBinding"));
                    binding.setBindingName((QName)it.next());
                    reference.addImplementedBinding(binding);
                }
            }
            service.addDescription(desc);
            inspection.addService(service);
        }
        catch (WSILException wsile) {
            IStatus status = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_UNEXPECTED_EXCEPTION, (Throwable)wsile);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        catch (Throwable t) {
            IStatus status = StatusUtils.errorStatus((String)WSILMessages.MSG_ERROR_UNEXPECTED_EXCEPTION, (Throwable)t);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        return Status.OK_STATUS;
    }

    public boolean isUndoable() {
        return false;
    }

    public IStatus undo(IEnvironment environment) {
        return Status.OK_STATUS;
    }

    private Definition parseWSDL(String wsdl, ArrayList wsdlService, ArrayList wsdlBinding, String httpUsername, String httpPassword) throws MalformedURLException, IOException, ParserConfigurationException, SAXException, WWWAuthenticationException {
        WebServicesParser wsParser = new WebServicesParser(wsdl);
        if (httpUsername != null && httpPassword != null) {
            wsParser.setHTTPBasicAuthUsername(httpUsername);
            wsParser.setHTTPBasicAuthPassword(httpPassword);
        }
        wsParser.parse(0);
        Definition definition = wsParser.getWSDLDefinition(wsdl);
        if (definition != null) {
            Map services = definition.getServices();
            Iterator it = services.keySet().iterator();
            while (it.hasNext()) {
                wsdlService.add(this.parseQName((javax.xml.namespace.QName)it.next()));
            }
            Map bindings = definition.getBindings();
            Iterator it2 = bindings.keySet().iterator();
            while (it2.hasNext()) {
                wsdlBinding.add(this.parseQName((javax.xml.namespace.QName)it2.next()));
            }
        }
        return definition;
    }

    private boolean endpointPresent(Definition definition) {
        return definition.getServices().size() > 0;
    }

    public String[] getArguments() {
        return this.args_;
    }

    public void setArguments(String[] args) {
        this.args_ = args;
    }

    public WWWAuthenticationHandler getWWWAuthenticationHandler() {
        return this.wwwAuthHandler_;
    }

    public void setWWWAuthenticationHandler(WWWAuthenticationHandler wwwAuthHandler) {
        this.wwwAuthHandler_ = wwwAuthHandler;
    }

    private void parseArguments() throws IllegalArgumentsException {
        this.clearParsedArgs();
        int i = 0;
        while (i < this.args_.length) {
            if (ARG_WSIL.equals(this.args_[i])) {
                this.wsil_ = this.args_[++i];
            } else if (ARG_WSDL.equals(this.args_[i])) {
                this.wsdls_.add(this.args_[++i]);
            } else if (ARG_RESOLVE_WSDL.equals(this.args_[i])) {
                this.resolveWSDL_ = true;
            } else if (ARG_HTTP_BASIC_AUTH_USERNAME.equals(this.args_[i])) {
                this.httpUsername_ = this.args_[++i];
            } else if (ARG_HTTP_BASIC_AUTH_PASSWORD.equals(this.args_[i])) {
                this.httpPassword_ = this.args_[++i];
            } else {
                throw new IllegalArgumentsException(this.args_[i]);
            }
            ++i;
        }
    }

    private QName parseQName(javax.xml.namespace.QName qname) {
        return new QName(qname.getNamespaceURI(), qname.getLocalPart());
    }

    private String Element2String(Element e) throws TransformerConfigurationException, TransformerException, IOException {
        byte[] b = new byte[]{};
        if (e != null) {
            DOMSource domSource = new DOMSource(e);
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            serializer.transform(domSource, new StreamResult(baos));
            baos.close();
            b = baos.toByteArray();
        }
        return new String(b);
    }

    private String platform2File(IURIFactory uriFactory, String uri) {
        try {
            return uriFactory.newURI(uri).asFile().toURL().toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return uri;
        }
    }

    private String getRelativeURI(String baseURI, String targetURI) {
        try {
            String baseURICopy = baseURI.replace('\\', '/');
            String targetURICopy = targetURI.replace('\\', '/');
            int matchingIndex = -1;
            int index = targetURICopy.indexOf(47);
            while (index != -1) {
                if (!baseURICopy.startsWith(targetURICopy.substring(0, index + 1))) break;
                matchingIndex = index;
                index = targetURICopy.indexOf(47, index + 1);
            }
            if (matchingIndex != -1) {
                int slashCount = -1;
                int fromIndex = matchingIndex;
                while (fromIndex != -1) {
                    ++slashCount;
                    fromIndex = baseURICopy.indexOf(47, fromIndex + 1);
                }
                StringBuffer relativeURI = new StringBuffer();
                int i = 0;
                while (i < slashCount) {
                    relativeURI.append("../");
                    ++i;
                }
                relativeURI.append(targetURI.substring(matchingIndex + 1, targetURI.length()));
                return relativeURI.toString();
            }
        }
        catch (Throwable throwable) {}
        return targetURI;
    }
}

