/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.history.IRefactoringDescriptorDeleteQuery;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEditHelper;
import org.eclipse.ltk.internal.ui.refactoring.history.ShowRefactoringHistoryControl;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public final class RefactoringPropertyPage
extends PropertyPage {
    private static String DIALOG_SETTINGS_KEY = "RefactoringPropertyPage";
    static final RefactoringDescriptorProxy[] EMPTY_DESCRIPTORS = new RefactoringDescriptorProxy[0];
    private static final String PREFERENCE_DO_NOT_WARN_DELETE = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.warn.delete.descriptor";
    private static final String PREFERENCE_DO_NOT_WARN_DELETE_ALL = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.warn.delete.history";
    private static final String SETTING_SORT = "org.eclipse.ltk.ui.refactoring.sortRefactorings";
    private boolean fHasProjectHistory = false;
    private ShowRefactoringHistoryControl fHistoryControl;
    private IWorkingCopyManager fManager = null;
    private boolean fNewSettings;
    private IDialogSettings fSettings = null;
    private Button fShareHistoryButton = null;
    static /* synthetic */ Class class$0;

    public RefactoringPropertyPage() {
        this.noDefaultAndApplyButton();
        IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fNewSettings = true;
        } else {
            this.fNewSettings = false;
            this.fSettings = section;
        }
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof IWorkbenchPreferenceContainer) {
            this.fManager = ((IWorkbenchPreferenceContainer)container).getWorkingCopyManager();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.fHistoryControl = new ShowRefactoringHistoryControl(composite, new RefactoringHistoryControlConfiguration(this.getCurrentProject(), true, false){

            public String getProjectPattern() {
                return RefactoringUIMessages.RefactoringPropertyPage_project_pattern;
            }
        }){

            protected void createEditButton(Composite control) {
            }
        };
        this.fHistoryControl.createControl();
        boolean sortProjects = true;
        IDialogSettings settings = this.fSettings;
        if (settings != null) {
            sortProjects = settings.getBoolean(SETTING_SORT);
        }
        if (sortProjects) {
            this.fHistoryControl.sortByProjects();
        } else {
            this.fHistoryControl.sortByDate();
        }
        this.fHistoryControl.getDeleteAllButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                IProject project = RefactoringPropertyPage.this.getCurrentProject();
                if (project != null) {
                    IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (context == null) {
                        context = PlatformUI.getWorkbench().getProgressService();
                    }
                    IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
                    MessageDialogWithToggle dialog = null;
                    if (!store.getBoolean(PREFERENCE_DO_NOT_WARN_DELETE_ALL) && !RefactoringPropertyPage.this.fHistoryControl.getInput().isEmpty()) {
                        dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)RefactoringPropertyPage.this.getShell(), (String)RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_all_caption, (String)Messages.format(RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_all_pattern, project.getName()), (String)RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, (boolean)false, null, null);
                        store.setValue(PREFERENCE_DO_NOT_WARN_DELETE_ALL, dialog.getToggleState());
                    }
                    if (dialog == null || dialog.getReturnCode() == 2) {
                        RefactoringPropertyPage.this.promptDeleteHistory((IRunnableContext)context, project);
                    }
                }
            }
        });
        this.fHistoryControl.getDeleteButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                RefactoringDescriptorProxy[] selection = RefactoringPropertyPage.this.fHistoryControl.getCheckedDescriptors();
                if (selection.length > 0) {
                    IProject project;
                    IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (context == null) {
                        context = PlatformUI.getWorkbench().getProgressService();
                    }
                    if ((project = RefactoringPropertyPage.this.getCurrentProject()) != null) {
                        Shell shell = RefactoringPropertyPage.this.getShell();
                        RefactoringHistoryEditHelper.promptRefactoringDelete(shell, (IRunnableContext)context, RefactoringPropertyPage.this.fHistoryControl, new RefactoringDescriptorDeleteQuery(shell, selection.length), new RefactoringHistoryEditHelper.IRefactoringHistoryProvider(this, project){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ IProject val$project;
                            {
                                this.this$1 = var1_1;
                                this.val$project = iProject;
                            }

                            public RefactoringHistory getRefactoringHistory(IProgressMonitor monitor) {
                                return RefactoringHistoryService.getInstance().getProjectHistory(this.val$project, monitor);
                            }
                        }, selection);
                    }
                }
            }
        });
        Button button = this.fHistoryControl.getEditButton();
        if (button != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public final void widgetSelected(SelectionEvent event) {
                    RefactoringDescriptorProxy[] selection = RefactoringPropertyPage.this.fHistoryControl.getSelectedDescriptors();
                    if (selection.length > 0) {
                        IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (context == null) {
                            context = PlatformUI.getWorkbench().getProgressService();
                        }
                        RefactoringHistoryEditHelper.promptRefactoringDetails((IRunnableContext)context, RefactoringPropertyPage.this.fHistoryControl, selection[0]);
                    }
                }
            });
        }
        this.fShareHistoryButton = new Button(composite, 32);
        this.fShareHistoryButton.setText(RefactoringUIMessages.RefactoringPropertyPage_share_message);
        this.fShareHistoryButton.setData((Object)"org.eclipse.ltk.core.refactoring.enable.project.refactoring.history");
        GridData data = new GridData(256);
        data.verticalIndent = this.convertHeightInCharsToPixels(1) / 2;
        this.fShareHistoryButton.setLayoutData((Object)data);
        this.fShareHistoryButton.setSelection(this.hasSharedRefactoringHistory());
        new Label(composite, 0);
        IProject project = this.getCurrentProject();
        if (project != null) {
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            this.handleInputEvent((IRunnableContext)context, project);
        }
        this.applyDialogFont(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.refactoring_property_page");
        return composite;
    }

    private IProject getCurrentProject() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IProject)iAdaptable.getAdapter((Class)clazz);
    }

    private IEclipsePreferences getPreferences(IWorkingCopyManager manager, IScopeContext context) {
        IEclipsePreferences preferences = context.getNode("org.eclipse.ltk.core.refactoring");
        if (manager != null) {
            return manager.getWorkingCopy(preferences);
        }
        return preferences;
    }

    private void handleInputEvent(IRunnableContext context, final IProject project) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)project);
        try {
            context.run(false, false, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IRefactoringHistoryService service = RefactoringCore.getHistoryService();
                    try {
                        service.connect();
                        RefactoringPropertyPage.this.fHistoryControl.setInput(service.getProjectHistory(project, monitor));
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        service.disconnect();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    service.disconnect();
                }
            });
        }
        catch (InvocationTargetException exception) {
            RefactoringUIPlugin.log(exception);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean hasSharedRefactoringHistory() {
        IProject project = this.getCurrentProject();
        if (project != null) {
            return RefactoringHistoryService.getInstance().hasSharedRefactoringHistory(project);
        }
        return false;
    }

    protected void performDefaults() {
        super.performDefaults();
        IProject project = this.getCurrentProject();
        if (project != null) {
            this.setPreference(this.fManager, (IScopeContext)new ProjectScope(project), "org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", null);
        }
    }

    public boolean performOk() {
        if (this.fNewSettings) {
            IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
            this.fSettings = section = settings.addNewSection(DIALOG_SETTINGS_KEY);
        }
        this.fSettings.put(SETTING_SORT, this.fHistoryControl.isSortByProjects());
        final IProject project = this.getCurrentProject();
        if (project != null) {
            this.setPreference(this.fManager, (IScopeContext)new ProjectScope(project), "org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", Boolean.valueOf(this.fShareHistoryButton.getSelection()).toString());
        }
        if (this.fManager != null) {
            try {
                this.fManager.applyChanges();
                final RefactoringHistoryService service = RefactoringHistoryService.getInstance();
                final boolean history = service.hasSharedRefactoringHistory(project);
                if (history != this.fHasProjectHistory && project != null) {
                    Job job = new Job(history ? RefactoringUIMessages.RefactoringPropertyPage_sharing_refactoring_history : RefactoringUIMessages.RefactoringPropertyPage_unsharing_refactoring_history){

                        public final IStatus run(IProgressMonitor monitor) {
                            try {
                                service.setSharedRefactoringHistory(project, history, monitor);
                            }
                            catch (CoreException exception) {
                                RefactoringUIPlugin.log(exception);
                                return exception.getStatus();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setRule((ISchedulingRule)project);
                    job.setPriority(20);
                    job.schedule();
                }
            }
            catch (BackingStoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
        return super.performOk();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void promptDeleteHistory(IRunnableContext context, final IProject project) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)project);
        final RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        try {
            service.connect();
            try {
                final Shell shell = this.getShell();
                context.run(false, true, new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, 100);
                            try {
                                service.deleteRefactoringHistory(project, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                            }
                            catch (CoreException exception) {
                                Throwable throwable = exception.getStatus().getException();
                                if (!(throwable instanceof IOException)) throw new InvocationTargetException(exception);
                                shell.getDisplay().syncExec(new Runnable(this, shell, throwable){
                                    final /* synthetic */ 10 this$1;
                                    private final /* synthetic */ Shell val$shell;
                                    private final /* synthetic */ Throwable val$throwable;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$shell = shell;
                                        this.val$throwable = throwable;
                                    }

                                    public void run() {
                                        MessageDialog.openError((Shell)this.val$shell, (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)this.val$throwable.getLocalizedMessage());
                                    }
                                });
                            }
                            RefactoringHistory history = service.getProjectHistory(project, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                            shell.getDisplay().syncExec(new Runnable(this, history){
                                final /* synthetic */ 10 this$1;
                                private final /* synthetic */ RefactoringHistory val$history;
                                {
                                    this.this$1 = var1_1;
                                    this.val$history = refactoringHistory;
                                }

                                public void run() {
                                    RefactoringPropertyPage.access$3(10.access$0(this.this$1)).setInput(this.val$history);
                                    RefactoringPropertyPage.access$3(10.access$0(this.this$1)).setCheckedDescriptors(EMPTY_DESCRIPTORS);
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            monitor.done();
                            throw throwable;
                        }
                        {
                            Object var4_7 = null;
                        }
                        monitor.done();
                    }

                    static /* synthetic */ RefactoringPropertyPage access$0(10 var0) {
                        return var0.RefactoringPropertyPage.this;
                    }
                });
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            service.disconnect();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        service.disconnect();
    }

    private void setPreference(IWorkingCopyManager manager, IScopeContext context, String key, String value) {
        IEclipsePreferences preferences = this.getPreferences(manager, context);
        if (value != null) {
            preferences.put(key, value);
        } else {
            preferences.remove(key);
        }
    }

    public void setVisible(boolean visible) {
        this.fHasProjectHistory = this.hasSharedRefactoringHistory();
        super.setVisible(visible);
    }

    private final class RefactoringDescriptorDeleteQuery
    implements IRefactoringDescriptorDeleteQuery {
        private final int fCount;
        private int fReturnCode = -1;
        private final Shell fShell;
        private boolean fWarned = false;

        public RefactoringDescriptorDeleteQuery(Shell shell, int count) {
            Assert.isNotNull((Object)shell);
            Assert.isTrue((count >= 0 ? 1 : 0) != 0);
            this.fShell = shell;
            this.fCount = count;
        }

        public boolean hasDeletions() {
            return this.fReturnCode == 2;
        }

        public RefactoringStatus proceed(RefactoringDescriptorProxy proxy) {
            IProject project = RefactoringPropertyPage.this.getCurrentProject();
            if (project != null) {
                IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
                if (!this.fWarned && !store.getBoolean(PREFERENCE_DO_NOT_WARN_DELETE)) {
                    this.fShell.getDisplay().syncExec(new Runnable(this, project, store){
                        final /* synthetic */ RefactoringDescriptorDeleteQuery this$1;
                        private final /* synthetic */ IProject val$project;
                        private final /* synthetic */ IPreferenceStore val$store;
                        {
                            this.this$1 = refactoringDescriptorDeleteQuery;
                            this.val$project = iProject;
                            this.val$store = iPreferenceStore;
                        }

                        public final void run() {
                            if (!RefactoringDescriptorDeleteQuery.access$0(this.this$1).isDisposed()) {
                                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)RefactoringDescriptorDeleteQuery.access$0(this.this$1), (String)RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_caption, (String)Messages.format(RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_pattern, new String[]{new Integer(RefactoringDescriptorDeleteQuery.access$1(this.this$1)).toString(), this.val$project.getName()}), (String)RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, (boolean)this.val$store.getBoolean(RefactoringPropertyPage.access$1()), null, null);
                                this.val$store.setValue(RefactoringPropertyPage.access$1(), dialog.getToggleState());
                                RefactoringDescriptorDeleteQuery.access$2(this.this$1, dialog.getReturnCode());
                            }
                        }
                    });
                }
                this.fWarned = true;
                if (this.fReturnCode == 2) {
                    return new RefactoringStatus();
                }
            }
            return RefactoringStatus.createErrorStatus((String)IDialogConstants.NO_LABEL);
        }

        static /* synthetic */ Shell access$0(RefactoringDescriptorDeleteQuery refactoringDescriptorDeleteQuery) {
            return refactoringDescriptorDeleteQuery.fShell;
        }

        static /* synthetic */ int access$1(RefactoringDescriptorDeleteQuery refactoringDescriptorDeleteQuery) {
            return refactoringDescriptorDeleteQuery.fCount;
        }

        static /* synthetic */ void access$2(RefactoringDescriptorDeleteQuery refactoringDescriptorDeleteQuery, int n) {
            refactoringDescriptorDeleteQuery.fReturnCode = n;
        }
    }
}

