/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.common.project.facet.core.IListener;
import org.eclipse.wst.common.project.facet.core.internal.CopyOnWriteSet;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.ui.internal.AbstractDataModel;

public final class ChangeTargetedRuntimesDataModel
extends AbstractDataModel {
    public static final String EVENT_AVAILABLE_RUNTIMES_CHANGED = "availableRuntimesChanged";
    public static final String EVENT_TARGETABLE_RUNTIMES_CHANGED = "targetableRuntimesChanged";
    public static final String EVENT_TARGETED_RUNTIMES_CHANGED = "targetedRuntimesChanged";
    public static final String EVENT_PRIMARY_RUNTIME_CHANGED = "primaryRuntimeChanged";
    private final List filters = new ArrayList();
    private final CopyOnWriteSet targetableRuntimes = new CopyOnWriteSet();
    private final CopyOnWriteSet targetedRuntimes;
    private IRuntime primaryRuntime;
    private IListener runtimeManagerListener;

    public ChangeTargetedRuntimesDataModel() {
        this.targetableRuntimes.addAll((Collection)this.getAllRuntimes());
        this.targetedRuntimes = new CopyOnWriteSet();
        this.primaryRuntime = null;
        this.runtimeManagerListener = new IListener(){

            public void handle() {
                ChangeTargetedRuntimesDataModel.this.notifyListeners(ChangeTargetedRuntimesDataModel.EVENT_AVAILABLE_RUNTIMES_CHANGED);
                ChangeTargetedRuntimesDataModel.this.refreshTargetableRuntimes();
            }
        };
        RuntimeManager.addRuntimeListener((IListener)this.runtimeManagerListener);
    }

    public synchronized void addRuntimeFilter(IRuntimeFilter filter) {
        this.filters.add(filter);
        this.refreshTargetableRuntimes();
    }

    public synchronized void removeRuntimeFilter(IRuntimeFilter filter) {
        this.filters.remove(filter);
        this.refreshTargetableRuntimes();
    }

    public synchronized Set getAllRuntimes() {
        return RuntimeManager.getRuntimes();
    }

    public synchronized Set getTargetableRuntimes() {
        return this.targetableRuntimes;
    }

    public synchronized void refreshTargetableRuntimes() {
        HashSet<IRuntime> result = new HashSet<IRuntime>();
        Iterator itr1 = this.getAllRuntimes().iterator();
        while (itr1.hasNext()) {
            IRuntime r = (IRuntime)itr1.next();
            boolean ok = true;
            Iterator itr2 = this.filters.iterator();
            while (itr2.hasNext()) {
                IRuntimeFilter filter = (IRuntimeFilter)itr2.next();
                if (filter.check(r)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            result.add(r);
        }
        if (!this.targetableRuntimes.equals(result)) {
            this.targetableRuntimes.clear();
            this.targetableRuntimes.addAll(result);
            this.notifyListeners(EVENT_TARGETABLE_RUNTIMES_CHANGED);
            boolean modified = false;
            Iterator itr = this.targetedRuntimes.iterator();
            while (itr.hasNext()) {
                IRuntime r = (IRuntime)itr.next();
                if (this.targetableRuntimes.contains((Object)r)) continue;
                itr.remove();
                modified = true;
            }
            if (modified) {
                this.notifyListeners(EVENT_TARGETED_RUNTIMES_CHANGED);
                if (this.primaryRuntime != null && !this.targetableRuntimes.contains((Object)this.primaryRuntime)) {
                    this.autoAssignPrimaryRuntime();
                }
            }
        }
    }

    public synchronized Set getTargetedRuntimes() {
        return this.targetedRuntimes;
    }

    public synchronized void setTargetedRuntimes(Set runtimes) {
        if (!this.targetedRuntimes.equals((Object)runtimes)) {
            this.targetedRuntimes.clear();
            Iterator itr = runtimes.iterator();
            while (itr.hasNext()) {
                IRuntime r = (IRuntime)itr.next();
                if (!this.targetableRuntimes.contains((Object)r)) continue;
                this.targetedRuntimes.add((Object)r);
            }
            this.notifyListeners(EVENT_TARGETED_RUNTIMES_CHANGED);
            if (this.primaryRuntime == null || !this.targetedRuntimes.contains((Object)this.primaryRuntime)) {
                this.autoAssignPrimaryRuntime();
            }
        }
    }

    public synchronized void addTargetedRuntime(IRuntime runtime) {
        if (runtime == null) {
            throw new NullPointerException();
        }
        this.targetedRuntimes.add((Object)runtime);
        this.notifyListeners(EVENT_TARGETED_RUNTIMES_CHANGED);
        if (this.primaryRuntime == null) {
            this.primaryRuntime = runtime;
            this.notifyListeners(EVENT_PRIMARY_RUNTIME_CHANGED);
        }
    }

    public synchronized void removeTargetedRuntime(IRuntime runtime) {
        if (runtime == null) {
            throw new NullPointerException();
        }
        if (this.targetedRuntimes.remove((Object)runtime)) {
            this.notifyListeners(EVENT_TARGETED_RUNTIMES_CHANGED);
            if (runtime.equals(this.primaryRuntime)) {
                this.autoAssignPrimaryRuntime();
            }
        }
    }

    public synchronized IRuntime getPrimaryRuntime() {
        return this.primaryRuntime;
    }

    public synchronized void setPrimaryRuntime(IRuntime runtime) {
        if (!ChangeTargetedRuntimesDataModel.equals(this.primaryRuntime, runtime)) {
            if (runtime == null && this.targetedRuntimes.size() > 0) {
                throw new IllegalArgumentException();
            }
            if (this.targetedRuntimes.contains((Object)runtime)) {
                this.primaryRuntime = runtime;
            }
            this.notifyListeners(EVENT_PRIMARY_RUNTIME_CHANGED);
        }
    }

    private void autoAssignPrimaryRuntime() {
        this.primaryRuntime = this.targetedRuntimes.isEmpty() ? null : (IRuntime)this.targetedRuntimes.iterator().next();
        this.notifyListeners(EVENT_PRIMARY_RUNTIME_CHANGED);
    }

    public void dispose() {
        RuntimeManager.removeRuntimeListener((IListener)this.runtimeManagerListener);
    }

    private static boolean equals(IRuntime r1, IRuntime r2) {
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        return r1.equals(r2);
    }

    public static interface IRuntimeFilter {
        public boolean check(IRuntime var1);
    }
}

