/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.HelpSystem;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.ui.internal.IHelpUIConstants;
import org.eclipse.help.ui.internal.views.HyperlinkTreePart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IndexPart
extends HyperlinkTreePart
implements IHelpUIConstants {
    private RoleFilter roleFilter = new RoleFilter();

    public IndexPart(Composite parent, FormToolkit toolkit, IToolBarManager tbm) {
        super(parent, toolkit, tbm);
    }

    protected void configureTreeViewer() {
        this.treeViewer.setContentProvider((IContentProvider)new IndexProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new IndexLabelProvider());
    }

    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        super.init(parent, id, memento);
        if (parent.isFilteredByRoles()) {
            this.treeViewer.addFilter((ViewerFilter)this.roleFilter);
        }
    }

    protected void doOpen(Object obj) {
        if (obj instanceof IHelpResource) {
            this.parent.showURL(((IHelpResource)obj).getHref());
        } else if (obj instanceof IIndexEntry) {
            IHelpResource[] topics;
            IIndexEntry entry = (IIndexEntry)obj;
            if (this.getChildren(entry).length > 0) {
                this.treeViewer.setExpandedState(obj, !this.treeViewer.getExpandedState(obj));
            }
            if ((topics = entry.getTopics()).length == 1) {
                this.parent.showURL(topics[0].getHref());
            }
        }
    }

    protected boolean canAddBookmarks() {
        return true;
    }

    public void saveState(IMemento memento) {
    }

    public void toggleRoleFilter() {
        if (this.parent.isFilteredByRoles()) {
            this.treeViewer.addFilter((ViewerFilter)this.roleFilter);
        } else {
            this.treeViewer.removeFilter((ViewerFilter)this.roleFilter);
        }
    }

    public void refilter() {
        this.treeViewer.refresh();
    }

    private Object[] getChildren(IIndexEntry entry) {
        IHelpResource[] topics = entry.getTopics();
        Object[] subentries = entry.getSubentries();
        if (topics.length <= 1) {
            return subentries;
        }
        Object[] childrens = new Object[topics.length + subentries.length];
        System.arraycopy(topics, 0, childrens, 0, topics.length);
        System.arraycopy(subentries, 0, childrens, topics.length, subentries.length);
        return childrens;
    }

    protected Tree getTreeWidget() {
        return this.treeViewer.getTree();
    }

    class IndexLabelProvider
    extends LabelProvider {
        IndexLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof IIndexEntry) {
                return ((IIndexEntry)obj).getKeyword();
            }
            if (obj instanceof IHelpResource) {
                return ((IHelpResource)obj).getLabel();
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            return super.getImage(obj);
        }
    }

    class IndexProvider
    implements ITreeContentProvider {
        IndexProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == IndexPart.this) {
                return HelpSystem.getIndex().getEntries();
            }
            if (parentElement instanceof IIndexEntry) {
                return IndexPart.this.getChildren((IIndexEntry)parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class RoleFilter
    extends ViewerFilter {
        RoleFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IIndexEntry) {
                return this.isNotFiltered((IIndexEntry)element);
            }
            if (element instanceof IHelpResource) {
                return this.isNotFiltered((IHelpResource)element);
            }
            return false;
        }

        private boolean isNotFiltered(IIndexEntry entry) {
            IHelpResource[] topics = entry.getTopics();
            int i = 0;
            while (i < topics.length) {
                if (this.isNotFiltered(topics[i])) {
                    return true;
                }
                ++i;
            }
            IIndexEntry[] subentries = entry.getSubentries();
            int i2 = 0;
            while (i2 < subentries.length) {
                if (this.isNotFiltered(subentries[i2])) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        private boolean isNotFiltered(IHelpResource topic) {
            return HelpBasePlugin.getActivitySupport().isEnabled(topic.getHref());
        }
    }
}

