/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class ServerType
implements IServerType {
    private static final int DEFAULT_TIMEOUT = 300000;
    private IConfigurationElement element;

    public ServerType(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        try {
            return this.element.getAttribute("id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        try {
            return this.element.getAttribute("name");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean startBeforePublish() {
        try {
            return "true".equals(this.element.getAttribute("startBeforePublish"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getDescription() {
        try {
            return this.element.getAttribute("description");
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected ServerDelegate createServerDelegate() throws CoreException {
        try {
            return (ServerDelegate)this.element.createExecutableExtension("class");
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected ServerBehaviourDelegate createServerBehaviourDelegate() throws CoreException {
        try {
            return (ServerBehaviourDelegate)this.element.createExecutableExtension("behaviourClass");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IRuntimeType getRuntimeType() {
        String typeId;
        block3: {
            try {
                typeId = this.element.getAttribute("runtimeTypeId");
                if (typeId != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return ServerCore.findRuntimeType(typeId);
    }

    public boolean hasRuntime() {
        try {
            String s = this.element.getAttribute("runtime");
            return "true".equals(s);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ILaunchConfigurationType getLaunchConfigurationType() {
        String launchConfigId;
        block3: {
            try {
                launchConfigId = this.element.getAttribute("launchConfigId");
                if (launchConfigId != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager.getLaunchConfigurationType(launchConfigId);
    }

    public boolean supportsLaunchMode(String launchMode) {
        String mode;
        block4: {
            try {
                ILaunchConfigurationType configType = this.getLaunchConfigurationType();
                if (configType != null) {
                    return configType.supportsMode(launchMode);
                }
                mode = this.element.getAttribute("launchModes");
                if (mode != null) break block4;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return mode.indexOf(launchMode) >= 0;
    }

    public boolean supportsRemoteHosts() {
        try {
            String hosts = this.element.getAttribute("supportsRemoteHosts");
            return hosts != null && hosts.toLowerCase().equals("true");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public byte getInitialState() {
        String stateString;
        block6: {
            try {
                stateString = this.element.getAttribute("initialState");
                if (stateString != null) {
                    stateString = stateString.toLowerCase();
                }
                if (!"stopped".equals(stateString)) break block6;
                return 4;
            }
            catch (Exception exception) {}
        }
        if ("started".equals(stateString)) {
            return 2;
        }
        return 0;
    }

    public boolean hasServerConfiguration() {
        try {
            return "true".equalsIgnoreCase(this.element.getAttribute("hasConfiguration"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IServerWorkingCopy createServer(String id, IFile file, IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        if (this.element == null) {
            return null;
        }
        if (id == null || id.length() == 0) {
            id = ServerPlugin.generateId();
        }
        ServerWorkingCopy swc = new ServerWorkingCopy(id, file, runtime, this);
        swc.setRuntime(runtime);
        swc.setDefaults(monitor);
        if (swc.getServerType().hasServerConfiguration()) {
            swc.importRuntimeConfiguration(runtime, null);
        }
        return swc;
    }

    protected static IRuntime[] getRuntimes(IRuntimeType runtimeType) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                if (runtimes[i].getRuntimeType() != null && runtimes[i].getRuntimeType().equals(runtimeType)) {
                    list.add(runtimes[i]);
                }
                ++i;
            }
        }
        IRuntime[] r = new IRuntime[list.size()];
        list.toArray(r);
        return r;
    }

    public IServerWorkingCopy createServer(String id, IFile file, IProgressMonitor monitor) throws CoreException {
        if (this.element == null) {
            return null;
        }
        if (id == null || id.length() == 0) {
            id = ServerPlugin.generateId();
        }
        IRuntime runtime = null;
        if (this.hasRuntime()) {
            IRuntimeType runtimeType = this.getRuntimeType();
            IRuntime[] runtimes = ServerType.getRuntimes(runtimeType);
            if (runtimes != null && runtimes.length > 0) {
                runtime = runtimes[0];
            } else {
                try {
                    IRuntimeWorkingCopy runtimeWC = runtimeType.createRuntime(String.valueOf(id) + "-runtime", monitor);
                    ServerUtil.setRuntimeDefaultName(runtimeWC);
                    runtime = runtimeWC;
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Couldn't create runtime", e);
                }
            }
        }
        ServerWorkingCopy swc = new ServerWorkingCopy(id, file, runtime, this);
        ServerUtil.setServerDefaultName(swc);
        if (runtime != null) {
            swc.setRuntime(runtime);
        }
        swc.setDefaults(monitor);
        if (swc.getServerType().hasServerConfiguration()) {
            swc.importRuntimeConfiguration(runtime, null);
        }
        return swc;
    }

    public static IProject getServerProject() throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects != null) {
            int size = projects.length;
            int i = 0;
            while (i < size) {
                if (ServerPlugin.getProjectProperties(projects[i]).isServerProject()) {
                    return projects[i];
                }
                ++i;
            }
        }
        String s = ServerType.findUnusedServerProjectName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(s);
        project.create(null);
        project.open(null);
        ServerPlugin.getProjectProperties(project).setServerProject(true, null);
        return project;
    }

    protected static String findUnusedServerProjectName() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String name = NLS.bind((String)Messages.defaultServerProjectName, (Object)"").trim();
        int count = 1;
        while (root.getProject(name).exists()) {
            name = NLS.bind((String)Messages.defaultServerProjectName, (Object)String.valueOf(++count)).trim();
        }
        return name;
    }

    public int getStartTimeout() {
        int timeout = -1;
        try {
            int i = Integer.parseInt(this.element.getAttribute("startTimeout"));
            int s = ServerPreferences.getInstance().getMachineSpeed();
            timeout = i * (10 - s) / 5;
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            if (timeout <= 0) {
                timeout = 300000;
            }
            return timeout;
        }
    }

    public int getStopTimeout() {
        int timeout = -1;
        try {
            timeout = Integer.parseInt(this.element.getAttribute("stopTimeout"));
        }
        catch (NumberFormatException numberFormatException) {}
        if (timeout <= 0) {
            timeout = 300000;
        }
        return timeout;
    }

    public void dispose() {
        this.element = null;
    }

    public String getNamespace() {
        if (this.element == null) {
            return null;
        }
        return this.element.getDeclaringExtension().getContributor().getName();
    }

    public String toString() {
        return "ServerType[" + this.getId() + "]";
    }
}

