/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.ServerMonitorDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class DefaultMonitorDelegate
extends ServerMonitorDelegate {
    protected Map monitors = new HashMap();

    public int startMonitoring(IServer server, ServerPort port, int monitorPort) throws CoreException {
        try {
            IMonitor monitor = (IMonitor)this.monitors.get(port);
            int mport = -1;
            if (monitor == null) {
                mport = monitorPort;
                if (mport == -1) {
                    mport = SocketUtil.findUnusedPort((int)5000, (int)15000);
                }
                IMonitorWorkingCopy wc = MonitorCore.createMonitor();
                wc.setLocalPort(mport);
                wc.setRemoteHost(server.getHost());
                wc.setRemotePort(port.getPort());
                if ("HTTP".equals(port.getProtocol())) {
                    wc.setProtocol("HTTP");
                }
                monitor = wc.save();
            } else {
                mport = monitor.getLocalPort();
            }
            monitor.start();
            this.monitors.put(port, monitor);
            return mport;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not start monitoring", e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", 0, NLS.bind((String)Messages.errorStartingMonitor, (Object)e.getLocalizedMessage()), null));
        }
    }

    public void stopMonitoring(IServer server, ServerPort port) {
        try {
            IMonitor monitor = (IMonitor)this.monitors.get(port);
            if (monitor != null) {
                monitor.stop();
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not stop monitoring", e);
        }
    }
}

