/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.ini4j.Convert;
import org.ini4j.Ini;
import org.ini4j.IniHandler;
import org.ini4j.IniParser;
import org.ini4j.InvalidIniFormatException;
import org.ini4j.ServiceFinder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IniParser {
    public static final String COMMENTS = ";#";
    public static final String DEFAULT_SECTION_NAME = "_";
    public static final String DEFAULT_SERVICE = "org.ini4j.IniParser";
    public static final char OPERATOR = '=';
    public static final char SECTION_BEGIN = '[';
    public static final char SECTION_END = ']';
    public static final String SERVICE_ID = "org.ini4j.IniParser";

    public static IniParser newInstance() {
        return (IniParser)ServiceFinder.findService("org.ini4j.IniParser", "org.ini4j.IniParser");
    }

    public void parse(InputStream inputStream, IniHandler iniHandler, int n) throws IOException, InvalidIniFormatException {
        this.parse(new InputStreamReader(inputStream), iniHandler, n);
    }

    public void parse(Reader reader, IniHandler iniHandler, int n) throws IOException, InvalidIniFormatException {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        iniHandler.startIni();
        String string = DEFAULT_SECTION_NAME;
        iniHandler.startSection(string);
        String string2 = lineNumberReader.readLine();
        while (string2 != null) {
            if ((string2 = string2.trim()).length() != 0 && COMMENTS.indexOf(string2.charAt(0)) < 0) {
                if (string2.charAt(0) == '[') {
                    if (string != null) {
                        iniHandler.endSection();
                    }
                    if (string2.charAt(string2.length() - 1) != ']') {
                        this.parseError(string2, lineNumberReader.getLineNumber());
                    }
                    string = string2.substring(1, string2.length() - 1).trim();
                    if ((n & Ini.IGNORE_ESCAPE) == 0) {
                        string = this.unescape(string);
                    }
                    if (string.length() == 0) {
                        this.parseError(string2, lineNumberReader.getLineNumber());
                    }
                    iniHandler.startSection(string);
                } else {
                    int n2;
                    if (string == null) {
                        this.parseError(string2, lineNumberReader.getLineNumber());
                    }
                    if ((n2 = string2.indexOf(61)) <= 0) {
                        this.parseError(string2, lineNumberReader.getLineNumber());
                    }
                    String string3 = string2.substring(0, n2);
                    if ((n & Ini.IGNORE_ESCAPE) == 0) {
                        string3 = this.unescape(string3);
                    }
                    string3 = string3.trim();
                    String string4 = string2.substring(n2 + 1);
                    if ((n & Ini.IGNORE_ESCAPE) == 0) {
                        string4 = this.unescape(string4);
                    }
                    string4 = string4.trim();
                    if ((n & Ini.STRIP_QUOTES) > 0) {
                        string4 = string4.replaceAll("\"", "");
                    }
                    if (string3.length() == 0) {
                        this.parseError(string2, lineNumberReader.getLineNumber());
                    }
                    iniHandler.handleOption(string3, string4);
                }
            }
            string2 = lineNumberReader.readLine();
        }
        if (string != null) {
            iniHandler.endSection();
        }
        iniHandler.endIni();
    }

    public void parse(URL uRL, IniHandler iniHandler, int n) throws IOException, InvalidIniFormatException {
        this.parse(uRL.openStream(), iniHandler, n);
    }

    protected void parseError(String string, int n) throws InvalidIniFormatException {
        throw new InvalidIniFormatException("parse error (at line: " + n + "): " + string);
    }

    public void parseXML(InputStream inputStream, IniHandler iniHandler) throws IOException, InvalidIniFormatException {
        this.parseXML(new InputStreamReader(inputStream), iniHandler);
    }

    public void parseXML(Reader reader, IniHandler iniHandler) throws IOException, InvalidIniFormatException {
        class XML2Ini
        extends DefaultHandler {
            static final String ATTR_KEY = "key";
            static final String ATTR_VALUE = "value";
            static final String ATTR_VERSION = "version";
            static final String CURRENT_VERSION = "1.0";
            static final String TAG_INI = "ini";
            static final String TAG_OPTION = "option";
            static final String TAG_SECTION = "section";
            final /* synthetic */ IniParser this$0;
            private final /* synthetic */ IniHandler val$handler;

            XML2Ini(IniParser iniParser, IniHandler iniHandler) {
                this.this$0 = iniParser;
                this.val$handler = iniHandler;
            }

            public void endElement(String string, String string2, String string3) {
                if (string3.equals("section")) {
                    this.val$handler.endSection();
                }
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                String string4 = attributes.getValue("key");
                if (string3.equals("ini")) {
                    String string5 = attributes.getValue("version");
                    if (string5 == null || !string5.equals("1.0")) {
                        throw new SAXException("Missing or invalid 'version' attribute");
                    }
                } else {
                    if (string4 == null) {
                        throw new SAXException("missing 'key' attribute");
                    }
                    if (string3.equals("section")) {
                        this.val$handler.startSection(string4);
                    } else if (string3.equals("option")) {
                        this.val$handler.handleOption(string4, attributes.getValue("value"));
                    } else {
                        throw new SAXException("Invalid element: " + string3);
                    }
                }
            }
        }
        XML2Ini xML2Ini = new XML2Ini(this, iniHandler);
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(reader), (DefaultHandler)xML2Ini);
        }
        catch (Exception exception) {
            throw new InvalidIniFormatException(exception);
        }
    }

    public void parseXML(URL uRL, IniHandler iniHandler) throws IOException, InvalidIniFormatException {
        this.parseXML(uRL.openStream(), iniHandler);
    }

    protected String unescape(String string) {
        return Convert.unescape(string);
    }
}

