/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.framework.Bundle;

public abstract class AbstractJavaEditorTextHover
implements IJavaEditorTextHover,
ITextHoverExtension {
    private static String fgStyleSheet;
    private IEditorPart fEditor;
    private IBindingService fBindingService;
    static /* synthetic */ Class class$0;

    public AbstractJavaEditorTextHover() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz);
    }

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            if (input instanceof IClassFileEditorInput) {
                IClassFileEditorInput cfeInput = (IClassFileEditorInput)input;
                return cfeInput.getClassFile();
            }
            WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            return manager.getWorkingCopy(input, false);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        ICodeAssist resolve = this.getCodeAssist();
        if (resolve != null) {
            IJavaElement[] result;
            block6: {
                block5: {
                    try {
                        result = resolve.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
                        if (result != null) break block5;
                        return null;
                    }
                    catch (JavaModelException javaModelException) {
                        return null;
                    }
                }
                int nResults = result.length;
                if (nResults != 0) break block6;
                return null;
            }
            return this.getHoverInfo(result);
        }
        return null;
    }

    protected String getHoverInfo(IJavaElement[] javaElements) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AbstractJavaEditorTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    protected String getTooltipAffordanceString() {
        if (this.fBindingService == null || !JavaPlugin.getDefault().getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return null;
        }
        String keySequence = this.fBindingService.getBestActiveBindingFormattedFor("org.eclipse.jdt.ui.edit.text.java.show.javadoc");
        if (keySequence == null) {
            return null;
        }
        return Messages.format(JavaHoverMessages.JavaTextHover_makeStickyHint, keySequence == null ? "" : keySequence);
    }

    protected static String getStyleSheet() {
        Bundle bundle;
        URL styleSheetURL;
        if (fgStyleSheet == null && (styleSheetURL = (bundle = Platform.getBundle((String)JavaPlugin.getPluginId())).getEntry("/JavadocHoverStyleSheet.css")) != null) {
            try {
                styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
                BufferedReader reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                fgStyleSheet = buffer.toString();
            }
            catch (IOException ex) {
                JavaPlugin.log(ex);
                fgStyleSheet = "";
            }
        }
        return fgStyleSheet;
    }
}

