/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.URLHyperlinkDetector;
import org.eclipse.ui.texteditor.AnnotationPreference;

public class TextSourceViewerConfiguration
extends SourceViewerConfiguration {
    protected IPreferenceStore fPreferenceStore;

    public TextSourceViewerConfiguration() {
    }

    public TextSourceViewerConfiguration(IPreferenceStore preferenceStore) {
        this.fPreferenceStore = preferenceStore;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return TextSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    protected boolean isShowInVerticalRuler(Annotation annotation) {
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference == null) {
            return false;
        }
        String key = preference.getVerticalRulerPreferenceKey();
        return key == null || this.fPreferenceStore.getBoolean(key);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return TextSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    protected boolean isShowInOverviewRuler(Annotation annotation) {
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference == null) {
            return false;
        }
        String key = preference.getOverviewRulerPreferenceKey();
        return key != null && this.fPreferenceStore.getBoolean(key);
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        return new int[]{255};
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new DefaultTextHover(sourceViewer){

            protected boolean isIncluded(Annotation annotation) {
                return TextSourceViewerConfiguration.this.isShownInText(annotation);
            }
        };
    }

    protected boolean isShownInText(Annotation annotation) {
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference == null) {
            return false;
        }
        String key = preference.getTextPreferenceKey();
        return !(key != null ? !this.fPreferenceStore.getBoolean(key) : (key = preference.getHighlightPreferenceKey()) == null || !this.fPreferenceStore.getBoolean(key));
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation == null || this.fPreferenceStore == null) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.fPreferenceStore.getInt("tabWidth");
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null || this.fPreferenceStore == null) {
            return super.getHyperlinkDetectors(sourceViewer);
        }
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        return new IHyperlinkDetector[]{new URLHyperlinkDetector()};
    }

    public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getHyperlinkStateMask(sourceViewer);
        }
        String modifiers = this.fPreferenceStore.getString("hyperlinkKeyModifier");
        int modifierMask = TextSourceViewerConfiguration.computeStateMask(modifiers);
        if (modifierMask == -1) {
            modifierMask = this.fPreferenceStore.getInt("hyperlinkKeyModifierMask");
        }
        return modifierMask;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getHyperlinkPresenter(sourceViewer);
        }
        return new DefaultHyperlinkPresenter(this.fPreferenceStore);
    }

    protected static final int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    protected static final int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = TextSourceViewerConfiguration.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null || !this.fPreferenceStore.contains("undoHistorySize")) {
            return super.getUndoManager(sourceViewer);
        }
        int undoHistorySize = this.fPreferenceStore.getInt("undoHistorySize");
        return new TextViewerUndoManager(undoHistorySize);
    }
}

