/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewComponentDialog;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class NewTypeDialog
extends NewComponentDialog
implements IComponentDialog {
    protected XSDSchema schema;
    protected static int SIMPLE_TYPE = 0;
    protected static int COMPLEX_TYPE = 1;
    protected Object setObject;
    protected int typeKind;
    protected Object selection;
    private boolean allowComplexType = true;

    public NewTypeDialog() {
        super(Display.getCurrent().getActiveShell(), Messages._UI_LABEL_NEW_TYPE, "NewType");
    }

    public NewTypeDialog(XSDSchema schema) {
        super(Display.getCurrent().getActiveShell(), Messages._UI_LABEL_NEW_TYPE, "NewType");
        this.schema = schema;
    }

    private void setup() {
        if (this.schema != null) {
            List usedNames = this.getUsedTypeNames();
            this.setUsedNames(usedNames);
            this.setDefaultName(XSDCommonUIUtils.createUniqueElementName("NewType", (List)this.schema.getTypeDefinitions()));
        }
    }

    public int createAndOpen() {
        this.setup();
        int returnCode = super.createAndOpen();
        if (returnCode == 0) {
            boolean cfr_ignored_0 = this.setObject instanceof Adapter;
        }
        return returnCode;
    }

    public ComponentSpecification getSelectedComponent() {
        ComponentSpecification componentSpecification = new ComponentSpecification(null, this.getName(), null);
        componentSpecification.setMetaName(this.typeKind == COMPLEX_TYPE ? IXSDSearchConstants.COMPLEX_TYPE_META_NAME : IXSDSearchConstants.SIMPLE_TYPE_META_NAME);
        componentSpecification.setNew(true);
        return componentSpecification;
    }

    public void setInitialSelection(ComponentSpecification componentSpecification) {
    }

    protected void createHeaderContent(Composite parent) {
        final Button complexTypeButton = new Button(parent, 16);
        complexTypeButton.setText(Messages._UI_LABEL_COMPLEX_TYPE);
        complexTypeButton.setEnabled(this.allowComplexType);
        final Button simpleTypeButton = new Button(parent, 16);
        simpleTypeButton.setText(Messages._UI_LABEL_SIMPLE_TYPE);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == simpleTypeButton) {
                    NewTypeDialog.this.typeKind = SIMPLE_TYPE;
                } else if (e.widget == complexTypeButton) {
                    NewTypeDialog.this.typeKind = COMPLEX_TYPE;
                }
            }
        };
        if (this.allowComplexType) {
            complexTypeButton.setSelection(true);
            this.typeKind = COMPLEX_TYPE;
        } else {
            simpleTypeButton.setSelection(true);
            this.typeKind = SIMPLE_TYPE;
        }
        simpleTypeButton.addSelectionListener((SelectionListener)listener);
        complexTypeButton.addSelectionListener((SelectionListener)listener);
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(1808);
        separator.setLayoutData((Object)gd);
    }

    protected String getNormalizedLocation(String location) {
        try {
            URL url = new URL(location);
            URL resolvedURL = FileLocator.resolve((URL)url);
            location = resolvedURL.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return location;
    }

    public void allowComplexType(boolean value) {
        this.allowComplexType = value;
    }

    private List getUsedTypeNames() {
        ArrayList<String> usedNames = new ArrayList<String>();
        if (this.schema != null) {
            EList typesList = this.schema.getTypeDefinitions();
            Iterator types = typesList.iterator();
            while (types.hasNext()) {
                usedNames.add(((XSDTypeDefinition)types.next()).getName());
            }
        }
        return usedNames;
    }
}

