/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.Logger;
import org.eclipse.php.core.documentModel.PHPEditorModel;
import org.eclipse.php.core.documentModel.parser.PhpLexer;
import org.eclipse.php.core.phpModel.parser.CodeDataFilter;
import org.eclipse.php.core.phpModel.parser.ModelSupport;
import org.eclipse.php.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.core.util.WeakPropertyChangeListener;
import org.eclipse.php.ui.editor.contentassist.CodeDataCompletionProposal;
import org.eclipse.php.ui.editor.contentassist.CompletionProposalGroup;
import org.eclipse.php.ui.editor.contentassist.IContentAssistSupport;
import org.eclipse.php.ui.editor.contentassist.PHPProposalComperator;
import org.eclipse.php.ui.editor.contentassist.PHPTextSequenceUtilities;
import org.eclipse.php.ui.editor.templates.PHPTemplateCompletionProcessor;
import org.eclipse.php.ui.editor.util.TextSequence;
import org.eclipse.php.ui.preferences.PreferenceConstants;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;

public class ContentAssistSupport
implements IContentAssistSupport {
    protected static final char[] phpDelimiters = new char[]{'?', ':', ';', '|', '^', '&', '<', '>', '+', '-', '.', '*', '/', '%', '!', '~', '[', ']', '(', ')', '{', '}', '@', '\n', '\t', ' ', ',', '$', '\'', '\"'};
    protected static final String CLASS_FUNCTIONS_TRIGGER = "::";
    protected static final String OBJECT_FUNCTIONS_TRIGGER = "->";
    private static final Pattern extendsPattern = Pattern.compile("\\Wextends\\W", 2);
    private static final Pattern implementsPattern = Pattern.compile("\\Wimplements", 2);
    private static final Pattern catchPattern = Pattern.compile("catch\\s[^{]*", 2);
    public static final ICompletionProposal[] EMPTY_CompletionProposal_ARRAY = new ICompletionProposal[0];
    public static final CodeDataCompletionProposal[] EMPTY_CodeDataCompletionProposal_ARRAY = new CodeDataCompletionProposal[0];
    private static final PHPProposalComperator proposalsComperator = new PHPProposalComperator();
    protected boolean showVariablesFromOtherFiles;
    protected boolean determineObjectTypeFromOtherFile;
    protected boolean disableConstants;
    protected boolean showClassNamesInGlobalList;
    protected boolean constantCaseSensitive;
    protected boolean autoShowVariables;
    protected boolean autoShowFunctionsKeywordsConstants;
    protected boolean autoShowClassNames;
    protected char[] autoActivationTriggers;
    private PHPTemplateCompletionProcessor templateCompletionProcessor;
    protected IPropertyChangeListener prefChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null) {
                ContentAssistSupport.this.initPreferences(propertyChangeEvent.getProperty());
            }
        }
    };
    protected CompletionProposalGroup completionProposalGroup;
    protected ICompletionProposal[] templateProposals;
    protected CompletionProposalGroup phpCompletionProposalGroup = new PHPCompletionProposalGroup();
    private CompletionProposalGroup regularPHPCompletionProposalGroup = new RegularPHPCompletionProposalGroup();
    private CompletionProposalGroup classConstructorCompletionProposalGroup = new ClassConstructorCompletionProposalGroup();
    private CompletionProposalGroup newStatmentCompletionProposalGroup = new NewStatmentCompletionProposalGroup();
    private CompletionProposalGroup arrayCompletionProposalGroup = new ArrayCompletionProposalGroup();
    private CompletionProposalGroup classStaticCallCompletionProposalGroup = new ClassStaticCallCompletionProposalGroup();
    protected CompletionProposalGroup classVariableCallCompletionProposalGroup = new ClassVariableCallCompletionProposalGroup();
    private static final PHPTagData[] phpTagDataArray = new PHPTagData[]{new PHPTagData()};
    protected CodeData[] extendedImplementCodeData;
    protected static CodeData[] implementCodeData;
    private static CodeData[] extendsCodeData;

    protected void initPreferences(String string) {
        if (string == null || "contentAssistShowVariablesFromOtherFiles".equals(string) || "contentAssistShowConstantsAssist".equals(string) || "contentAssistShowClassNamesInGlobalCompletion".equals(string) || "contentAssistConstantsCaseSensitive".equals(string) || "contentAssistDetermineObjTypeFromOtherFiles".equals(string) || "contentAssistAutoactivationForClassNames".equals(string) || "contentAssistAutoactivationForFunctionsKeyWordsConstants".equals(string) || "contentAssistAutoactivationForVariables".equals(string) || "contentAssistAutoactivationTriggersPHP".equals(string)) {
            this.showVariablesFromOtherFiles = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistShowVariablesFromOtherFiles");
            this.disableConstants = !PreferenceConstants.getPreferenceStore().getBoolean("contentAssistShowConstantsAssist");
            this.showClassNamesInGlobalList = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistShowClassNamesInGlobalCompletion");
            this.constantCaseSensitive = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistConstantsCaseSensitive");
            this.determineObjectTypeFromOtherFile = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistDetermineObjTypeFromOtherFiles");
            this.autoShowClassNames = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistAutoactivationForClassNames");
            this.autoShowFunctionsKeywordsConstants = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistAutoactivationForFunctionsKeyWordsConstants");
            this.autoShowVariables = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistAutoactivationForVariables");
            this.autoActivationTriggers = PreferenceConstants.getPreferenceStore().getString("contentAssistAutoactivationTriggersPHP").trim().toCharArray();
        }
    }

    public ContentAssistSupport() {
        this.initPreferences(null);
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)WeakPropertyChangeListener.create((IPropertyChangeListener)this.prefChangeListener, (Object)PreferenceConstants.getPreferenceStore()));
    }

    public ICompletionProposal[] getCompletionOption(ITextViewer iTextViewer, PHPEditorModel pHPEditorModel, int n) throws BadLocationException {
        ICompletionProposal[] iCompletionProposalArray = this.getCodeCompletionOptions(iTextViewer, pHPEditorModel, n);
        if (iCompletionProposalArray == null) {
            return new ICompletionProposal[0];
        }
        return iCompletionProposalArray;
    }

    private ICompletionProposal[] getCodeCompletionOptions(ITextViewer iTextViewer, PHPEditorModel pHPEditorModel, int n) throws BadLocationException {
        this.completionProposalGroup = null;
        this.templateProposals = null;
        this.calcCompletionOption(pHPEditorModel, n, iTextViewer);
        if (this.completionProposalGroup == null) {
            return this.templateProposals;
        }
        return this.merg(this.completionProposalGroup.getCompletionProposals(), this.templateProposals);
    }

    protected ICompletionProposal[] getTemplates(ITextViewer iTextViewer, int n) {
        PHPTemplateCompletionProcessor pHPTemplateCompletionProcessor = this.getTemplateCompletionProcessor();
        ICompletionProposal[] iCompletionProposalArray = pHPTemplateCompletionProcessor.computeCompletionProposals(iTextViewer, n);
        return iCompletionProposalArray;
    }

    private PHPTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.templateCompletionProcessor == null) {
            this.templateCompletionProcessor = new PHPTemplateCompletionProcessor();
            String string = this.getTemplateContext();
            this.templateCompletionProcessor.setContextTypeId(string);
        }
        return this.templateCompletionProcessor;
    }

    protected String getTemplateContext() {
        return "php";
    }

    public char[] getAutoactivationTriggers() {
        return this.autoActivationTriggers;
    }

    protected void calcCompletionOption(PHPEditorModel pHPEditorModel, int n, ITextViewer iTextViewer) throws BadLocationException {
        boolean bl;
        String string;
        TextSequence textSequence;
        int n2 = iTextViewer.getSelectedRange().x;
        boolean bl2 = n2 != n;
        PHPFileData pHPFileData = pHPEditorModel.getFileData();
        if (pHPFileData == null) {
            return;
        }
        String string2 = pHPFileData.getName();
        boolean bl3 = true;
        int n3 = ((TextSelection)iTextViewer.getSelectionProvider().getSelection()).getLength();
        PHPProjectModel pHPProjectModel = pHPEditorModel.getProjectModel();
        IStructuredDocumentRegion iStructuredDocumentRegion = ContentAssistUtils.getStructuredDocumentRegion((StructuredTextViewer)((StructuredTextViewer)iTextViewer), (int)n);
        ITextRegion iTextRegion = null;
        iTextRegion = n == pHPEditorModel.getStructuredDocument().getLength() ? iStructuredDocumentRegion.getLastRegion() : iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion == null) {
            return;
        }
        if (iTextRegion.getType() == "PHP_CLOSETAG") {
            return;
        }
        int n4 = iStructuredDocumentRegion.getStartOffset(iTextRegion);
        if (n4 == n) {
            textSequence = iStructuredDocumentRegion.getRegionAtCharacterOffset(n - 1);
            string = null;
            if (textSequence != null || (string = iStructuredDocumentRegion.getPrevious()) != null && (textSequence = string.getRegionAtCharacterOffset(n - 1)) != null) {
                textSequence.getType();
            }
            n4 = iStructuredDocumentRegion.getStartOffset(iTextRegion);
        }
        textSequence = PHPTextSequenceUtilities.getStatment(n, iStructuredDocumentRegion, true);
        string = iTextRegion.getType();
        if (this.isInArrayOptionQuotes(pHPProjectModel, string2, string, n, n3, textSequence)) {
            return;
        }
        if (this.isPHPSingleQuote(iStructuredDocumentRegion, iTextRegion) || PhpLexer.isPHPCommentState((String)string)) {
            return;
        }
        if (this.isInFunctionDeclaretion(pHPProjectModel, string2, textSequence, n, n3, bl3)) {
            return;
        }
        if (this.isInClassDeclaretion(pHPProjectModel, textSequence, n, n3, bl3)) {
            return;
        }
        if (this.isInCatchStatment(pHPProjectModel, textSequence, n, n3, bl3)) {
            return;
        }
        int n5 = textSequence.length();
        int n6 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n5);
        int n7 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n6, true);
        String string3 = textSequence.subSequence(n7, n6).toString();
        boolean bl4 = bl = n5 != n6;
        if (bl && this.isNewOrInstanceofStatment(pHPProjectModel, string3, "", n, n3, bl3, string)) {
            return;
        }
        int n8 = iStructuredDocumentRegion.getParentDocument().getLineOfOffset(n);
        if (this.isClassFunctionCompletion(pHPProjectModel, string2, textSequence, n, n8, n3, string3, n7, bl, bl3, bl2)) {
            return;
        }
        n6 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n7);
        n7 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n6, true);
        String string4 = textSequence.subSequence(n7, n6).toString();
        if (!bl && this.isNewOrInstanceofStatment(pHPProjectModel, string4, string3, n, n3, bl3, string)) {
            return;
        }
        if (bl && ContentAssistSupport.isFunctionCall(pHPProjectModel, string3)) {
            return;
        }
        if (this.isInArrayOption(pHPProjectModel, string2, bl, string4, string3, n7, n, n3, textSequence)) {
            return;
        }
        if (bl) {
            this.getRegularCompletion(iTextViewer, pHPProjectModel, string2, "", n, n3, bl3, iStructuredDocumentRegion, iTextRegion, bl2);
        } else {
            this.getRegularCompletion(iTextViewer, pHPProjectModel, string2, string3, n, n3, bl3, iStructuredDocumentRegion, iTextRegion, bl2);
        }
    }

    protected static boolean isFunctionCall(PHPProjectModel pHPProjectModel, String string) {
        CodeData[] codeDataArray = pHPProjectModel.getFunction(string);
        return codeDataArray != null && codeDataArray.length > 0;
    }

    protected boolean isPHPSingleQuote(IStructuredDocumentRegion iStructuredDocumentRegion, ITextRegion iTextRegion) {
        if (PhpLexer.isPHPQuotesState((String)iTextRegion.getType())) {
            char c = iStructuredDocumentRegion.getText(iTextRegion).charAt(0);
            return c == '\'';
        }
        return false;
    }

    protected boolean isInArrayOptionQuotes(PHPProjectModel pHPProjectModel, String string, String string2, int n, int n2, TextSequence textSequence) {
        if (!PhpLexer.isPHPQuotesState((String)string2)) {
            return false;
        }
        int n3 = textSequence.length();
        int n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n3);
        int n5 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n4, false);
        if (n4 != n3 && n5 != n4) {
            return false;
        }
        String string3 = textSequence.subSequence(n5, n4).toString();
        n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n5);
        char c = textSequence.charAt(n4 - 1);
        if (c != '\"' && c != '\'') {
            return false;
        }
        --n4;
        if ((n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n4)) == 0 || textSequence.charAt(n4 - 1) != '[') {
            return false;
        }
        --n4;
        n5 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n4), true);
        String string4 = textSequence.subSequence(n5, n4).toString();
        if (string4.startsWith("$")) {
            string4 = string4.substring(1);
        }
        CodeData[] codeDataArray = pHPProjectModel.getArrayVariables(string, string4, string3, this.determineObjectTypeFromOtherFile);
        this.completionProposalGroup = this.arrayCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string3, n2);
        return true;
    }

    protected void getRegularCompletion(ITextViewer iTextViewer, PHPProjectModel pHPProjectModel, String string, String string2, int n, int n2, boolean bl, IStructuredDocumentRegion iStructuredDocumentRegion, ITextRegion iTextRegion, boolean bl2) {
        if (!bl && string2.length() == 0) {
            return;
        }
        String string3 = iTextRegion.getType();
        if (string2.startsWith("$")) {
            IStructuredDocument iStructuredDocument;
            if (!bl && !this.autoShowVariables) {
                return;
            }
            if (PhpLexer.isPHPQuotesState((String)string3)) {
                iStructuredDocument = iStructuredDocumentRegion.getParentDocument();
                try {
                    char c = iStructuredDocument.get(n - 2, 1).charAt(0);
                    if (c == '\\') {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.logException(badLocationException);
                }
            }
            iStructuredDocument = this.getContext(pHPProjectModel, string, n - string2.length());
            string2 = string2.substring(1);
            CodeData[] codeDataArray = pHPProjectModel.getVariables(string, (PHPCodeContext)iStructuredDocument, string2, this.showVariablesFromOtherFiles);
            this.completionProposalGroup = this.phpCompletionProposalGroup;
            this.completionProposalGroup.setData(n, codeDataArray, string2, n2, bl2);
            return;
        }
        if (PhpLexer.isPHPQuotesState((String)string3) || string3.equals("PHP_HEREDOC_TAG") && iStructuredDocumentRegion.getStartOffset(iTextRegion) + iTextRegion.getLength() <= n) {
            this.completionProposalGroup = this.regularPHPCompletionProposalGroup;
            this.completionProposalGroup.setData(n, null, string2, n2, bl2);
            return;
        }
        CodeData[] codeDataArray = null;
        CodeData[] codeDataArray2 = null;
        CodeData[] codeDataArray3 = null;
        if (bl || this.autoShowFunctionsKeywordsConstants) {
            codeDataArray = string2.length() == 0 ? pHPProjectModel.getFunctions() : pHPProjectModel.getFunctions(string2);
            if (!this.disableConstants) {
                codeDataArray2 = string2.length() == 0 ? pHPProjectModel.getConstants() : pHPProjectModel.getConstants(string2, this.constantCaseSensitive);
            }
            codeDataArray3 = pHPProjectModel.getKeywordData();
        }
        CodeData[] codeDataArray4 = null;
        if (this.showClassNamesInGlobalList && (bl || this.autoShowClassNames)) {
            codeDataArray4 = pHPProjectModel.getClasses();
        }
        Object[] objectArray = null;
        if (this.shouldAddPHPTag(iStructuredDocumentRegion.getParentDocument(), n, string2)) {
            objectArray = phpTagDataArray;
        }
        objectArray = ModelSupport.merge((CodeData[])codeDataArray3, (CodeData[])objectArray);
        objectArray = ModelSupport.merge((CodeData[])codeDataArray4, (CodeData[])objectArray);
        objectArray = ModelSupport.merge((CodeData[])codeDataArray2, (CodeData[])objectArray);
        objectArray = ModelSupport.merge((CodeData[])codeDataArray, (CodeData[])objectArray);
        this.completionProposalGroup = this.regularPHPCompletionProposalGroup;
        this.completionProposalGroup.setData(n, (CodeData[])objectArray, string2, n2, bl2);
        this.templateProposals = this.getTemplates(iTextViewer, n);
    }

    private boolean shouldAddPHPTag(IStructuredDocument iStructuredDocument, int n, String string) {
        n -= string.length() + 2;
        try {
            String string2 = iStructuredDocument.get(n, 2);
            if (string2.equals("<?")) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean isClassFunctionCompletion(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, int n2, int n3, String string2, int n4, boolean bl, boolean bl2, boolean bl3) {
        String string3;
        if ((n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n4)) <= 2) {
            return false;
        }
        boolean bl4 = false;
        String string4 = textSequence.subSequence(n4 - 2, n4).toString();
        if (!string4.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (string4.equals(CLASS_FUNCTIONS_TRIGGER)) {
                bl4 = true;
            } else {
                return false;
            }
        }
        if ((string3 = this.getClassName(pHPProjectModel, string, textSequence, n4, n, n2)) == null) {
            string3 = "";
        }
        if (bl && string2.length() > 0) {
            return this.isClassFunctionCall(pHPProjectModel, string, string3, string2);
        }
        if (bl4) {
            this.showClassStaticCall(pHPProjectModel, string, n, string3, string2, n3, bl2);
        } else {
            String string5 = textSequence.toString().substring(0, textSequence.toString().lastIndexOf(OBJECT_FUNCTIONS_TRIGGER)).trim();
            boolean bl5 = !string5.equals("$this");
            boolean bl6 = false;
            this.showClassCall(pHPProjectModel, string, n, string3, string2, n3, bl5, bl6, bl2, bl3);
        }
        return true;
    }

    protected String getClassName(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, int n2, int n3) {
        int n4;
        int n5;
        n = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n);
        boolean bl = false;
        String string2 = textSequence.subSequence(n - 2, n).toString();
        if (!string2.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (string2.equals(CLASS_FUNCTIONS_TRIGGER)) {
                bl = true;
            } else {
                return null;
            }
        }
        if ((n5 = PHPTextSequenceUtilities.getPrivousTriggerIndex(textSequence, n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n - 2))) == -1) {
            return this.innerGetClassName(pHPProjectModel, string, textSequence, n4, bl, n2, n3);
        }
        int n6 = PHPTextSequenceUtilities.readForwardSpaces(textSequence, n5 + 2);
        String string3 = textSequence.subSequence(n6, n4).toString();
        String string4 = this.getClassName(pHPProjectModel, string, textSequence, n6, n2, n3);
        int n7 = string3.indexOf(40);
        if (n7 == -1) {
            return this.getVarType(pHPProjectModel, string, string4, string3, n2, n3);
        }
        String string5 = string3.substring(0, n7).trim();
        return this.getFunctionReturnType(pHPProjectModel, string, string4, string5);
    }

    protected String innerGetClassName(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, boolean bl, int n2, int n3) {
        int n4 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n, true);
        String string2 = textSequence.subSequence(n4, n).toString();
        if (bl) {
            PHPClassData pHPClassData;
            if (string2.equals("self")) {
                PHPClassData pHPClassData2 = this.getContainerClassData(pHPProjectModel, string, n2 - 6);
                if (pHPClassData2 != null) {
                    return pHPClassData2.getName();
                }
            } else if (string2.equals("parent") && (pHPClassData = this.getContainerClassData(pHPProjectModel, string, n2 - 8)) != null) {
                return pHPProjectModel.getSuperClassName(string, pHPClassData.getName());
            }
            return string2;
        }
        if (string2.length() > 0 && string2.charAt(0) == '$') {
            int n5 = n2 - textSequence.length();
            return PHPFileDataUtilities.getVariableType((String)string, (String)string2, (int)n5, (int)n3, (PHPUserModel)pHPProjectModel.getPHPUserModel(), (boolean)this.determineObjectTypeFromOtherFile);
        }
        if (textSequence.charAt(n - 1) == ')') {
            int n6 = this.getFunctionNameEndOffset(textSequence, n - 1);
            int n7 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n6, false);
            String string3 = textSequence.subSequence(n7, n6).toString();
            PHPClassData pHPClassData = this.getContainerClassData(pHPProjectModel, string, n2);
            if (pHPClassData != null) {
                return this.getFunctionReturnType(pHPProjectModel, string, pHPClassData.getName(), string3);
            }
            PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
            PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
            int n8 = 0;
            while (n8 < pHPFunctionDataArray.length) {
                PHPFunctionData pHPFunctionData = pHPFunctionDataArray[n8];
                if (pHPFunctionData.getName().equals(string3)) {
                    return pHPFunctionData.getReturnType();
                }
                ++n8;
            }
        }
        return null;
    }

    protected boolean isClassFunctionCall(PHPProjectModel pHPProjectModel, String string, String string2, String string3) {
        CodeData codeData = pHPProjectModel.getClassFunctionData(string, string2, string3);
        return codeData != null;
    }

    protected String getVarType(PHPProjectModel pHPProjectModel, String string, String string2, String string3, int n, int n2) {
        String string4 = PHPFileDataUtilities.getVariableType((String)string, (String)("this;*" + string3), (int)n, (int)n2, (PHPUserModel)pHPProjectModel.getPHPUserModel(), (boolean)this.determineObjectTypeFromOtherFile);
        if (string4 != null) {
            return string4;
        }
        CodeData codeData = pHPProjectModel.getClassVariablesData(string, string2, string3);
        if (codeData != null) {
            if (codeData instanceof PHPClassVarData) {
                return ((PHPClassVarData)codeData).getClassType();
            }
            return null;
        }
        PHPClassData pHPClassData = pHPProjectModel.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData == null) {
            return null;
        }
        return this.getVarType(pHPProjectModel, string, pHPSuperClassNameData.getName(), string3, n, n2);
    }

    protected String getFunctionReturnType(PHPProjectModel pHPProjectModel, String string, String string2, String string3) {
        CodeData[] codeDataArray;
        CodeData codeData = pHPProjectModel.getClassFunctionData(string, string2, string3);
        if (codeData != null) {
            if (codeData instanceof PHPFunctionData) {
                return ((PHPFunctionData)codeData).getReturnType();
            }
            return null;
        }
        PHPClassData pHPClassData = pHPProjectModel.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        String string4 = null;
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData != null) {
            string4 = this.getFunctionReturnType(pHPProjectModel, string, pHPSuperClassNameData.getName(), string3);
        }
        if (string4 == null) {
            codeDataArray = pHPProjectModel.getFileData(string);
            PHPFunctionData[] pHPFunctionDataArray = codeDataArray.getFunctions();
            int n = 0;
            while (n < pHPFunctionDataArray.length) {
                PHPFunctionData pHPFunctionData = pHPFunctionDataArray[n];
                if (pHPFunctionData.getName().equals(string3) && pHPFunctionData instanceof PHPFunctionData) {
                    string4 = pHPFunctionData.getReturnType();
                }
                ++n;
            }
        }
        if (string4 == null) {
            codeDataArray = pHPProjectModel.getFunctions();
            int n = 0;
            while (n < codeDataArray.length) {
                CodeData codeData2 = codeDataArray[n];
                if (codeData2.getName().equals(string3) && codeData2 instanceof PHPFunctionData) {
                    string4 = ((PHPFunctionData)codeData2).getReturnType();
                }
                ++n;
            }
        }
        return string4;
    }

    protected void showClassCall(PHPProjectModel pHPProjectModel, String string, int n, String string2, String string3, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        CodeData[] codeDataArray = null;
        if (bl3 || this.autoShowFunctionsKeywordsConstants) {
            codeDataArray = pHPProjectModel.getClassFunctions(string, string2, string3.length() == 0 ? "" : string3);
        }
        CodeData[] codeDataArray2 = null;
        if (bl3 || this.autoShowVariables) {
            codeDataArray2 = ModelSupport.getFilteredCodeData((CodeData[])pHPProjectModel.getClassVariables(string, string2, ""), (CodeDataFilter)ModelSupport.NOT_STATIC_VARIABLES_FILTER);
        }
        CodeData[] codeDataArray3 = ModelSupport.getFilteredCodeData((CodeData[])ModelSupport.merge((CodeData[])codeDataArray, (CodeData[])codeDataArray2), (CodeDataFilter)this.getAccessLevelFilter(pHPProjectModel, string, string2, n, bl));
        this.completionProposalGroup = bl2 ? this.classVariableCallCompletionProposalGroup : this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray3, string3, n2, bl4);
    }

    protected void showClassStaticCall(PHPProjectModel pHPProjectModel, String string, int n, String string2, String string3, int n2, boolean bl) {
        CodeData[] codeDataArray = null;
        if (bl || this.autoShowFunctionsKeywordsConstants) {
            codeDataArray = pHPProjectModel.getClassFunctions(string, string2, "");
        }
        CodeData[] codeDataArray2 = null;
        if (bl || this.autoShowVariables) {
            codeDataArray2 = ModelSupport.merge((CodeData[])pHPProjectModel.getClassVariables(string, string2, ""), (CodeData[])pHPProjectModel.getClassConsts(string, string2, ""));
        }
        CodeData[] codeDataArray3 = ModelSupport.getFilteredCodeData((CodeData[])ModelSupport.merge((CodeData[])codeDataArray, (CodeData[])codeDataArray2), (CodeDataFilter)this.getAccessLevelFilter(pHPProjectModel, string, string2, n, false));
        this.completionProposalGroup = this.classStaticCallCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray3, string3, n2);
    }

    protected PHPClassData getContainerClassData(PHPProjectModel pHPProjectModel, String string, int n) {
        PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
        return PHPFileDataUtilities.getContainerClassDada((PHPFileData)pHPFileData, (int)n);
    }

    protected int getFunctionNameEndOffset(TextSequence textSequence, int n) {
        if (textSequence.charAt(n) != ')') {
            return 0;
        }
        int n2 = n;
        int n3 = 1;
        while (n3 != 0 && n2 >= 0) {
            if (textSequence.charAt(--n2) == ')') {
                ++n3;
                continue;
            }
            if (textSequence.charAt(n2) != '(') continue;
            --n3;
        }
        return n2;
    }

    protected CodeDataFilter getAccessLevelFilter(PHPProjectModel pHPProjectModel, String string, String string2, int n, boolean bl) {
        PHPCodeContext pHPCodeContext = this.getContext(pHPProjectModel, string, n);
        String string3 = pHPCodeContext.getContainerClassName();
        if (string3.equals(string2)) {
            return ModelSupport.PIRVATE_ACCESS_LEVEL_FILTER;
        }
        if (bl) {
            return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER;
        }
        if (string3.equals("")) {
            return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC;
        }
        PHPClassData pHPClassData = pHPProjectModel.getClass(string, string3);
        String string4 = pHPClassData.getSuperClassData().getName();
        while (string4 != null) {
            if (string4.equals(string2)) {
                return ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC;
            }
            pHPClassData = pHPProjectModel.getClass(string, string4);
            if (pHPClassData == null) break;
            string4 = pHPClassData.getSuperClassData().getName();
        }
        if (string4 == null && !string3.equals("")) {
            return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC;
        }
        return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER;
    }

    protected PHPCodeContext getContext(PHPProjectModel pHPProjectModel, String string, int n) {
        PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
        return ModelSupport.createContext((PHPFileData)pHPFileData, (int)n);
    }

    protected boolean isInFunctionDeclaretion(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, int n2, boolean bl) {
        String string2;
        int n3 = PHPTextSequenceUtilities.isInFunctionDeclaretion(textSequence);
        if (n3 == -1) {
            return false;
        }
        PHPClassData pHPClassData = this.getContainerClassData(pHPProjectModel, string, textSequence.getOriginalOffset(n3));
        if (pHPClassData == null) {
            return true;
        }
        int n4 = textSequence.length() - 1;
        while (n4 >= n3) {
            if (textSequence.charAt(n4) == '(') {
                return true;
            }
            --n4;
        }
        n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, textSequence.length());
        int n5 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n4, false);
        String string3 = textSequence.subSequence(n5, n4).toString();
        if (string3.equals("function")) {
            string2 = "";
        } else if (n4 == textSequence.length()) {
            string2 = string3;
        } else {
            return true;
        }
        if (!bl && string2.length() == 0) {
            return true;
        }
        String string4 = pHPProjectModel.getPHPLanguageModel().getPHPVersion();
        boolean bl2 = string4.equals("php5");
        CodeData[] codeDataArray = bl2 ? new CodeData[]{PHPCodeDataFactory.createPHPFuctionData((String)"__construct", (int)1, null, (UserData)pHPClassData.getUserData(), (PHPFunctionData.PHPFunctionParameter[])PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null), PHPCodeDataFactory.createPHPFuctionData((String)"__destruct", (int)1, null, (UserData)pHPClassData.getUserData(), (PHPFunctionData.PHPFunctionParameter[])PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null), PHPCodeDataFactory.createPHPFuctionData((String)pHPClassData.getName(), (int)1, null, (UserData)pHPClassData.getUserData(), (PHPFunctionData.PHPFunctionParameter[])PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null)} : new CodeData[]{PHPCodeDataFactory.createPHPFuctionData((String)pHPClassData.getName(), (int)1, null, (UserData)pHPClassData.getUserData(), (PHPFunctionData.PHPFunctionParameter[])PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null)};
        this.completionProposalGroup = this.classConstructorCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string2, n2);
        return true;
    }

    protected boolean isInClassDeclaretion(PHPProjectModel pHPProjectModel, TextSequence textSequence, int n, int n2, boolean bl) {
        int n3 = PHPTextSequenceUtilities.isInClassDeclaretion(textSequence);
        if (n3 == -1) {
            return false;
        }
        boolean bl2 = true;
        if (n3 >= 6) {
            String string = textSequence.subSequence(n3 - 6, n3 - 1).toString();
            bl2 = string.equals("class");
        }
        textSequence = textSequence.subTextSequence(n3, textSequence.length());
        int n4 = 0;
        while (n4 < textSequence.length()) {
            if (!Character.isLetterOrDigit(textSequence.charAt(n4))) break;
            ++n4;
        }
        if (n4 == textSequence.length()) {
            return true;
        }
        textSequence = textSequence.subTextSequence(n4, textSequence.length());
        int n5 = textSequence.length();
        int n6 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n5, false);
        String string = textSequence.subSequence(n6, n5).toString();
        Matcher matcher = extendsPattern.matcher(textSequence);
        Matcher matcher2 = implementsPattern.matcher(textSequence);
        boolean bl3 = matcher.find();
        boolean bl4 = matcher2.find();
        if (!bl3 && !bl4) {
            if (bl || string.length() > 0) {
                if (bl2) {
                    this.showExtendsImplementsList(pHPProjectModel, string, n, n2, bl);
                } else {
                    this.showExtendsList(pHPProjectModel, string, n, n2, bl);
                }
            }
            return true;
        }
        n5 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n6);
        String string2 = textSequence.subSequence(n6 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n5, true), n5).toString();
        if (string2.equalsIgnoreCase("extends")) {
            this.showBaseClassList(pHPProjectModel, string, n, n2, bl2, bl);
            return true;
        }
        if (string2.equalsIgnoreCase("implements")) {
            this.showInterfaceList(pHPProjectModel, string, n, n2, bl);
            return true;
        }
        if (bl3 && bl4) {
            if (bl || string.length() > 0) {
                if (matcher.start() < matcher2.start()) {
                    this.showInterfaceList(pHPProjectModel, string, n, n2, bl);
                } else {
                    this.showBaseClassList(pHPProjectModel, string, n, n2, bl2, bl);
                }
            }
            return true;
        }
        if (bl4) {
            if (bl) {
                this.showInterfaceList(pHPProjectModel, string, n, n2, bl);
            }
            return true;
        }
        if ((bl || string.length() > 0) && bl2) {
            this.showImplementsList(pHPProjectModel, string, n, n2, bl);
        }
        return true;
    }

    protected void showInterfaceList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl) {
        if (!bl && !this.autoShowClassNames) {
            return;
        }
        CodeData[] codeDataArray = pHPProjectModel.getClasses("");
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>(codeDataArray.length / 10);
        int n3 = 0;
        while (n3 < codeDataArray.length) {
            if (PHPModifier.isInterface((int)((PHPClassData)codeDataArray[n3]).getModifiers())) {
                arrayList.add(codeDataArray[n3]);
            }
            ++n3;
        }
        CodeData[] codeDataArray2 = new CodeData[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n4 = 0;
        while (n4 < codeDataArray2.length) {
            codeDataArray2[n4] = (CodeData)iterator.next();
            ++n4;
        }
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray2, string, n2);
    }

    protected void showExtendsImplementsList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl) {
        if (!bl && !this.autoShowClassNames) {
            return;
        }
        CodeData[] codeDataArray = this.getExtendsImplementsCodeData(pHPProjectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string, n2);
    }

    protected CodeData[] getExtendsImplementsCodeData(PHPProjectModel pHPProjectModel) {
        if (this.extendedImplementCodeData == null) {
            CodeData codeData = null;
            CodeData codeData2 = null;
            CodeData[] codeDataArray = pHPProjectModel.getKeywordData();
            int n = 0;
            while (n < codeDataArray.length) {
                if (codeDataArray[n].getName().equals("extends")) {
                    codeData = codeDataArray[n];
                }
                if (codeDataArray[n].getName().equals("implements")) {
                    codeData2 = codeDataArray[n];
                }
                ++n;
            }
            String string = pHPProjectModel.getPHPLanguageModel().getPHPVersion();
            boolean bl = string.equals("php5");
            this.extendedImplementCodeData = bl ? new CodeData[]{codeData, codeData2} : new CodeData[]{codeData};
        }
        return this.extendedImplementCodeData;
    }

    protected void showImplementsList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl) {
        if (!bl && !this.autoShowClassNames) {
            return;
        }
        CodeData[] codeDataArray = this.getImplementsCodeData(pHPProjectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string, n2);
    }

    protected CodeData[] getImplementsCodeData(PHPProjectModel pHPProjectModel) {
        String string = pHPProjectModel.getPHPLanguageModel().getPHPVersion();
        boolean bl = string.equals("php5");
        if (!bl) {
            return null;
        }
        if (implementCodeData == null) {
            CodeData codeData = null;
            CodeData[] codeDataArray = pHPProjectModel.getKeywordData();
            int n = 0;
            while (n < codeDataArray.length) {
                if (codeDataArray[n].getName().equals("implements")) {
                    codeData = codeDataArray[n];
                    break;
                }
                ++n;
            }
            implementCodeData = new CodeData[]{codeData};
        }
        return implementCodeData;
    }

    private void showExtendsList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl) {
        if (!bl && !this.autoShowClassNames) {
            return;
        }
        CodeData[] codeDataArray = ContentAssistSupport.getExtendsCodeData(pHPProjectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string, n2);
    }

    private static CodeData[] getExtendsCodeData(PHPProjectModel pHPProjectModel) {
        if (extendsCodeData == null) {
            CodeData codeData = null;
            CodeData[] codeDataArray = pHPProjectModel.getKeywordData();
            int n = 0;
            while (n < codeDataArray.length) {
                if (codeDataArray[n].getName().equals("extends")) {
                    codeData = codeDataArray[n];
                    break;
                }
                ++n;
            }
            extendsCodeData = new CodeData[]{codeData};
        }
        return extendsCodeData;
    }

    private void showBaseClassList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl, boolean bl2) {
        if (!bl) {
            this.showInterfaceList(pHPProjectModel, string, n, n2, bl2);
            return;
        }
        if (!bl2 && !this.autoShowClassNames) {
            return;
        }
        CodeData[] codeDataArray = this.getOnlyClasses(pHPProjectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string, n2);
    }

    private CodeData[] getOnlyClasses(PHPProjectModel pHPProjectModel) {
        CodeData[] codeDataArray = pHPProjectModel.getClasses("");
        int n = 0;
        int n2 = 0;
        while (n2 < codeDataArray.length) {
            if (PHPModifier.isInterface((int)((PHPClassData)codeDataArray[n2]).getModifiers())) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return codeDataArray;
        }
        CodeData[] codeDataArray2 = new CodeData[codeDataArray.length - n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < codeDataArray.length) {
            if (!PHPModifier.isInterface((int)((PHPClassData)codeDataArray[n4]).getModifiers())) {
                codeDataArray2[n3] = codeDataArray[n4];
                ++n3;
            }
            ++n4;
        }
        return codeDataArray2;
    }

    protected boolean isInCatchStatment(PHPProjectModel pHPProjectModel, TextSequence textSequence, int n, int n2, boolean bl) {
        Matcher matcher = catchPattern.matcher(textSequence);
        int n3 = textSequence.length();
        while (matcher.find()) {
            if (textSequence.length() != matcher.end()) continue;
            n3 = matcher.start() + 1;
            break;
        }
        if (n3 == textSequence.length()) {
            return false;
        }
        int n4 = n3 + 5;
        textSequence = textSequence.subTextSequence(n4, textSequence.length());
        int n5 = 0;
        while (n5 < textSequence.length()) {
            if (textSequence.charAt(n5) == '(') break;
            ++n5;
        }
        if (n5 == textSequence.length()) {
            return true;
        }
        n5 = PHPTextSequenceUtilities.readForwardSpaces(textSequence, n5 + 1);
        int n6 = PHPTextSequenceUtilities.readIdentifiarEndIndex(textSequence, n5, false);
        String string = textSequence.subSequence(n5, n6).toString();
        if (n6 == textSequence.length()) {
            this.showClassList(pHPProjectModel, string, n, n2, false, bl);
        }
        return true;
    }

    protected void showClassList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl, boolean bl2) {
        CodeData[] codeDataArray;
        if (!bl2 && !this.autoShowClassNames) {
            return;
        }
        if (bl) {
            this.completionProposalGroup = this.newStatmentCompletionProposalGroup;
            codeDataArray = this.getOnlyClasses(pHPProjectModel);
        } else {
            this.completionProposalGroup = this.phpCompletionProposalGroup;
            codeDataArray = pHPProjectModel.getClasses("");
        }
        this.completionProposalGroup.setData(n, codeDataArray, string, n2);
    }

    protected boolean isNewOrInstanceofStatment(PHPProjectModel pHPProjectModel, String string, String string2, int n, int n2, boolean bl, String string3) {
        if (PhpLexer.isPHPQuotesState((String)string3)) {
            return false;
        }
        if (string.equalsIgnoreCase("instanceof")) {
            this.showClassList(pHPProjectModel, string2, n, n2, false, bl);
            return true;
        }
        if (string.equalsIgnoreCase("new")) {
            this.showClassList(pHPProjectModel, string2, n, n2, true, bl);
            return true;
        }
        return false;
    }

    protected boolean isInArrayOption(PHPProjectModel pHPProjectModel, String string, boolean bl, String string2, String string3, int n, int n2, int n3, TextSequence textSequence) {
        CodeData[] codeDataArray;
        CodeData[] codeDataArray2;
        boolean bl2 = false;
        if (n > 0 && !string3.startsWith("$")) {
            if (bl) {
                if (string3.length() == 0 && string2.length() == 0 && textSequence.charAt(n - 1) == '[') {
                    bl2 = true;
                }
            } else if (string2.length() == 0 && textSequence.charAt(n - 1) == '[') {
                bl2 = true;
            }
        }
        if (!bl2) {
            return false;
        }
        int n4 = n - 1;
        n = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n4), true);
        String string4 = textSequence.subSequence(n, n4).toString();
        if (string4.startsWith("$")) {
            string4 = string4.substring(1);
        }
        CodeData[] codeDataArray3 = pHPProjectModel.getArrayVariables(string, string4, string3, this.determineObjectTypeFromOtherFile);
        if (string3.length() == 0) {
            codeDataArray2 = pHPProjectModel.getFunctions();
            codeDataArray = this.disableConstants ? null : pHPProjectModel.getConstants();
        } else {
            codeDataArray2 = pHPProjectModel.getFunctions(string3);
            codeDataArray = this.disableConstants ? null : pHPProjectModel.getConstants(string3, this.constantCaseSensitive);
        }
        CodeData[] codeDataArray4 = ModelSupport.merge((CodeData[])codeDataArray2, (CodeData[])ModelSupport.merge((CodeData[])codeDataArray3, (CodeData[])codeDataArray));
        this.completionProposalGroup = this.arrayCompletionProposalGroup;
        this.completionProposalGroup.setData(n2, codeDataArray4, string3, n3);
        return true;
    }

    protected ICompletionProposal[] merg(ICompletionProposal[] iCompletionProposalArray, ICompletionProposal[] iCompletionProposalArray2) {
        int n = iCompletionProposalArray == null ? 0 : iCompletionProposalArray.length;
        int n2 = iCompletionProposalArray2 == null ? 0 : iCompletionProposalArray2.length;
        ICompletionProposal[] iCompletionProposalArray3 = new ICompletionProposal[n + n2];
        int n3 = 0;
        if (iCompletionProposalArray != null) {
            System.arraycopy(iCompletionProposalArray, 0, iCompletionProposalArray3, 0, n);
            n3 = n;
        }
        if (iCompletionProposalArray2 != null) {
            System.arraycopy(iCompletionProposalArray2, 0, iCompletionProposalArray3, n3, n2);
        }
        Arrays.sort(iCompletionProposalArray3, proposalsComperator);
        return iCompletionProposalArray3;
    }

    private class ArrayCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private ArrayCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(CodeData codeData) {
            if (!(codeData instanceof PHPVariableData)) {
                return super.createProposal(codeData);
            }
            ArrayCompletionProposal arrayCompletionProposal = new ArrayCompletionProposal(codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "'", "'", 1);
            return arrayCompletionProposal;
        }

        private class ArrayCompletionProposal
        extends CodeDataCompletionProposal {
            public ArrayCompletionProposal(CodeData codeData, int n, int n2, int n3, String string, String string2, int n4) {
                super(codeData, n, n2, n3, string, string2, n4, false);
            }

            public void apply(IDocument iDocument) {
                try {
                    char c;
                    boolean bl = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistInsertCompletion");
                    if (!bl) {
                        this.removeTrailingCharacters(iDocument);
                    }
                    if ((c = iDocument.getChar(this.replacementOffset - 1)) == '\'' || c == '\"') {
                        --this.replacementOffset;
                        ++this.replacementLength;
                        int n = this.replacementOffset + this.replacementLength + this.selectionLength;
                        int n2 = iDocument.getLength();
                        int n3 = 0;
                        boolean bl2 = false;
                        while (n < n2) {
                            char c2 = iDocument.getChar(n);
                            if (c2 == c) {
                                ++n3;
                                bl2 = true;
                                break;
                            }
                            if (!Character.isWhitespace(c2)) break;
                            ++n3;
                            ++n;
                        }
                        if (bl2) {
                            this.replacementLength += n3;
                        }
                    }
                    iDocument.replace(this.replacementOffset, this.replacementLength + this.selectionLength, this.getReplacementString());
                }
                catch (BadLocationException badLocationException) {
                    super.apply(iDocument);
                }
            }
        }
    }

    private class ClassConstructorCompletionProposalGroup
    extends CompletionProposalGroup {
        private ClassConstructorCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(CodeData codeData) {
            return new CodeDataCompletionProposal(codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", "()", 1, true);
        }
    }

    private class ClassStaticCallCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private ClassStaticCallCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(CodeData codeData) {
            if (codeData instanceof PHPClassVarData) {
                return new CodeDataCompletionProposal(codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "$", "", 0, false);
            }
            return super.createProposal(codeData);
        }

        protected CodeDataCompletionProposal[] calcCompletionProposals() {
            CodeData[] codeDataArray;
            if (this.key.length() == 0) {
                return super.calcCompletionProposals();
            }
            if (this.key.charAt(0) == '$') {
                codeDataArray = ModelSupport.getFilteredCodeData((CodeData[])this.codeDataProposals, (CodeDataFilter)ModelSupport.STATIC_VARIABLES_FILTER);
                codeDataArray = ModelSupport.getCodeDataStartingWith((CodeData[])codeDataArray, (String)this.key.substring(1));
            } else {
                codeDataArray = ModelSupport.getCodeDataStartingWith((CodeData[])this.codeDataProposals, (String)this.key);
                codeDataArray = ModelSupport.getFilteredCodeData((CodeData[])codeDataArray, (CodeDataFilter)ModelSupport.NOT_STATIC_VARIABLES_FILTER);
            }
            CodeDataCompletionProposal[] codeDataCompletionProposalArray = new CodeDataCompletionProposal[codeDataArray.length];
            int n = 0;
            while (n < codeDataArray.length) {
                codeDataCompletionProposalArray[n] = this.createProposal(codeDataArray[n]);
                ++n;
            }
            return codeDataCompletionProposalArray;
        }
    }

    private class ClassVariableCallCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private ClassVariableCallCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(CodeData codeData) {
            if (codeData instanceof PHPClassVarData) {
                return new CodeDataCompletionProposal(codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "$", "", 0, false);
            }
            return super.createProposal(codeData);
        }
    }

    private class NewStatmentCompletionProposalGroup
    extends CompletionProposalGroup {
        private NewStatmentCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(CodeData codeData) {
            PHPClassData pHPClassData = (PHPClassData)codeData;
            int n = pHPClassData.getConstructor().getParameters().length > 0 ? 1 : 2;
            return new CodeDataCompletionProposal(codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", "()", n, true);
        }
    }

    protected class PHPCompletionProposalGroup
    extends CompletionProposalGroup {
        protected PHPCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(CodeData codeData) {
            String string = " ";
            int n = 1;
            boolean bl = false;
            if (codeData instanceof PHPKeywordData) {
                PHPKeywordData pHPKeywordData = (PHPKeywordData)codeData;
                string = pHPKeywordData.getSuffix();
                n = pHPKeywordData.getSuffixOffset();
            } else if (codeData instanceof PHPFunctionData) {
                String string2;
                boolean bl2;
                PHPFunctionData pHPFunctionData = (PHPFunctionData)codeData;
                string = "()";
                bl = true;
                n = 2;
                boolean bl3 = bl2 = pHPFunctionData.getParameters().length > 0;
                if (bl2) {
                    --n;
                }
                if ((string2 = pHPFunctionData.getReturnType()) != null && string2.compareToIgnoreCase("void") == 0) {
                    string = String.valueOf(string) + ";";
                    if (!bl2) {
                        ++n;
                    }
                }
            } else if (codeData instanceof PHPVariableData || codeData instanceof PHPConstantData || codeData instanceof PHPClassConstData) {
                string = "";
                n = 0;
            }
            return new CodeDataCompletionProposal(codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", string, n, bl);
        }
    }

    private static class PHPTagData
    extends PHPCodeDataFactory.PHPFunctionDataImp {
        PHPTagData() {
            super("php", 0, null, null, PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, "");
        }
    }

    private class RegularPHPCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private RegularPHPCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(CodeData codeData) {
            if (!(codeData instanceof PHPClassData)) {
                return super.createProposal(codeData);
            }
            return new CodeDataCompletionProposal(codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", ContentAssistSupport.CLASS_FUNCTIONS_TRIGGER, 2, false);
        }
    }
}

