/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.ui.PHPElementLabelProvider;
import org.eclipse.php.ui.search.Messages;
import org.eclipse.php.ui.search.PHPSearchResultPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class SearchLabelProvider
extends PHPElementLabelProvider {
    public static final String PROPERTY_MATCH_COUNT = "org.eclipse.php.search.matchCount";
    private static final String EMPHASIZE_POTENTIAL_MATCHES = "org.eclipse.search.potentialMatch.emphasize";
    private static final String POTENTIAL_MATCH_FG_COLOR = "org.eclipse.search.potentialMatch.fgColor";
    private Color fPotentialMatchFgColor;
    private Map fLabelProviderMap;
    protected PHPSearchResultPage fPage;
    private ScopedPreferenceStore fSearchPreferences;
    private IPropertyChangeListener fSearchPropertyListener;

    public SearchLabelProvider(PHPSearchResultPage pHPSearchResultPage, int n) {
        super(n);
        this.fPage = pHPSearchResultPage;
        this.fLabelProviderMap = new HashMap(5);
        this.fSearchPreferences = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.search");
        this.fSearchPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SearchLabelProvider.this.doSearchPropertyChange(propertyChangeEvent);
            }
        };
        this.fSearchPreferences.addPropertyChangeListener(this.fSearchPropertyListener);
    }

    final void doSearchPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fPotentialMatchFgColor == null) {
            return;
        }
        if (POTENTIAL_MATCH_FG_COLOR.equals(propertyChangeEvent.getProperty()) || EMPHASIZE_POTENTIAL_MATCHES.equals(propertyChangeEvent.getProperty())) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
            LabelProviderChangedEvent labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
            this.fireLabelProviderChanged(labelProviderChangedEvent);
        }
    }

    protected final int getNumberOfPotentialMatches(Object object) {
        int n = 0;
        return n;
    }

    protected final String getLabelWithCounts(Object object, String string) {
        int n = this.fPage.getDisplayedMatchCount(object);
        int n2 = this.getNumberOfPotentialMatches(object);
        if (n < 2) {
            if (n == 1 && this.hasChildren(object)) {
                if (n2 > 0) {
                    return Messages.format(PHPUIMessages.SearchLabelProvider_potential_singular, string);
                }
                return Messages.format(PHPUIMessages.SearchLabelProvider_exact_singular, string);
            }
            if (n2 > 0) {
                return Messages.format(PHPUIMessages.SearchLabelProvider_potential_noCount, string);
            }
            return Messages.format(PHPUIMessages.SearchLabelProvider_exact_noCount, string);
        }
        int n3 = n - n2;
        if (n2 > 0 && n3 > 0) {
            Object[] objectArray = new String[]{string, String.valueOf(n), String.valueOf(n3), String.valueOf(n2)};
            return Messages.format(PHPUIMessages.SearchLabelProvider_exact_and_potential_plural, objectArray);
        }
        if (n3 == 0) {
            Object[] objectArray = new String[]{string, String.valueOf(n)};
            return Messages.format(PHPUIMessages.SearchLabelProvider_potential_plural, objectArray);
        }
        Object[] objectArray = new String[]{string, String.valueOf(n)};
        return Messages.format(PHPUIMessages.SearchLabelProvider_exact_plural, objectArray);
    }

    protected boolean hasChildren(Object object) {
        return false;
    }

    public void dispose() {
        if (this.fPotentialMatchFgColor != null) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
        }
        this.fSearchPreferences.removePropertyChangeListener(this.fSearchPropertyListener);
        Iterator iterator = this.fLabelProviderMap.values().iterator();
        while (iterator.hasNext()) {
            ILabelProvider iLabelProvider = (ILabelProvider)iterator.next();
            iLabelProvider.dispose();
        }
        this.fSearchPreferences = null;
        this.fSearchPropertyListener = null;
        this.fLabelProviderMap.clear();
        super.dispose();
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        super.addListener(iLabelProviderListener);
        Iterator iterator = this.fLabelProviderMap.values().iterator();
        while (iterator.hasNext()) {
            ILabelProvider iLabelProvider = (ILabelProvider)iterator.next();
            iLabelProvider.addListener(iLabelProviderListener);
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return PROPERTY_MATCH_COUNT.equals(string);
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        super.removeListener(iLabelProviderListener);
        Iterator iterator = this.fLabelProviderMap.values().iterator();
        while (iterator.hasNext()) {
            ILabelProvider iLabelProvider = (ILabelProvider)iterator.next();
            iLabelProvider.removeListener(iLabelProviderListener);
        }
    }

    private boolean arePotentialMatchesEmphasized() {
        return this.fSearchPreferences.getBoolean(EMPHASIZE_POTENTIAL_MATCHES);
    }

    private RGB getPotentialMatchForegroundColor() {
        return PreferenceConverter.getColor((IPreferenceStore)this.fSearchPreferences, (String)POTENTIAL_MATCH_FG_COLOR);
    }
}

