/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.UDDIUtils;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;
import org.w3c.dom.Element;

public class WSI3004
extends AssertionProcessVisitor
implements WSITag {
    private final UDDIValidatorImpl validator;
    private static final String PORTS_PARAM = "ports";
    private static final String BINDING_PARAM = "binding";

    public WSI3004(UDDIValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    private HashSet getConformanceClaimsFromUDDI(TModel tModel) throws WSIException {
        String conformanceKey = UDDIUtils.getWSIConformanceTModelKey(this.validator.uddiProxy);
        HashSet<String> result = new HashSet<String>();
        CategoryBag bag = tModel.getCategoryBag();
        if (bag != null) {
            Vector references = bag.getKeyedReferenceVector();
            int i = 0;
            while (i < references.size()) {
                KeyedReference ref = (KeyedReference)references.get(i);
                if (ref.getTModelKey().equalsIgnoreCase(conformanceKey)) {
                    result.add(ref.getKeyValue());
                }
                ++i;
            }
        }
        return result;
    }

    private HashSet getConformanceClaimsFromWSDL(TModel tModel) {
        HashSet result = new HashSet();
        try {
            String overviewURL = this.validator.getOverviewURL(tModel);
            WSDLDocument wsdlDocument = this.validator.getWSDLDocument(overviewURL);
            Binding binding = this.validator.getBinding(overviewURL, wsdlDocument);
            String bindingName = binding.getQName().getLocalPart();
            result = this.getClaimsFromElement(binding.getDocumentationElement(), result);
            Vector ports = this.getPorts(wsdlDocument, bindingName);
            int i = 0;
            while (i < ports.size()) {
                Port port = (Port)ports.get(i);
                result = this.getClaimsFromElement(port.getDocumentationElement(), result);
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private HashSet getClaimsFromElement(Element docElement, HashSet result) {
        if (result == null) {
            result = new HashSet<String>();
        }
        if (docElement != null) {
            Element claimElement = XMLUtils.findChildElement(docElement, WSI_CLAIM);
            while (claimElement != null) {
                String value = claimElement.getAttribute(ATTR_CLAIM_CONFORMSTO.getLocalPart());
                if (value != null) {
                    result.add(value);
                }
                claimElement = XMLUtils.findElement(claimElement, WSI_CLAIM);
            }
        }
        return result;
    }

    private Vector getPorts(WSDLDocument wsdlDocument, String bindingName) {
        Vector ports = new Vector();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PORTS_PARAM, ports);
        params.put(BINDING_PARAM, bindingName);
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitPort(true);
        traversal.ignoreReferences();
        traversal.ignoreImport();
        traversal.traverse(wsdlDocument.getDefinitions(), params);
        return ports;
    }

    public void visit(Port port, Object parent, WSDLTraversalContext ctx) {
        if (port.getBinding().getQName().getLocalPart().equals(ctx.getParameter(BINDING_PARAM).toString())) {
            ((Vector)ctx.getParameter(PORTS_PARAM)).add(port);
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        TModel tModel = (TModel)entryContext.getEntry().getEntryDetail();
        if (tModel == null) {
            this.result = "failed";
            this.failureDetailMessage = "Could not locate a tModel.";
        } else {
            try {
                HashSet claimsFromUDDI = this.getConformanceClaimsFromUDDI(tModel);
                HashSet claimsFromWSDL = this.getConformanceClaimsFromWSDL(tModel);
                if (claimsFromUDDI.size() == 0) {
                    this.result = "passed";
                } else if (claimsFromUDDI.size() == claimsFromWSDL.size()) {
                    int counter = 0;
                    Iterator iter = claimsFromWSDL.iterator();
                    block2: while (iter.hasNext()) {
                        String claim = (String)iter.next();
                        Iterator iter2 = claimsFromUDDI.iterator();
                        while (iter2.hasNext()) {
                            String uddiClaim = (String)iter2.next();
                            if (!claim.equalsIgnoreCase(uddiClaim)) continue;
                            ++counter;
                            continue block2;
                        }
                    }
                    if (counter != claimsFromWSDL.size()) {
                        this.result = "failed";
                        this.failureDetailMessage = "The tModel key is: [" + tModel.getTModelKey() + "].";
                    }
                } else {
                    this.result = "failed";
                    this.failureDetailMessage = "The tModel key is: [" + tModel.getTModelKey() + "].";
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.result = "failed";
                this.failureDetailMessage = "The tModel key is: [" + tModel.getTModelKey() + "].";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }
}

