/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.model;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.debug.core.debugger.Breakpoint;
import org.eclipse.php.debug.core.model.PHPLineBreakpoint;

public class PHPConditionalBreakpoint
extends PHPLineBreakpoint {
    private boolean fConditionEnabled = false;
    private String fCondition = "";

    public PHPConditionalBreakpoint() {
    }

    public PHPConditionalBreakpoint(final IResource iResource, final int n, final Map map) throws CoreException {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IMarker iMarker = iResource.createMarker("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker");
                map.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                map.put("org.eclipse.debug.core.id", PHPConditionalBreakpoint.this.getModelIdentifier());
                map.put("message", MessageFormat.format(PHPDebugCoreMessages.LineBreakPointMessage_1, iResource.getName(), Integer.toString(n)));
                map.put("org.eclipse.php.debug.core.ConditionEnabled", Boolean.FALSE);
                map.put("org.eclipse.php.debug.core.Condition", "");
                map.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
                map.put("lineNumber", new Integer(n));
                iMarker.setAttributes(map);
                PHPConditionalBreakpoint.this.setMarker(iMarker);
                PHPConditionalBreakpoint.this.setEnabled(true);
                PHPConditionalBreakpoint.this.register(true);
                PHPConditionalBreakpoint.this.setPersisted(true);
            }
        };
        iResource.getWorkspace().run(iWorkspaceRunnable, null, 1, null);
    }

    public void setMarker(IMarker iMarker) throws CoreException {
        super.setMarker(iMarker);
        this.fCondition = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Condition");
        Boolean bl = (Boolean)iMarker.getAttribute("org.eclipse.php.debug.core.ConditionEnabled");
        this.fConditionEnabled = bl;
        this.addConditionToBP();
    }

    public void setConditionWithEnable(boolean bl, String string) throws CoreException {
        this.fCondition = string;
        IMarker iMarker = this.getMarker();
        iMarker.setAttribute("org.eclipse.php.debug.core.Condition", (Object)string);
        this.fConditionEnabled = bl;
        iMarker.setAttribute("org.eclipse.php.debug.core.ConditionEnabled", (Object)new Boolean(bl));
        int n = (Integer)iMarker.getAttribute("lineNumber");
        if (bl) {
            String string2 = MessageFormat.format(PHPDebugCoreMessages.ConditionalBreakPointMessage_1, iMarker.getResource().getName(), Integer.toString(n));
            string2 = String.valueOf(string2) + MessageFormat.format(PHPDebugCoreMessages.ConditionalBreakPointMessage_2, string);
            iMarker.setAttribute("message", (Object)string2);
        } else {
            iMarker.setAttribute("message", (Object)MessageFormat.format(PHPDebugCoreMessages.LineBreakPointMessage_1, iMarker.getResource().getName(), Integer.toString(n)));
        }
        this.addConditionToBP();
        this.setConditionChanged(true);
    }

    public String getCondition() {
        return this.fCondition;
    }

    public boolean isConditionEnabled() {
        return this.fConditionEnabled;
    }

    protected void addConditionToBP() {
        Breakpoint breakpoint = this.getRuntimeBreakpoint();
        if (this.isConditionEnabled()) {
            breakpoint.setConditionalFlag(true);
            breakpoint.setExpression(this.getCondition());
        } else {
            breakpoint.setConditionalFlag(false);
            breakpoint.setStaticFlag(true);
        }
    }
}

