/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.sse.core.internal.util.Assert;

public class GenericPositionManager {
    private CharSequence fCharSequence;
    private Map fPositions;
    private List fPositionUpdaters;

    private GenericPositionManager() {
    }

    public GenericPositionManager(CharSequence charSequence) {
        this();
        this.fCharSequence = charSequence;
        this.completeInitialization();
    }

    public void addPosition(Position position) throws BadLocationException {
        try {
            this.addPosition("__dflt_position_category", position);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        if (position.offset < 0 || position.length < 0 || position.offset + position.length > this.getDocumentLength()) {
            throw new BadLocationException();
        }
        if (category == null) {
            throw new BadPositionCategoryException();
        }
        List list = (List)this.fPositions.get(category);
        if (list == null) {
            throw new BadPositionCategoryException();
        }
        list.add(this.computeIndexInPositionList(list, position.offset), position);
    }

    public void addPositionCategory(String category) {
        if (category == null) {
            return;
        }
        if (!this.containsPositionCategory(category)) {
            this.fPositions.put(category, new ArrayList());
        }
    }

    public void addPositionUpdater(IPositionUpdater updater) {
        this.insertPositionUpdater(updater, this.fPositionUpdaters.size());
    }

    protected void completeInitialization() {
        this.fPositions = new HashMap();
        this.fPositionUpdaters = new ArrayList();
        this.addPositionCategory("__dflt_position_category");
        this.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("__dflt_position_category"));
    }

    public int computeIndexInCategory(String category, int offset) throws BadLocationException, BadPositionCategoryException {
        if (offset < 0 || offset > this.getDocumentLength()) {
            throw new BadLocationException();
        }
        List c = (List)this.fPositions.get(category);
        if (c == null) {
            throw new BadPositionCategoryException();
        }
        return this.computeIndexInPositionList(c, offset);
    }

    protected int computeIndexInPositionList(List positions, int offset) {
        if (positions.size() == 0) {
            return 0;
        }
        int left = 0;
        int right = positions.size() - 1;
        int mid = 0;
        Position p = null;
        while (left < right) {
            mid = (left + right) / 2;
            p = (Position)positions.get(mid);
            if (offset < p.getOffset()) {
                if (left == mid) {
                    right = left;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if (offset > p.getOffset()) {
                if (right == mid) {
                    left = right;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            if (offset != p.getOffset()) continue;
            left = right = mid;
        }
        int pos = left;
        p = (Position)positions.get(pos);
        if (offset > p.getOffset()) {
            ++pos;
        } else {
            while (--pos >= 0 && offset == (p = (Position)positions.get(pos)).getOffset()) {
            }
            ++pos;
        }
        Assert.isTrue(pos >= 0 && pos <= positions.size());
        return pos;
    }

    public boolean containsPosition(String category, int offset, int length) {
        if (category == null) {
            return false;
        }
        List list = (List)this.fPositions.get(category);
        if (list == null) {
            return false;
        }
        int size = list.size();
        if (size == 0) {
            return false;
        }
        int index = this.computeIndexInPositionList(list, offset);
        if (index < size) {
            Position p = (Position)list.get(index);
            while (p != null && p.offset == offset) {
                if (p.length == length) {
                    return true;
                }
                Position position = p = ++index < size ? (Position)list.get(index) : null;
            }
        }
        return false;
    }

    public boolean containsPositionCategory(String category) {
        if (category != null) {
            return this.fPositions.containsKey(category);
        }
        return false;
    }

    public int getDocumentLength() {
        return this.fCharSequence.length();
    }

    protected Map getDocumentManagedPositions() {
        return this.fPositions;
    }

    public String[] getPositionCategories() {
        String[] categories = new String[this.fPositions.size()];
        Iterator keys = this.fPositions.keySet().iterator();
        int i = 0;
        while (i < categories.length) {
            categories[i] = (String)keys.next();
            ++i;
        }
        return categories;
    }

    public Position[] getPositions(String category) throws BadPositionCategoryException {
        if (category == null) {
            throw new BadPositionCategoryException();
        }
        List c = (List)this.fPositions.get(category);
        if (c == null) {
            throw new BadPositionCategoryException();
        }
        Position[] positions = new Position[c.size()];
        c.toArray(positions);
        return positions;
    }

    public IPositionUpdater[] getPositionUpdaters() {
        IPositionUpdater[] updaters = new IPositionUpdater[this.fPositionUpdaters.size()];
        this.fPositionUpdaters.toArray(updaters);
        return updaters;
    }

    public void insertPositionUpdater(IPositionUpdater updater, int index) {
        int i = this.fPositionUpdaters.size() - 1;
        while (i >= 0) {
            if (this.fPositionUpdaters.get(i) == updater) {
                return;
            }
            --i;
        }
        if (index == this.fPositionUpdaters.size()) {
            this.fPositionUpdaters.add(updater);
        } else {
            this.fPositionUpdaters.add(index, updater);
        }
    }

    public void removePosition(Position position) {
        try {
            this.removePosition("__dflt_position_category", position);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void removePosition(String category, Position position) throws BadPositionCategoryException {
        if (position == null) {
            return;
        }
        if (category == null) {
            throw new BadPositionCategoryException();
        }
        List c = (List)this.fPositions.get(category);
        if (c == null) {
            throw new BadPositionCategoryException();
        }
        int size = c.size();
        int i = 0;
        while (i < size) {
            if (position == c.get(i)) {
                c.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removePositionCategory(String category) throws BadPositionCategoryException {
        if (category == null) {
            return;
        }
        if (!this.containsPositionCategory(category)) {
            throw new BadPositionCategoryException();
        }
        this.fPositions.remove(category);
    }

    public void removePositionUpdater(IPositionUpdater updater) {
        int i = this.fPositionUpdaters.size() - 1;
        while (i >= 0) {
            if (this.fPositionUpdaters.get(i) == updater) {
                this.fPositionUpdaters.remove(i);
                return;
            }
            --i;
        }
    }

    protected void updatePositions(DocumentEvent event) {
        ArrayList list = new ArrayList(this.fPositionUpdaters);
        Iterator e = list.iterator();
        while (e.hasNext()) {
            IPositionUpdater u = (IPositionUpdater)e.next();
            u.update(event);
        }
    }
}

