/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.search.ISearchIndex;
import org.eclipse.help.search.LuceneSearchParticipant;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractTextElement;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.Bundle;

public class IntroSearchParticipant
extends LuceneSearchParticipant {
    private IntroModelRoot model;

    public Set getContributingPlugins() {
        IConfigurationElement element;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.config");
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (element.getName().equals("config")) {
                set.add(element.getContributor().getName());
            }
            ++i;
        }
        elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.configExtension");
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (element.getName().equals("configExtension")) {
                set.add(element.getContributor().getName());
            }
            ++i;
        }
        return set;
    }

    public Set getAllDocuments(String locale) {
        String iid;
        HashSet set = new HashSet();
        IProduct product = Platform.getProduct();
        if (product == null) {
            return set;
        }
        String productId = product.getId();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro");
        String targetIntroId = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("introProductBinding")) {
                String pid = element.getAttribute("productId");
                iid = element.getAttribute("introId");
                if (productId.equals(pid)) {
                    targetIntroId = iid;
                    break;
                }
            }
            ++i;
        }
        if (targetIntroId == null) {
            return set;
        }
        elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.config");
        IConfigurationElement config = null;
        int i2 = 0;
        while (i2 < elements.length) {
            IConfigurationElement element = elements[i2];
            if (element.getName().equals("config") && targetIntroId.equals(iid = element.getAttribute("introId"))) {
                config = element;
                break;
            }
            ++i2;
        }
        if (config == null) {
            return set;
        }
        String configId = config.getAttribute("id");
        ExtensionPointManager extensionPointManager = IntroPlugin.getDefault().getExtensionPointManager();
        this.model = extensionPointManager.getModel(configId);
        if (this.model != null && this.model.hasValidConfig()) {
            this.loadFromModel(this.model, set, locale);
        }
        return set;
    }

    private void loadFromModel(IntroModelRoot model, HashSet set, String locale) {
        IntroPage[] pages = model.getPages();
        int i = 0;
        while (i < pages.length) {
            IntroPage page = pages[i];
            Bundle bundle = page.getBundle();
            String bundleId = bundle.getSymbolicName();
            String content = page.getRawContent();
            String pageId = page.getId();
            String href = content != null ? IntroSearchParticipant.resolveVariables((String)bundleId, (String)content, (String)locale) : pageId;
            set.add("/" + bundleId + "/" + href + "?id=" + pageId);
            ++i;
        }
    }

    public IStatus addDocument(ISearchIndex index, String pluginId, String name, URL url, String id, Document doc) {
        if (this.model == null) {
            return Status.CANCEL_STATUS;
        }
        IntroPage page = this.getPage(id);
        if (page == null) {
            return Status.CANCEL_STATUS;
        }
        return this.addPage(index, pluginId, name, url, page, doc);
    }

    private IntroPage getPage(String id) {
        IntroPage[] pages = this.model.getPages();
        int i = 0;
        while (i < pages.length) {
            if (pages[i].getId().equals(id)) {
                return pages[i];
            }
            ++i;
        }
        return null;
    }

    private IStatus addPage(ISearchIndex index, String pluginId, String name, URL url, IntroPage page, Document doc) {
        AbstractIntroElement[] children = page.getChildren();
        if (children.length > 0) {
            StringBuffer buf = new StringBuffer();
            this.addChildren(children, buf, doc);
            doc.add(Field.Text((String)"contents", (Reader)new StringReader(buf.toString())));
            doc.add(Field.Text((String)"exact_contents", (Reader)new StringReader(buf.toString())));
            return Status.OK_STATUS;
        }
        return index.addDocument(pluginId, name, url, page.getId(), doc);
    }

    private void addChildren(AbstractIntroElement[] children, StringBuffer buf, Document doc) {
        int i = 0;
        while (i < children.length) {
            AbstractIntroElement child = children[i];
            if (child instanceof AbstractTextElement) {
                String text = ((AbstractTextElement)child).getText();
                this.appendNewText(buf, text);
            } else if (child instanceof IntroText) {
                this.appendNewText(buf, ((IntroText)child).getText());
                if (child instanceof IntroPageTitle) {
                    this.addTitle(((IntroPageTitle)child).getTitle(), doc);
                }
            } else if (child instanceof AbstractIntroContainer) {
                AbstractIntroContainer container = (AbstractIntroContainer)child;
                AbstractIntroElement[] cc = container.getChildren();
                this.addChildren(cc, buf, doc);
            }
            ++i;
        }
    }

    private void appendNewText(StringBuffer buf, String text) {
        if (buf.length() > 0) {
            buf.append(" ");
        }
        buf.append(text);
    }

    public void clear() {
        this.model = null;
    }

    public boolean open(String id) {
        IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
        IIntroPart intro = introManager.showIntro(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), false);
        if (intro == null) {
            return false;
        }
        IIntroURL url = IntroURLFactory.createIntroURL("http://org.eclipse.ui.intro/showPage?id=" + id);
        return url.execute();
    }
}

