/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jem.internal.proxy.core.ContainerPathContributionMapping;
import org.eclipse.jem.internal.proxy.core.ContributorExtensionPointInfo;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.internal.proxy.core.ListenerList;
import org.eclipse.jem.internal.proxy.core.ProxyLaunchSupport;
import org.eclipse.jem.internal.proxy.core.ProxyMessages;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.logger.proxyrender.EclipseLogger;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class ProxyPlugin
extends Plugin {
    private static ProxyPlugin PROXY_PLUGIN = null;
    public static final String PREFERENCES_VM_NOVERIFY_KEY = "JEM_PREFERENCES_VM_NOVERIFY_KEY";
    public static final String PDE_NATURE_ID = "org.eclipse.pde.PluginNature";
    private boolean devMode;
    private ListenerList shutdownListeners;
    private Logger logger;
    private static final String PROXYJARS = "proxy.jars";
    private ILaunchConfigurationListener launchListener = new ILaunchConfigurationListener(){

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            try {
                if (!configuration.isWorkingCopy() && "org.eclipse.jem.proxy".equals(configuration.getCategory())) {
                    ProxyPlugin.this.startCleanupJob();
                }
            }
            catch (Exception exception) {}
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            try {
                if (!configuration.isWorkingCopy() && "org.eclipse.jem.proxy".equals(configuration.getCategory())) {
                    ProxyPlugin.this.startCleanupJob();
                }
            }
            catch (Exception exception) {}
        }

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            try {
                if (!configuration.isWorkingCopy()) {
                    ProxyPlugin.this.startCleanupJob();
                }
            }
            catch (Exception exception) {}
        }
    };
    private Job cleanupJob = new Job(ProxyMessages.ProxyPlugin_CleanupDefaultProxyLaunchConfigurations){
        {
            this.setSystem(true);
            this.setPriority(20);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            2 var2_2 = this;
            synchronized (var2_2) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
            }
            try {
                HashSet<String> projectNames = new HashSet<String>();
                ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                int i = 0;
                while (i < configs.length) {
                    if ("org.eclipse.jem.proxy".equals(configs[i].getCategory()) && (ProxyLaunchSupport.ATTR_PRIVATE == null || !configs[i].getAttribute(ProxyLaunchSupport.ATTR_PRIVATE, false))) {
                        projectNames.add(configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""));
                    }
                    ++i;
                }
                IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                IJavaElement[] children = model.getChildren();
                int cancelCount = 10;
                int j = 0;
                while (j < children.length) {
                    if (children[j].getElementType() == 2) {
                        IProject p;
                        if (--cancelCount <= 0) {
                            2 var8_10 = this;
                            synchronized (var8_10) {
                                cancelCount = 10;
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                            }
                        }
                        if (projectNames.contains((p = ((IJavaProject)children[j]).getProject()).getName())) {
                            if (p.getPersistentProperty(PROPERTY_LAUNCH_CONFIGURATION) == null) {
                                p.getProject().setPersistentProperty(PROPERTY_LAUNCH_CONFIGURATION, "...not..set..");
                            }
                        } else {
                            p.setPersistentProperty(PROPERTY_LAUNCH_CONFIGURATION, null);
                        }
                    }
                    ++j;
                }
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
    };
    public static final String PI_CONFIGURATION_CONTRIBUTION_EXTENSION_POINT = "org.eclipse.jem.proxy.contributors";
    public static final String PI_EXTENSION_REGISTRATION_EXTENSION_POINT = "org.eclipse.jem.proxy.extensions";
    public static final String PI_CONTAINER = "container";
    public static final String PI_PLUGIN = "plugin";
    public static final String PI_CLASS = "class";
    public static final String PI_REGISTRY_TYPE = "registryType";
    public static final Map pluginRequiredMap = new HashMap(50);
    protected ContributorExtensionPointInfo contributions;
    protected ContributorExtensionPointInfo extensions;
    public static final QualifiedName PROPERTY_LAUNCH_CONFIGURATION = new QualifiedName("org.eclipse.jem.proxy", "proxyLaunchConfiguration");
    private static final IPath JRE_CONTAINER_PATH = new Path(JavaRuntime.JRE_CONTAINER);
    private IPDEProcessForPlugin pdeProcessForPlugin;
    private boolean triedPDEProcess;
    static /* synthetic */ Class class$0;

    public ProxyPlugin() {
        PROXY_PLUGIN = this;
        this.devMode = Platform.inDevelopmentMode();
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public static ProxyPlugin getPlugin() {
        return PROXY_PLUGIN;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = EclipseLogger.getEclipseLogger((Plugin)this);
        }
        return this.logger;
    }

    public String localizeFromBundleOnly(Bundle bundle, String filenameWithinBundle) {
        URL url = this.urlLocalizeFromBundleOnly(bundle, filenameWithinBundle);
        return url != null ? ProxyPlugin.getFileFromURL(url) : ".";
    }

    public String localizeFromBundleAndFragments(Bundle bundle, String filenameWithinBundle) {
        URL url = this.urlLocalizeFromBundleAndFragments(bundle, filenameWithinBundle);
        return url != null ? ProxyPlugin.getFileFromURL(url) : ".";
    }

    public String[] localizeAllFromBundleAndFragments(Bundle bundle, String filenameWithinBundle) {
        URL[] urls = this.urlLocalizeAllFromBundleAndFragments(bundle, filenameWithinBundle);
        String[] result = new String[urls.length];
        int i = 0;
        while (i < urls.length) {
            result[i] = ProxyPlugin.getFileFromURL(urls[i]);
            ++i;
        }
        return result;
    }

    public static String getFileFromURL(URL url) {
        return new File(url.getFile()).getAbsolutePath();
    }

    public URL urlLocalizeFromBundleAndFragments(Bundle bundle, String filenameWithinBundle) {
        return this.urlLocalizeFromBundleAndFragments(bundle, (IPath)new Path(filenameWithinBundle));
    }

    public URL urlLocalizeFromBundleAndFragments(Bundle bundle, IPath filenameWithinBundle) {
        try {
            URL pvm = FileLocator.find((Bundle)bundle, (IPath)filenameWithinBundle, null);
            if (pvm != null) {
                return FileLocator.toFileURL((URL)pvm);
            }
        }
        catch (IOException iOException) {}
        if (this.devMode) {
            URL[] urls = this.findDevAllFromBundleAndFragments(bundle, filenameWithinBundle.toString());
            if (urls.length > 0) {
                return urls[0];
            }
            return null;
        }
        return null;
    }

    public URL[] urlLocalizeAllFromBundleAndFragments(Bundle bundle, String filenameWithinBundle) {
        return this.urlLocalizeAllBundleAndFragments(bundle, Platform.getFragments((Bundle)bundle), filenameWithinBundle);
    }

    public URL[] urlLocalizeAllFromBundleAndFragments(Bundle bundle, IPath filenameWithinBundle) {
        return this.urlLocalizeAllBundleAndFragments(bundle, Platform.getFragments((Bundle)bundle), filenameWithinBundle.toString());
    }

    private URL[] urlLocalizeAllBundleAndFragments(Bundle bundle, Bundle[] fragments, String filenameWithinBundle) {
        ArrayList<URL> urls = new ArrayList<URL>((fragments == null ? 0 : fragments.length) + 1);
        URL url = this.internalUrlLocalizeFromBundleOnly(bundle, filenameWithinBundle);
        if (url != null) {
            urls.add(url);
        }
        if (fragments != null) {
            int i = 0;
            while (i < fragments.length) {
                Bundle fragment = fragments[i];
                url = this.internalUrlLocalizeFromBundleOnly(fragment, filenameWithinBundle);
                if (url != null) {
                    urls.add(url);
                }
                ++i;
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public URL urlLocalizeFromBundleOnly(Bundle bundle, String filenameWithinBundle) {
        if (filenameWithinBundle.charAt(0) == '$' && (filenameWithinBundle.regionMatches(true, 0, "$nl$", 0, "$nl$".length()) || filenameWithinBundle.regionMatches(true, 0, "$os$", 0, "$os$".length()) || filenameWithinBundle.regionMatches(true, 0, "$ws$", 0, "$ws$".length()))) {
            return this.urlLocalizeFromBundleAndFragments(bundle, filenameWithinBundle);
        }
        try {
            URL pvm = new URL(bundle.getEntry("/"), filenameWithinBundle);
            pvm = this.verifyFound(FileLocator.toFileURL((URL)pvm));
            if (pvm != null) {
                return pvm;
            }
        }
        catch (IOException iOException) {}
        return this.findDev(bundle, filenameWithinBundle);
    }

    protected URL internalUrlLocalizeFromBundleOnly(Bundle bundle, String filenameWithinBundle) {
        try {
            URL pvm = bundle.getEntry(filenameWithinBundle);
            if (pvm != null) {
                return FileLocator.toFileURL((URL)pvm);
            }
        }
        catch (IOException iOException) {}
        return this.findDev(bundle, filenameWithinBundle);
    }

    /*
     * Exception decompiling
     */
    private URL verifyFound(URL pvm) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 53->59)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public URL urlLocalizeFromBundleOnly(Bundle bundle, IPath filenameWithinBundle) {
        return this.urlLocalizeFromBundleOnly(bundle, filenameWithinBundle.toString());
    }

    /*
     * Exception decompiling
     */
    private URL findDev(Bundle bundle, String filenameWithinBundle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 157->163)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URL[] findDevAllFromBundleAndFragments(Bundle bundle, String filenameWithinBundle) {
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        ArrayList<URL> urls = new ArrayList<URL>((fragments == null ? 0 : fragments.length) + 1);
        URL url = this.findDev(bundle, filenameWithinBundle);
        if (url != null) {
            urls.add(url);
        }
        if (fragments != null) {
            int i = 0;
            while (i < fragments.length) {
                Bundle fragment = fragments[i];
                url = this.findDev(fragment, filenameWithinBundle);
                if (url != null) {
                    urls.add(url);
                }
                ++i;
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public URL[] urlLocalizeBundleAndFragments(Bundle bundle) {
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        ArrayList<URL> urls = new ArrayList<URL>((fragments == null ? 0 : fragments.length) + 1);
        URL[] burls = this.urlLocalizeBundle(bundle);
        if (burls != null) {
            urls.addAll(Arrays.asList(burls));
        }
        if (fragments != null) {
            int i = 0;
            while (i < fragments.length) {
                burls = this.urlLocalizeBundle(fragments[i]);
                if (burls != null) {
                    urls.addAll(Arrays.asList(burls));
                }
                ++i;
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    /*
     * Exception decompiling
     */
    public URL[] urlLocalizeBundle(Bundle bundle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [3 : 221->227)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static URL getFilePath(URL l) {
        if (l != null) {
            if (l.getProtocol().equals("file")) {
                return l;
            }
            if (l.getProtocol().equals("jar")) {
                String f = l.getFile();
                int idx = f.lastIndexOf(33);
                if (idx >= 0) {
                    f = f.substring(0, idx);
                }
                try {
                    return ProxyPlugin.getFilePath(new URL(f));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return null;
    }

    public static Bundle[] orderPlugins(Set bundlesToOrder) {
        HashMap prereqsMap = new HashMap(bundlesToOrder.size() * 3);
        int ndx = bundlesToOrder.size();
        Bundle[] result = new Bundle[ndx];
        Map dependents = ProxyPlugin.getDependentCounts(false, bundlesToOrder, prereqsMap);
        while (!dependents.isEmpty()) {
            Iterator ib = dependents.entrySet().iterator();
            while (ib.hasNext()) {
                Map.Entry entry = ib.next();
                Bundle bundle = (Bundle)entry.getKey();
                int[] count = (int[])entry.getValue();
                if (count == null || count[0] > 0) continue;
                if (bundlesToOrder.contains(bundle)) {
                    result[--ndx] = bundle;
                    if (ndx == 0) {
                        return result;
                    }
                }
                ib.remove();
                Bundle[] requires = ProxyPlugin.getPrereqs(bundle, prereqsMap);
                int j = 0;
                while (j < requires.length) {
                    Bundle prereq = requires[j];
                    int[] countPrereq = (int[])dependents.get(prereq);
                    if (countPrereq != null) {
                        countPrereq[0] = countPrereq[0] - 1;
                    }
                    ++j;
                }
            }
        }
        return result;
    }

    public static List getAllPrereqs(Bundle bundle) {
        ArrayList prereqs = new ArrayList();
        ProxyPlugin.getAllPrereqs(bundle, prereqs, new HashMap());
        return prereqs;
    }

    private static void getAllPrereqs(Bundle bundle, List prereqs, Map prereqsMap) {
        Bundle[] prs = ProxyPlugin.getPrereqs(bundle, prereqsMap);
        int i = 0;
        while (i < prs.length) {
            Bundle pre = prs[i];
            if (!prereqsMap.containsKey(pre)) {
                prereqs.add(pre);
                ProxyPlugin.getAllPrereqs(pre, prereqs, prereqsMap);
            }
            ++i;
        }
    }

    private static Bundle[] getPrereqs(Bundle bundle, Map prereqsMap) {
        Bundle[] prereqs = (Bundle[])prereqsMap.get(bundle);
        if (prereqs == null) {
            prereqs = ProxyPlugin.getPrereqs(bundle);
            prereqsMap.put(bundle, prereqs);
        }
        return prereqs;
    }

    public static Bundle[] getPrereqs(Bundle bundle) {
        Bundle[] l = (Bundle[])pluginRequiredMap.get(bundle.getSymbolicName());
        if (l == null) {
            BundleSpecification[] specs = Platform.getPlatformAdmin().getState(false).getBundle(bundle.getBundleId()).getRequiredBundles();
            ArrayList<Bundle> bundles = new ArrayList<Bundle>(specs.length);
            int i = 0;
            while (i < specs.length) {
                Bundle b = Platform.getBundle((String)specs[i].getName());
                if (b != null) {
                    bundles.add(b);
                }
                ++i;
            }
            l = bundles.toArray(new Bundle[bundles.size()]);
            pluginRequiredMap.put(bundle.getSymbolicName(), l);
        }
        return l;
    }

    private static Map getDependentCounts(boolean activeOnly, Set startingSet, Map prereqsMap) {
        Bundle bundle;
        int pnSize;
        LinkedHashMap<Bundle, int[]> dependents = new LinkedHashMap<Bundle, int[]>(startingSet.size());
        ArrayList processNow = new ArrayList(startingSet);
        ArrayList<Bundle> processNext = new ArrayList<Bundle>(processNow.size());
        if (!processNow.isEmpty()) {
            pnSize = processNow.size();
            int i = 0;
            while (i < pnSize) {
                int[] entry;
                bundle = (Bundle)processNow.get(i);
                if (!(activeOnly && bundle.getState() != 32 || (entry = (int[])dependents.get(bundle)) != null)) {
                    dependents.put(bundle, new int[1]);
                }
                ++i;
            }
        }
        while (!processNow.isEmpty()) {
            processNext.clear();
            pnSize = processNow.size();
            int i = 0;
            while (i < pnSize) {
                bundle = (Bundle)processNow.get(i);
                if (!activeOnly || bundle.getState() == 32) {
                    Bundle[] requires = ProxyPlugin.getPrereqs(bundle, prereqsMap);
                    int j = 0;
                    while (j < requires.length) {
                        Bundle prereq = requires[j];
                        if (!(prereq == null || activeOnly && bundle.getState() != 32)) {
                            int[] entry = (int[])dependents.get(prereq);
                            if (entry == null) {
                                dependents.put(prereq, new int[]{1});
                                processNext.add(prereq);
                            } else {
                                entry[0] = entry[0] + 1;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ArrayList<Bundle> t = processNext;
            processNext = processNow;
            processNow = t;
        }
        return dependents;
    }

    public void addProxyShutdownListener(IProxyPluginShutdownListener listener) {
        if (this.shutdownListeners == null) {
            this.shutdownListeners = new ListenerList();
        }
        this.shutdownListeners.add(listener);
    }

    public void removeProxyShutdownListener(IProxyPluginShutdownListener listener) {
        if (this.shutdownListeners != null) {
            this.shutdownListeners.remove(listener);
        }
    }

    private void startCleanupJob() {
        this.cleanupJob.cancel();
        this.cleanupJob.schedule(1000L);
    }

    public void start(final BundleContext context) throws Exception {
        super.start(context);
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(this.launchListener);
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() != ProxyPlugin.this.getBundle()) {
                    return;
                }
                switch (event.getType()) {
                    case 2: {
                        context.removeBundleListener((BundleListener)this);
                        ProxyPlugin.this.startCleanupJob();
                        break;
                    }
                    case 4: 
                    case 16: 
                    case 64: {
                        context.removeBundleListener((BundleListener)this);
                    }
                }
            }
        });
        this.getPluginPreferences().setDefault(PREFERENCES_VM_NOVERIFY_KEY, true);
    }

    public void stop(BundleContext context) throws Exception {
        if (DebugPlugin.getDefault() != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(this.launchListener);
        }
        this.cleanupJob.cancel();
        if (this.shutdownListeners != null) {
            Object[] listeners = this.shutdownListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IProxyPluginShutdownListener)listeners[i]).shutdown();
                ++i;
            }
        }
        super.stop(context);
    }

    public synchronized IConfigurationElement[] getContainerConfigurations(String containerid, String[] containerPaths) {
        if (this.contributions == null) {
            this.processProxyContributionExtensionPoint();
        }
        return (IConfigurationElement[])this.contributions.containerPathContributions.getContributors(containerid, containerPaths);
    }

    public synchronized IConfigurationElement[] getPluginConfigurations(String pluginid) {
        if (this.contributions == null) {
            this.processProxyContributionExtensionPoint();
        }
        return (IConfigurationElement[])this.contributions.pluginToContributions.get(pluginid);
    }

    public synchronized IConfigurationElement[] getContainerExtensions(String containerid, String[] containerPaths) {
        if (this.extensions == null) {
            this.processProxyExtensionExtensionPoint();
        }
        return (IConfigurationElement[])this.extensions.containerPathContributions.getContributors(containerid, containerPaths);
    }

    public synchronized IConfigurationElement[] getPluginExtensions(String pluginid) {
        if (this.extensions == null) {
            this.processProxyExtensionExtensionPoint();
        }
        return (IConfigurationElement[])this.extensions.pluginToContributions.get(pluginid);
    }

    protected synchronized void processProxyContributionExtensionPoint() {
        this.contributions = ProxyPlugin.processContributionExtensionPoint(PI_CONFIGURATION_CONTRIBUTION_EXTENSION_POINT);
    }

    protected synchronized void processProxyExtensionExtensionPoint() {
        this.extensions = ProxyPlugin.processContributionExtensionPoint(PI_EXTENSION_REGISTRATION_EXTENSION_POINT);
    }

    public static ContributorExtensionPointInfo processContributionExtensionPoint(String extensionPoint) {
        IExtensionPoint extp = Platform.getExtensionRegistry().getExtensionPoint(extensionPoint);
        ContributorExtensionPointInfo result = new ContributorExtensionPointInfo();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IConfigurationElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result.containerPathContributions = new ContainerPathContributionMapping(clazz);
        if (extp == null) {
            result.pluginToContributions = Collections.EMPTY_MAP;
            return result;
        }
        IExtension[] extensions = extp.getExtensions();
        if (extensions.length > 0) {
            LinkedHashMap<Bundle, IExtension[]> bundlesToExtensions = new LinkedHashMap<Bundle, IExtension[]>(extensions.length);
            int i = extensions.length - 1;
            while (i >= 0) {
                Bundle bundle = Platform.getBundle((String)extensions[i].getContributor().getName());
                IExtension[] ext = (IExtension[])((HashMap)bundlesToExtensions).get(bundle);
                if (ext == null) {
                    bundlesToExtensions.put(bundle, new IExtension[]{extensions[i]});
                } else {
                    IExtension[] newExt = new IExtension[ext.length + 1];
                    System.arraycopy(ext, 0, newExt, 0, ext.length);
                    newExt[newExt.length - 1] = extensions[i];
                    bundlesToExtensions.put(bundle, newExt);
                }
                --i;
            }
            Bundle[] ordered = ProxyPlugin.orderPlugins(((HashMap)bundlesToExtensions).keySet());
            HashMap<String, Object[]> patternStringToID_Pattern = new HashMap<String, Object[]>();
            result.pluginToContributions = new HashMap(ordered.length);
            int i2 = 0;
            while (i2 < ordered.length) {
                IExtension[] exts = (IExtension[])((HashMap)bundlesToExtensions).get(ordered[i2]);
                int j = 0;
                while (j < exts.length) {
                    IConfigurationElement[] configs = exts[j].getConfigurationElements();
                    int k = 0;
                    while (k < configs.length) {
                        String plugin;
                        String containerPattern = configs[k].getAttributeAsIs(PI_CONTAINER);
                        if (containerPattern != null) {
                            Object[] id_Pattern = (Object[])patternStringToID_Pattern.get(containerPattern);
                            if (id_Pattern == null) {
                                int slash = containerPattern.indexOf(47);
                                String containerID = slash != -1 ? containerPattern.substring(0, slash) : containerPattern;
                                id_Pattern = new Object[]{containerID, Pattern.compile(String.valueOf(containerPattern) + "(/.*)*")};
                                patternStringToID_Pattern.put(containerPattern, id_Pattern);
                            }
                            result.containerPathContributions.addContribution((String)id_Pattern[0], (Pattern)id_Pattern[1], configs[k]);
                        }
                        if ((plugin = configs[k].getAttributeAsIs(PI_PLUGIN)) != null) {
                            ArrayList<IConfigurationElement> contributions = (ArrayList<IConfigurationElement>)result.pluginToContributions.get(plugin);
                            if (contributions == null) {
                                contributions = new ArrayList<IConfigurationElement>(1);
                                result.pluginToContributions.put(plugin, contributions);
                            }
                            contributions.add(configs[k]);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            result.containerPathContributions.finalizeMapping();
            Iterator iter = result.pluginToContributions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                entry.setValue(((List)entry.getValue()).toArray(new IConfigurationElement[((List)entry.getValue()).size()]));
            }
        } else {
            result.pluginToContributions = Collections.EMPTY_MAP;
        }
        return result;
    }

    public FoundIDs getIDsFound(IJavaProject jproject) throws JavaModelException {
        IPath projectPath = jproject.getProject().getFullPath();
        FoundIDs foundIDs = new FoundIDs();
        foundIDs.projects.put(projectPath, Boolean.TRUE);
        this.expandProject(projectPath, foundIDs, true, true);
        Iterator itr = foundIDs.containerIds.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            Map[] value = (Map[])entry.getValue();
            entry.setValue(new IConfigurationContributionInfo.ContainerPaths((String)entry.getKey(), value[0].values().toArray(new String[value[0].size()]), value[1].values().toArray(new String[value[1].size()])));
        }
        if (foundIDs.pluginIds == null) {
            foundIDs.pluginIds = Collections.EMPTY_MAP;
        }
        foundIDs.projects.remove(projectPath);
        if (foundIDs.projects.isEmpty()) {
            foundIDs.projects = Collections.EMPTY_MAP;
        }
        return foundIDs;
    }

    private void expandProject(IPath projectPath, FoundIDs foundIds, boolean visible, boolean first) throws JavaModelException {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(projectPath.lastSegment());
        if (res == null) {
            return;
        }
        IJavaProject project = (IJavaProject)JavaCore.create((IResource)res);
        if (project == null || !project.exists() || !project.getProject().isOpen()) {
            return;
        }
        IClasspathEntry[] entries = project.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            Boolean currentFlag = null;
            switch (entry.getEntryKind()) {
                case 2: {
                    boolean newFlag;
                    currentFlag = (Boolean)foundIds.projects.get(entry.getPath());
                    boolean bl = newFlag = currentFlag != null && currentFlag != false || first || visible && entry.isExported();
                    if (currentFlag == null || currentFlag != newFlag) {
                        foundIds.projects.put(entry.getPath(), newFlag ? Boolean.TRUE : Boolean.FALSE);
                    }
                    if (currentFlag != null) break;
                    this.expandProject(entry.getPath(), foundIds, visible && entry.isExported(), false);
                    break;
                }
                case 5: {
                    IClasspathContainer container;
                    boolean newFlag;
                    if (!first && JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0))) break;
                    Map[] paths = (Map[])foundIds.containerIds.get(entry.getPath().segment(0));
                    if (paths == null) {
                        paths = new Map[]{new HashMap(2), new HashMap(2)};
                        foundIds.containerIds.put(entry.getPath().segment(0), paths);
                    }
                    currentFlag = null;
                    if (paths[0].containsKey(entry.getPath())) {
                        currentFlag = Boolean.TRUE;
                    } else if (paths[1].containsKey(entry.getPath())) {
                        currentFlag = Boolean.FALSE;
                    }
                    boolean bl = newFlag = currentFlag != null && currentFlag != false || first || visible && entry.isExported();
                    if (currentFlag == null || currentFlag != newFlag) {
                        if (newFlag) {
                            paths[1].remove(entry.getPath());
                            paths[0].put(entry.getPath(), entry.getPath().toString());
                        } else {
                            paths[0].remove(entry.getPath());
                            paths[1].put(entry.getPath(), entry.getPath().toString());
                        }
                    }
                    boolean bl2 = newFlag = (currentFlag = (Boolean)foundIds.containers.get(container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project))) != null && currentFlag != false || first || visible && entry.isExported();
                    if (currentFlag != null && currentFlag == newFlag) break;
                    foundIds.containers.put(container, newFlag ? Boolean.TRUE : Boolean.FALSE);
                    break;
                }
                case 4: {
                    boolean newFlag;
                    if (!first || !"JRE_LIB".equals(entry.getPath().segment(0))) break;
                    Map[] paths = (Map[])foundIds.containerIds.get(JavaRuntime.JRE_CONTAINER);
                    if (paths == null) {
                        paths = new Map[]{new HashMap(2), new HashMap(2)};
                        foundIds.containerIds.put(JavaRuntime.JRE_CONTAINER, paths);
                    }
                    currentFlag = null;
                    if (paths[0].containsKey(JRE_CONTAINER_PATH)) {
                        currentFlag = Boolean.TRUE;
                    } else if (paths[1].containsKey(JRE_CONTAINER_PATH)) {
                        currentFlag = Boolean.FALSE;
                    }
                    boolean bl = newFlag = currentFlag != null && currentFlag != false || first || visible && entry.isExported();
                    if (currentFlag != null && currentFlag == newFlag) break;
                    if (newFlag) {
                        paths[1].remove(JRE_CONTAINER_PATH);
                        paths[0].put(JRE_CONTAINER_PATH, JavaRuntime.JRE_CONTAINER);
                        break;
                    }
                    paths[0].remove(JRE_CONTAINER_PATH);
                    paths[1].put(JRE_CONTAINER_PATH, JavaRuntime.JRE_CONTAINER);
                    break;
                }
            }
            ++i;
        }
        this.findPlugins(foundIds, visible, first, project);
    }

    public void findPlugins(FoundIDs foundIds, boolean visible, boolean first, IJavaProject project) {
        try {
            IPDEProcessForPlugin pdeprocess;
            if (ProxyPlugin.isPDEProject(project) && (pdeprocess = this.getPDEProcessForPlugin()) != null) {
                if (foundIds.pluginIds == null) {
                    foundIds.pluginIds = new HashMap();
                }
                pdeprocess.findPlugins(project, foundIds, visible, first);
            }
        }
        catch (CoreException coreException) {}
    }

    public static boolean isPDEProject(IJavaProject project) throws CoreException {
        return project.getProject().hasNature(PDE_NATURE_ID);
    }

    IPDEProcessForPlugin getPDEProcessForPlugin() {
        if (!this.triedPDEProcess) {
            this.triedPDEProcess = true;
            if (Platform.getBundle((String)"org.eclipse.pde.core") != null) {
                try {
                    Class<?> classPDEProcess = Class.forName("org.eclipse.jem.internal.proxy.core.PDEProcessForPlugin");
                    this.pdeProcessForPlugin = (IPDEProcessForPlugin)classPDEProcess.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException e) {
                    this.getLogger().log((Throwable)e, Level.WARNING);
                }
                catch (IllegalAccessException e) {
                    this.getLogger().log((Throwable)e, Level.WARNING);
                }
            }
        }
        return this.pdeProcessForPlugin;
    }

    public URL[] findPluginJarAndAttachedSource(Bundle bundle, IPath filepath) {
        URL jarURL = FileLocator.find((Bundle)bundle, (IPath)filepath, null);
        if (jarURL == null) {
            return new URL[2];
        }
        String jarString = jarURL.toExternalForm();
        String installLoc = bundle.getEntry("/").toExternalForm();
        URL sourceURL = null;
        if (jarString.startsWith(installLoc)) {
            sourceURL = this.getSrcFrom(bundle, installLoc, jarString);
        } else {
            Bundle[] frags = Platform.getFragments((Bundle)bundle);
            int i = 0;
            while (i < frags.length) {
                installLoc = frags[i].getEntry("/").toExternalForm();
                if (jarString.startsWith(installLoc)) {
                    sourceURL = this.getSrcFrom(frags[i], installLoc, jarString);
                    break;
                }
                ++i;
            }
        }
        return new URL[]{jarURL, sourceURL};
    }

    private URL getSrcFrom(Bundle bundle, String installLoc, String jarString) {
        Path srcPath = new Path(String.valueOf(bundle.getSymbolicName()) + "_" + (String)bundle.getHeaders("").get("Bundle-Version"));
        if ((srcPath = srcPath.append((IPath)new Path(jarString.substring(installLoc.length())))).segmentCount() < 2) {
            return null;
        }
        srcPath = srcPath.removeFileExtension();
        String jarName = srcPath.lastSegment();
        srcPath = srcPath.removeLastSegments(1).append(String.valueOf(jarName) + "src.zip");
        IConfigurationElement[] ces = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.core.source");
        int i = 0;
        while (i < ces.length) {
            IPath srcsrch = new Path(ces[i].getAttributeAsIs("path")).append((IPath)srcPath);
            Bundle srcBundle = Platform.getBundle((String)ces[i].getDeclaringExtension().getContributor().getName());
            URL srcUrl = FileLocator.find((Bundle)srcBundle, (IPath)srcsrch, null);
            if (srcUrl != null) {
                return srcUrl;
            }
            ++i;
        }
        return null;
    }

    public static interface IProxyPluginShutdownListener {
        public void shutdown();
    }

    public static class FoundIDs {
        public Map containerIds = new HashMap(2);
        public Map containers = new HashMap(2);
        public Map pluginIds;
        public Map projects = new HashMap(2);

        FoundIDs() {
        }
    }

    static interface IPDEProcessForPlugin {
        public void findPlugins(IJavaProject var1, FoundIDs var2, boolean var3, boolean var4);
    }
}

