/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.util;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.Logger;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class PHPDocBlockSerialezer {
    private static PHPDocBlockSerialezer instance;
    private static final String DOCBLOCK_START = "/**";
    private static final String DOCBLOCK_END = " */";
    private static final String CENTERED_ASTERISK = " * ";
    private static final String RIGHT_ASTERISK = " *";
    private static Pattern pattern;
    private static String lineDelimiter;

    static {
        pattern = Pattern.compile("\n");
        lineDelimiter = "";
    }

    public static PHPDocBlockSerialezer instance() {
        if (instance == null) {
            instance = new PHPDocBlockSerialezer();
        }
        return instance;
    }

    private PHPDocBlockSerialezer() {
    }

    public String createDocBlockText(IStructuredDocument iStructuredDocument, PHPDocBlock pHPDocBlock, int n, boolean bl) {
        String string;
        if (!lineDelimiter.equals(iStructuredDocument.getLineDelimiter())) {
            lineDelimiter = iStructuredDocument.getLineDelimiter();
            pattern = Pattern.compile(lineDelimiter);
        }
        String string2 = this.getPreInertionPointWhiteSpaces((IDocument)iStructuredDocument, n);
        String string3 = this.createTagsText(pHPDocBlock, string2);
        StringBuffer stringBuffer = new StringBuffer();
        if (pHPDocBlock.getType() == 0) {
            stringBuffer.append(lineDelimiter);
            stringBuffer.append(string2);
        }
        stringBuffer.append(DOCBLOCK_START);
        stringBuffer.append(lineDelimiter);
        if (!pHPDocBlock.getShortDescription().equals("")) {
            stringBuffer.append(string2);
            stringBuffer.append(CENTERED_ASTERISK);
            stringBuffer.append(pHPDocBlock.getShortDescription());
            stringBuffer.append(lineDelimiter);
            stringBuffer.append(string2);
            stringBuffer.append(RIGHT_ASTERISK);
            stringBuffer.append(lineDelimiter);
        }
        if (!(string = pHPDocBlock.getLongDescription().replaceAll(pattern.pattern(), String.valueOf(lineDelimiter) + string2 + CENTERED_ASTERISK)).equals("")) {
            stringBuffer.append(string2);
            stringBuffer.append(CENTERED_ASTERISK);
            stringBuffer.append(string);
            stringBuffer.append(lineDelimiter);
            stringBuffer.append(string2);
            stringBuffer.append(RIGHT_ASTERISK);
            stringBuffer.append(lineDelimiter);
        }
        stringBuffer.append(string3);
        stringBuffer.append(string2);
        stringBuffer.append(DOCBLOCK_END);
        if (bl) {
            stringBuffer.append(lineDelimiter);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String createTagsText(PHPDocBlock pHPDocBlock, String string) {
        Iterator iterator = pHPDocBlock.getTags();
        String string2 = "";
        while (iterator != null && iterator.hasNext()) {
            PHPDocTag pHPDocTag = (PHPDocTag)iterator.next();
            string2 = String.valueOf(string2) + string + CENTERED_ASTERISK + pHPDocTag.toString() + lineDelimiter;
        }
        return string2;
    }

    private String getPreInertionPointWhiteSpaces(IDocument iDocument, int n) {
        try {
            int n2;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n3 = n2 = iRegion.getOffset();
            while (n3 < n) {
                if (!Character.isWhitespace(iDocument.getChar(n3))) break;
                ++n3;
            }
            return iDocument.get(n2, n3 - n2);
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return "";
        }
    }
}

