/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.breakpoint.property;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.php.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.debug.ui.Logger;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class PHPBreakpointPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private boolean conditionEnabled;
    private Text text;
    private PHPConditionalBreakpoint breakpoint;
    static /* synthetic */ Class class$0;

    public PHPBreakpointPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite composite) {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.debug.core.model.PHPConditionalBreakpoint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.breakpoint = (PHPConditionalBreakpoint)iAdaptable.getAdapter((Class)clazz);
        if (this.breakpoint == null) {
            Logger.log(4, "Could not adapt to PHPConditionalBreakpoint");
            return null;
        }
        this.conditionEnabled = this.breakpoint.isConditionEnabled();
        String string = this.breakpoint.getCondition();
        if (string.equals("")) {
            this.conditionEnabled = true;
        }
        Label label = new Label(composite, 64);
        label.setText(MessageFormat.format(PHPDebugUIMessages.EnterCondition_1, new Object[0]));
        GridData gridData = new GridData(772);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)gridData);
        label.setFont(composite.getFont());
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setText(string);
        final Button button = new Button(composite, 32);
        gridData = new GridData(768);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        button.setLayoutData((Object)gridData);
        button.setFont(composite.getFont());
        button.setText(MessageFormat.format(PHPDebugUIMessages.EnableSetCondition_1, new Object[0]));
        button.setSelection(this.conditionEnabled);
        this.text.setEnabled(this.conditionEnabled);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPBreakpointPropertyPage.this.conditionEnabled = button.getSelection();
                PHPBreakpointPropertyPage.this.text.setEnabled(PHPBreakpointPropertyPage.this.conditionEnabled);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        return composite;
    }

    public boolean performOk() {
        if (this.breakpoint != null) {
            String string = this.text.getText().trim();
            if (string.equals("")) {
                this.conditionEnabled = false;
            }
            try {
                this.breakpoint.setConditionWithEnable(this.conditionEnabled, string);
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
        }
        return super.performOk();
    }
}

