/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.jdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;

public final class RenameEnumConstProcessor
extends RenameFieldProcessor {
    private static final String ID_RENAME_ENUM_CONSTANT = "org.eclipse.jdt.ui.rename.enum.constant";
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameEnumConstProcessor";

    public RenameEnumConstProcessor(IField field) {
        super(field);
    }

    public String canEnableGetterRenaming() throws CoreException {
        return "";
    }

    public String canEnableSetterRenaming() throws CoreException {
        return "";
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        RefactoringStatus result = Checks.checkEnumConstantName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.getField(), newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_another_name);
        }
        if (this.getField().getDeclaringType().getField(newName).exists()) {
            result.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_const_already_defined);
        }
        return result;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        Object change = super.createChange(monitor);
        if (change != null) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            IField field = this.getField();
            String project = null;
            IJavaProject javaProject = field.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589826;
            IType declaring = field.getDeclaringType();
            try {
                if (!Flags.isPrivate((int)declaring.getFlags())) {
                    flags |= 4;
                }
                if (declaring.isAnonymous() || declaring.isLocal()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.RenameEnumConstProcessor_descriptor_description_short, this.fField.getElementName());
            String header = Messages.format(RefactoringCoreMessages.RenameEnumConstProcessor_descriptor_description, new String[]{field.getElementName(), JavaElementLabels.getElementLabel(field.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName()});
            String comment = new JavaRefactoringDescriptorComment(this, header).asString();
            JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ID_RENAME_ENUM_CONSTANT, project, description, comment, arguments, flags);
            arguments.put("input", descriptor.elementToHandle((IJavaElement)field));
            arguments.put("name", this.getNewElementName());
            arguments.put("references", Boolean.valueOf(this.fUpdateReferences).toString());
            arguments.put("textual", Boolean.valueOf(this.fUpdateTextualMatches).toString());
            RefactoringDescriptorChange result = new RefactoringDescriptorChange(descriptor, RefactoringCoreMessages.RenameEnumConstProcessor_change_name, new Change[]{change});
            result.markAsSynthetic();
            change = result;
        }
        return change;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameEnumConstRefactoring_name;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String matches;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaElement element;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 8) {
                    return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), ID_RENAME_ENUM_CONSTANT);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fField = (IField)element;
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName(name);
            String references = extended.getAttribute("references");
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
            this.setUpdateReferences(Boolean.valueOf(references));
            matches = extended.getAttribute("textual");
            if (matches == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "textual"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setUpdateTextualMatches(Boolean.valueOf(matches));
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameEnumConstAvailable(this.getField());
    }
}

