/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSModelProviderAction;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.PlatformUI;

public class CommitAction
extends CVSModelProviderAction
implements IPropertyChangeListener {
    public CommitAction(ISynchronizePageConfiguration configuration) {
        super(configuration);
        configuration.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setId("org.eclipse.team.cvs.ui.commit");
        this.setActionDefinitionId("org.eclipse.team.cvs.ui.commit");
    }

    protected String getBundleKeyPrefix() {
        return "WorkspaceCommitAction.";
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        return this.internalIsEnabled(selection);
    }

    private boolean internalIsEnabled(IStructuredSelection selection) {
        int mode = this.getConfiguration().getMode();
        if (mode == 2 || mode == 4) {
            return this.getResourceMappings(selection).length > 0;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.getConfiguration() && event.getProperty() == "org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE") {
            this.setEnabled(this.internalIsEnabled(this.getStructuredSelection()));
        }
    }

    public void execute() {
        final ResourceTraversal[][] traversals = new ResourceTraversal[1][];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        traversals[0] = CommitAction.this.getResourceTraversals(CommitAction.this.getStructuredSelection(), monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handleError((Shell)this.getConfiguration().getSite().getShell(), (Exception)e, null, null);
        }
        catch (InterruptedException interruptedException) {}
        if (traversals[0] != null) {
            Shell shell = this.getConfiguration().getSite().getShell();
            try {
                CommitWizard.run(this.getConfiguration().getSite().getPart(), shell, traversals[0]);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
    }
}

