/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.OverlayIcon;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.ImageManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;
import org.eclipse.team.ui.mapping.SynchronizationLabelProvider;

public abstract class AbstractSynchronizeLabelProvider
implements ILabelProvider {
    private ImageManager localImageManager;

    public Image getImage(Object element) {
        Image base = this.getDelegateImage(element);
        if (this.isDecorationEnabled() && base != null) {
            Image decorateImage;
            base = decorateImage = this.decorateImage(base, element);
        }
        if (this.isIncludeOverlays() && base != null) {
            base = this.addOverlays(base, element);
        }
        return base;
    }

    protected Image decorateImage(Image base, Object element) {
        IDiff node = this.getDiff(element);
        Image decoratedImage = this.getCompareImage(base, node);
        return decoratedImage;
    }

    protected Image getDelegateImage(Object element) {
        ILabelProvider modelLabelProvider = this.getDelegateLabelProvider();
        Image base = modelLabelProvider.getImage(this.internalGetElement(element));
        if (base == null && element instanceof ModelProvider) {
            ModelProvider mp = (ModelProvider)element;
            base = this.getImageManager().getImage(this.getImageDescriptor(mp));
        }
        return base;
    }

    private ImageDescriptor getImageDescriptor(ModelProvider provider) {
        ITeamContentProviderManager manager = TeamUI.getTeamContentProviderManager();
        ITeamContentProviderDescriptor desc = manager.getDescriptor(provider.getId());
        return desc.getImageDescriptor();
    }

    private Object internalGetElement(Object element) {
        if (element instanceof TreePath) {
            TreePath tp = (TreePath)element;
            element = tp.getLastSegment();
        }
        return element;
    }

    private Image getCompareImage(Image base, IDiff node) {
        int compareKind = 0;
        if (node != null) {
            switch (node.getKind()) {
                case 1: {
                    compareKind = 1;
                    break;
                }
                case 2: {
                    compareKind = 2;
                    break;
                }
                case 4: {
                    compareKind = 3;
                }
            }
            if (node instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)node;
                switch (twd.getDirection()) {
                    case 256: {
                        compareKind |= 8;
                        break;
                    }
                    case 512: {
                        compareKind |= 4;
                        break;
                    }
                    case 768: {
                        compareKind |= 4;
                        compareKind |= 8;
                    }
                }
            }
        }
        return this.getImageManager().getImage(base, compareKind);
    }

    public String getText(Object element) {
        String base = this.getDelegateText(element);
        if (this.isSyncInfoInTextEnabled()) {
            return this.decorateText(base, element);
        }
        return base;
    }

    protected String getDelegateText(Object element) {
        ILabelProvider modelLabelProvider = this.getDelegateLabelProvider();
        String base = modelLabelProvider.getText(element = this.internalGetElement(element));
        if ((base == null || base.length() == 0) && element instanceof ModelProvider) {
            ModelProvider provider = (ModelProvider)element;
            base = Utils.getLabel(provider);
        }
        return base;
    }

    protected String decorateText(String base, Object element) {
        IDiff node = this.getDiff(element);
        if (node != null && node.getKind() != 0) {
            String syncKindString = node.toDiffString();
            return NLS.bind((String)TeamUIMessages.AbstractSynchronizationLabelProvider_0, (Object[])new String[]{base, syncKindString});
        }
        return base;
    }

    public void addListener(ILabelProviderListener listener) {
        this.getDelegateLabelProvider().addListener(listener);
    }

    public void dispose() {
        if (this.localImageManager != null) {
            this.localImageManager.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.getDelegateLabelProvider().isLabelProperty(this.internalGetElement(element), property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.getDelegateLabelProvider().removeListener(listener);
    }

    protected boolean isSyncInfoInTextEnabled() {
        return this.isDecorationEnabled() && TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.view_syncinfo_in_label");
    }

    protected abstract ILabelProvider getDelegateLabelProvider();

    protected abstract boolean isDecorationEnabled();

    protected IDiff getDiff(Object element) {
        return null;
    }

    private Image addOverlays(Image base, Object element) {
        int severity;
        if (!this.isIncludeOverlays()) {
            return base;
        }
        ArrayList<ImageDescriptor> overlays = new ArrayList<ImageDescriptor>();
        ArrayList<Integer> locations = new ArrayList<Integer>();
        if (this.isBusy(element)) {
            overlays.add(TeamUIPlugin.getImageDescriptor("ovr/waiting_ovr.gif"));
            locations.add(new Integer(0));
        }
        if (!this.isConflicting(element) && this.hasDecendantConflicts(element)) {
            overlays.add(TeamUIPlugin.getImageDescriptor("ovr/confchg_ov.gif"));
            locations.add(new Integer(3));
        }
        if ((severity = this.getMarkerSeverity(element)) == 2) {
            overlays.add(TeamUIPlugin.getImageDescriptor("ovr/error_co.gif"));
            locations.add(new Integer(2));
        } else if (severity == 1) {
            overlays.add(TeamUIPlugin.getImageDescriptor("ovr/warning_co.gif"));
            locations.add(new Integer(2));
        }
        if (!overlays.isEmpty()) {
            ImageDescriptor[] overlayImages = overlays.toArray(new ImageDescriptor[overlays.size()]);
            int[] locationInts = new int[locations.size()];
            int i = 0;
            while (i < locations.size()) {
                locationInts[i] = (Integer)locations.get(i);
                ++i;
            }
            OverlayIcon overlay = new OverlayIcon(base, overlayImages, locationInts, new Point(base.getBounds().width, base.getBounds().height));
            return this.getImageManager().getImage((ImageDescriptor)overlay);
        }
        return base;
    }

    protected boolean isIncludeOverlays() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getMarkerSeverity(Object element) {
        ResourceMapping mapping = Utils.getResourceMapping(this.internalGetElement(element));
        int result = -1;
        if (mapping == null) return result;
        try {
            IMarker[] markers = mapping.findMarkers("org.eclipse.core.resources.problemmarker", true, null);
            int i = 0;
            while (true) {
                if (i >= markers.length) {
                    return result;
                }
                IMarker marker = markers[i];
                Integer severity = (Integer)marker.getAttribute("severity");
                if (severity != null) {
                    if (severity == 2) {
                        return 2;
                    }
                    if (severity == 1) {
                        result = 1;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return result;
    }

    protected boolean hasDecendantConflicts(Object element) {
        return false;
    }

    private boolean isConflicting(Object element) {
        IDiff node = this.getDiff(element);
        if (node != null && node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            return twd.getDirection() == 768;
        }
        return false;
    }

    protected boolean isBusy(Object element) {
        return false;
    }

    public Font getFont(Object element) {
        if (this.isBusy(this.internalGetElement(element))) {
            return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
        return null;
    }

    private ImageManager getImageManager() {
        ISynchronizationContext context = this.getContext();
        if (context != null) {
            return ImageManager.getImageManager(context);
        }
        if (this.localImageManager == null) {
            this.localImageManager = new ImageManager();
        }
        return this.localImageManager;
    }

    private ISynchronizationContext getContext() {
        if (this instanceof SynchronizationLabelProvider) {
            SynchronizationLabelProvider slp = (SynchronizationLabelProvider)this;
            return slp.getContext();
        }
        return null;
    }
}

