/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.debug.core.Logger;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PHPLaunchUtilities {
    public static final String ID_PHPDebugOutput = "org.eclipse.debug.ui.PHPDebugOutput";
    public static final String ID_PHPBrowserOutput = "org.eclipse.debug.ui.PHPBrowserOutput";
    private static boolean confirm;

    public static void showDebugView() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        if (!preferences.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS)) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (iWorkbenchPage != null) {
                    try {
                        IViewPart iViewPart = iWorkbenchPage.findView(PHPLaunchUtilities.ID_PHPDebugOutput);
                        IViewPart iViewPart2 = iWorkbenchPage.findView(PHPLaunchUtilities.ID_PHPBrowserOutput);
                        boolean bl = false;
                        if (iViewPart == null || !iWorkbenchPage.isPartVisible((IWorkbenchPart)iViewPart)) {
                            bl = true;
                        }
                        if (iViewPart2 != null && iWorkbenchPage.isPartVisible((IWorkbenchPart)iViewPart2)) {
                            bl = false;
                        }
                        if (bl) {
                            iWorkbenchPage.showView(PHPLaunchUtilities.ID_PHPDebugOutput);
                        }
                    }
                    catch (Exception exception) {
                        Logger.logException("Error switching to the Debug Output view", exception);
                    }
                }
            }
        });
    }

    public static boolean checkDebugAllPages(ILaunchConfiguration iLaunchConfiguration, final ILaunch iLaunch) throws CoreException {
        if (PHPDebugPlugin.supportsMultipleDebugAllPages()) {
            return true;
        }
        iLaunch.setAttribute("debugPages", iLaunchConfiguration.getAttribute("debugPages", "debugAllPages"));
        PHPLaunchUtilities.checkAutoRemoveLaunches();
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        boolean bl = false;
        int n = 0;
        while (!bl && n < iLaunchArray.length) {
            ILaunch iLaunch2 = iLaunchArray[n];
            if (iLaunch2 != iLaunch && "debug".equals(iLaunch2.getLaunchMode()) && (PHPLaunchUtilities.isDebugAllPages(iLaunch2) || PHPLaunchUtilities.isStartDebugFrom(iLaunch2))) {
                bl = true;
            }
            ++n;
        }
        n = "debug".equals(iLaunch.getLaunchMode()) ? 1 : 0;
        final boolean bl2 = n != 0 && PHPLaunchUtilities.isDebugAllPages(iLaunch);
        boolean bl3 = n != 0 && PHPLaunchUtilities.isStartDebugFrom(iLaunch);
        final boolean bl4 = bl;
        if ((bl4 || bl2 || bl3) && iLaunchArray.length > 1) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (bl4) {
                        confirm = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Launch Confirmation", (String)"A previous launch with 'Debug All Pages' or 'Start Debug From' attribute was identifed.\nLaunching a new session will terminate and remove the old launch, directing all future debug requests associated with it to the new launch.\nDo you wish to continue and launch a new session?");
                    } else if (bl2) {
                        confirm = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Launch Confirmation", (String)"The requested launch has a 'Debug All Pages' attribute.\nLaunching this type of session will terminate and remove any other previous launches.\nDo you wish to continue and launch the new session?");
                    } else {
                        confirm = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Launch Confirmation", (String)"The requested launch has a 'Start Debug From' attribute.\nLaunching this type of session will terminate and remove any other previous launches.\nDo you wish to continue and launch the new session?");
                    }
                    if (confirm) {
                        PHPDebugPlugin.setDisableAutoRemoveLaunches(true);
                        PHPLaunchUtilities.removeAndTerminateOldLaunches(iLaunch);
                    } else {
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
                    }
                }
            });
            return confirm;
        }
        if (bl2 || bl3) {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(true);
        } else {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(!PHPDebugPlugin.getDefault().getInitialAutoRemoveLaunches());
            DebugUIPlugin.getDefault().getLaunchConfigurationManager().launchAdded(iLaunch);
        }
        return true;
    }

    private static void checkAutoRemoveLaunches() {
        if (DebugPlugin.getDefault().getLaunchManager().getLaunches().length == 1) {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(false);
        }
    }

    public static boolean isDebugAllPages(ILaunch iLaunch) throws CoreException {
        String string = iLaunch.getAttribute("debugPages");
        return string != null && string.equals("debugAllPages");
    }

    public static boolean isStartDebugFrom(ILaunch iLaunch) throws CoreException {
        String string = iLaunch.getAttribute("debugPages");
        return string != null && string.equals("debugFrom");
    }

    private static void removeAndTerminateOldLaunches(ILaunch iLaunch) {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = iLaunchManager.getLaunches();
        int n = 0;
        while (n < iLaunchArray.length) {
            ILaunch iLaunch2 = iLaunchArray[n];
            if (iLaunch2 != iLaunch) {
                if (!iLaunch2.isTerminated()) {
                    try {
                        iLaunch2.terminate();
                    }
                    catch (DebugException debugException) {
                        Logger.logException(debugException);
                    }
                }
                iLaunchManager.removeLaunch(iLaunch2);
            }
            ++n;
        }
    }
}

