/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.php.debug.core.debugger.Breakpoint;
import org.eclipse.php.debug.core.model.PHPLineBreakpoint;

public class PHPRunToLineBreakpoint
extends PHPLineBreakpoint {
    private IFile fSourceFile;

    public PHPRunToLineBreakpoint(final IFile iFile, final int n) throws DebugException {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                PHPRunToLineBreakpoint.this.fSourceFile = iFile;
                IMarker iMarker = ResourcesPlugin.getWorkspace().getRoot().createMarker("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker");
                iMarker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                iMarker.setAttribute("lineNumber", n);
                iMarker.setAttribute("org.eclipse.debug.core.id", (Object)PHPRunToLineBreakpoint.this.getModelIdentifier());
                PHPRunToLineBreakpoint.this.setMarker(iMarker);
                PHPRunToLineBreakpoint.this.setRegistered(false);
                PHPRunToLineBreakpoint.this.setPersisted(false);
            }
        };
        this.run(this.getMarkerRule((IResource)iFile), iWorkspaceRunnable);
    }

    protected void createRuntimeBreakpoint(IMarker iMarker) throws CoreException {
        IFile iFile = this.getSourceFile();
        IPath iPath = iFile.getFullPath();
        String string = iPath.lastSegment();
        Integer n = (Integer)iMarker.getAttribute("lineNumber");
        this.fBreakpoint = new Breakpoint(string, n);
        this.fBreakpoint.setLifeTime(1);
    }

    public boolean isRunToLineBreakpoint() {
        return true;
    }

    public IFile getSourceFile() {
        return this.fSourceFile;
    }
}

