/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.filters.SelectFiltersAction;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;

public class FilterActionGroup
extends ActionGroup {
    private SelectFiltersAction selectFiltersAction;
    private CommonViewer commonViewer;
    private INavigatorViewerDescriptor viewerDescriptor;
    private final Set filterShortcutActions = new LinkedHashSet();

    public FilterActionGroup(CommonViewer aCommonViewer) {
        Assert.isNotNull((Object)((Object)aCommonViewer));
        this.commonViewer = aCommonViewer;
        this.viewerDescriptor = this.commonViewer.getNavigatorContentService().getViewerDescriptor();
        this.makeActions();
    }

    public void fillActionBars(IActionBars actionBars) {
        IMenuManager menu = actionBars.getMenuManager();
        if (this.selectFiltersAction != null) {
            Iterator iter = this.filterShortcutActions.iterator();
            while (iter.hasNext()) {
                IAction action = (IAction)iter.next();
                menu.insertAfter("additions", action);
            }
            menu.insertAfter("additions", (IAction)this.selectFiltersAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
    }

    private void makeActions() {
        boolean hideAvailableCustomizationsDialog = this.viewerDescriptor.getBooleanConfigProperty("org.eclipse.ui.navigator.hideAvailableCustomizationsDialog");
        if (!hideAvailableCustomizationsDialog) {
            this.selectFiltersAction = new SelectFiltersAction(this.commonViewer, this);
            ImageDescriptor selectFiltersIcon = NavigatorPlugin.getImageDescriptor("icons/full/elcl16/filter_ps.gif");
            this.selectFiltersAction.setImageDescriptor(selectFiltersIcon);
            this.selectFiltersAction.setHoverImageDescriptor(selectFiltersIcon);
        }
    }

    protected void updateFilterShortcuts() {
    }
}

