/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.document;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistryReader;

public class HTMLDocumentTypeRegistry {
    private static HTMLDocumentTypeRegistry instance = null;
    private Hashtable entries = new Hashtable();
    private HTMLDocumentTypeEntry defaultEntry = null;
    private HTMLDocumentTypeEntry defaultXHTMLEntry = null;
    private HTMLDocumentTypeEntry defaultWMLEntry = null;
    private HTMLDocumentTypeEntry defaultCHTMLEntry = null;
    static final int DEFAULT_HTML = 0;
    static final int DEFAULT_XHTML = 1;
    static final int DEFAULT_WML = 2;
    static final int DEFAULT_CHTML = 3;
    public static final String CHTML_PUBLIC_ID = "-//W3C//DTD Compact HTML 1.0 Draft//EN";

    private HTMLDocumentTypeRegistry() {
        String name = "HTML";
        String publicId = "-//W3C//DTD HTML 4.01 Transitional//EN";
        String displayName = "HTML 4.01 Transitional";
        this.defaultEntry = new HTMLDocumentTypeEntry(name, publicId, null, null, false, false, displayName, false, false, false);
        this.entries.put(publicId, this.defaultEntry);
        publicId = "-//W3C//DTD HTML 4.01//EN";
        displayName = "HTML 4.01 Strict";
        this.entries.put(publicId, new HTMLDocumentTypeEntry(name, publicId, null, null, false, false, displayName, false, false, false));
        publicId = "-//W3C//DTD HTML 4.01 Frameset//EN";
        displayName = "HTML 4.01 Frameset";
        this.entries.put(publicId, new HTMLDocumentTypeEntry(name, publicId, null, null, false, true, displayName, false, false, false));
        name = "HTML";
        publicId = CHTML_PUBLIC_ID;
        displayName = "Compact HTML 1.0 Draft";
        this.defaultCHTMLEntry = new HTMLDocumentTypeEntry(name, publicId, null, null, false, false, displayName, false, false, false);
        this.entries.put(publicId, this.defaultCHTMLEntry);
        HTMLDocumentTypeRegistryReader reader = new HTMLDocumentTypeRegistryReader();
        if (reader != null) {
            reader.readRegistry(this);
        }
    }

    void regist(String pid, HTMLDocumentTypeEntry doctype) {
        if (pid == null || doctype == null) {
            return;
        }
        this.entries.put(pid, doctype);
        if (this.defaultXHTMLEntry == null && doctype.isDefaultXHTML()) {
            this.defaultXHTMLEntry = doctype;
        }
        if (this.defaultWMLEntry == null && doctype.isDefaultWML()) {
            this.defaultWMLEntry = doctype;
        }
    }

    public HTMLDocumentTypeEntry getDefaultEntry(int type) {
        HTMLDocumentTypeEntry entry = null;
        switch (type) {
            case 1: {
                entry = this.defaultXHTMLEntry;
                break;
            }
            case 2: {
                entry = this.defaultWMLEntry;
                break;
            }
            case 3: {
                entry = this.defaultCHTMLEntry;
                break;
            }
            default: {
                entry = this.defaultEntry;
            }
        }
        return entry;
    }

    public HTMLDocumentTypeEntry getDefaultEntry() {
        return this.defaultEntry;
    }

    public HTMLDocumentTypeEntry getXHTMLDefaultEntry() {
        return this.defaultXHTMLEntry;
    }

    public Enumeration getEntries() {
        return this.entries.elements();
    }

    public HTMLDocumentTypeEntry getEntry(String publicId) {
        if (publicId == null) {
            return null;
        }
        return (HTMLDocumentTypeEntry)this.entries.get(publicId);
    }

    public static synchronized HTMLDocumentTypeRegistry getInstance() {
        if (instance == null) {
            instance = new HTMLDocumentTypeRegistry();
        }
        return instance;
    }
}

