/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.debug;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.debug.BreakpointRulerAction;

public class ManageBreakpointAction
extends BreakpointRulerAction {
    protected IBreakpoint[] breakpoints = null;
    private boolean doEnable = true;

    public ManageBreakpointAction(ITextEditor editor, IVerticalRuler rulerInfo) {
        super(editor, (IVerticalRulerInfo)rulerInfo);
        this.setEnabled(true);
    }

    protected void disableBreakpoints(IBreakpoint[] breakpoints) {
        int i = 0;
        while (i < breakpoints.length) {
            try {
                breakpoints[i].setEnabled(false);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            ++i;
        }
    }

    protected void enableBreakpoints(IBreakpoint[] breakpoints) {
        int i = 0;
        while (i < breakpoints.length) {
            try {
                breakpoints[i].setEnabled(true);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            ++i;
        }
    }

    public void run() {
        if (this.doEnable) {
            this.enableBreakpoints(this.breakpoints);
        } else {
            this.disableBreakpoints(this.breakpoints);
        }
    }

    public void update() {
        this.doEnable = true;
        this.breakpoints = this.getBreakpoints(this.getMarkers());
        int i = 0;
        while (this.doEnable && i < this.breakpoints.length) {
            IBreakpoint breakpoint = this.breakpoints[i];
            try {
                if (breakpoint.isEnabled()) {
                    this.doEnable = false;
                }
            }
            catch (CoreException e) {
                Logger.logException("breakpoint not responding to isEnabled: " + breakpoint, e);
            }
            ++i;
        }
        this.setEnabled(this.breakpoints != null && this.breakpoints.length > 0);
        if (this.doEnable) {
            this.setText(SSEUIMessages.ManageBreakpointAction_0);
        } else {
            this.setText(SSEUIMessages.ManageBreakpointAction_1);
        }
    }
}

