/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.preferences;

import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.preferences.AbstractDebugPreferencesPageAddon;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.preferences.EncodingSettings;
import org.osgi.service.prefs.BackingStoreException;

public class PHPDebugPreferencesProjectAddon
extends AbstractDebugPreferencesPageAddon {
    private Button fStopAtFirstLine;
    private Text fDebugTextBox;
    private Text fDefaultURLTextBox;
    private EncodingSettings fEncodingSettings;
    private PropertyPage propertyPage;

    public void setCompositeAddon(Composite composite) {
        Composite composite2 = this.addPageContents(composite);
        this.addProjectPreferenceSubsection(this.createSubsection(composite2, PHPDebugUIMessages.PhpDebugPreferencePage_6));
    }

    public void initializeValues(PropertyPage propertyPage) {
        int n;
        IEclipsePreferences iEclipsePreferences;
        this.propertyPage = propertyPage;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes(propertyPage);
        boolean bl = preferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
        int n2 = preferences.getInt(PHPDebugCorePreferenceNames.DEBUG_PORT);
        String string = preferences.getString(PHPDebugCorePreferenceNames.DEDAULT_URL);
        String string2 = preferences.getString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        if (iScopeContextArray[0] instanceof ProjectScope && (iEclipsePreferences = iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier())) != null && this.getProject(propertyPage) != null && (n = iEclipsePreferences.getInt(PHPDebugCorePreferenceNames.DEBUG_PORT, 0)) != 0) {
            n2 = n;
            bl = iEclipsePreferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, bl);
            string = iEclipsePreferences.get(PHPDebugCorePreferenceNames.DEDAULT_URL, string);
            string2 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, "");
        }
        this.fStopAtFirstLine.setSelection(bl);
        this.fDebugTextBox.setText(Integer.toString(n2));
        this.fDefaultURLTextBox.setText(string);
        this.fEncodingSettings.setIANATag(string2);
    }

    public boolean performOK(boolean bl) {
        this.savePreferences(bl);
        return true;
    }

    public void performApply(boolean bl) {
        this.performOK(bl);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        this.fStopAtFirstLine.setSelection(preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE));
        this.fDebugTextBox.setText(Integer.toString(preferences.getDefaultInt(PHPDebugCorePreferenceNames.DEBUG_PORT)));
        this.fDefaultURLTextBox.setText(preferences.getDefaultString(PHPDebugCorePreferenceNames.DEDAULT_URL));
        this.fEncodingSettings.setIANATag(preferences.getDefaultString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING));
    }

    protected String getPreferenceNodeQualifier() {
        return PHPProjectPreferences.getPreferenceNodeQualifier();
    }

    private void addProjectPreferenceSubsection(Composite composite) {
        this.fStopAtFirstLine = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_1, PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, 0);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_3, PHPDebugCorePreferenceNames.DEBUG_PORT);
        this.fDebugTextBox = this.addDebugPortTextField(composite, PHPDebugCorePreferenceNames.DEBUG_PORT, 6, 2);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_9, PHPDebugCorePreferenceNames.DEDAULT_URL);
        this.fDefaultURLTextBox = this.addDefaultURLTextField(composite, PHPDebugCorePreferenceNames.DEDAULT_URL, 0, 2);
        this.fEncodingSettings = this.addEncodingSettings(composite, "Debug Transfer Encoding");
    }

    private EncodingSettings addEncodingSettings(Composite composite, String string) {
        EncodingSettings encodingSettings = new EncodingSettings(composite, "Debug Transfer Encoding");
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        encodingSettings.setLayoutData((Object)gridData);
        return encodingSettings;
    }

    private Text addDebugPortTextField(Composite composite, String string, int n, int n2) {
        Text text = new Text(composite, 2052);
        text.setData((Object)string);
        GridData gridData = new GridData();
        if (n != 0) {
            text.setTextLimit(n);
        }
        gridData.horizontalIndent = n2;
        gridData.horizontalSpan = 2;
        text.setLayoutData((Object)gridData);
        text.addModifyListener((ModifyListener)new DebugPortValidateListener());
        return text;
    }

    private Text addDefaultURLTextField(Composite composite, String string, int n, int n2) {
        Text text = new Text(composite, 2052);
        text.setData((Object)string);
        GridData gridData = new GridData();
        if (n != 0) {
            text.setTextLimit(n);
        }
        gridData.horizontalIndent = n2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.minimumWidth = 300;
        text.setLayoutData((Object)gridData);
        return text;
    }

    private void savePreferences(boolean bl) {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes(this.propertyPage);
        IEclipsePreferences iEclipsePreferences = iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier());
        if (bl && iEclipsePreferences != null && iScopeContextArray[0] instanceof ProjectScope && this.getProject(this.propertyPage) != null) {
            iEclipsePreferences.putBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            iEclipsePreferences.putInt(PHPDebugCorePreferenceNames.DEBUG_PORT, Integer.parseInt(this.fDebugTextBox.getText()));
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.DEDAULT_URL, this.fDefaultURLTextBox.getText());
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fEncodingSettings.getIANATag());
        } else if (this.getProject(this.propertyPage) == null) {
            preferences.setValue(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            preferences.setValue(PHPDebugCorePreferenceNames.DEBUG_PORT, this.fDebugTextBox.getText());
            preferences.setValue(PHPDebugCorePreferenceNames.DEDAULT_URL, this.fDefaultURLTextBox.getText());
            preferences.setValue(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fEncodingSettings.getIANATag());
        } else if (iEclipsePreferences != null) {
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.DEBUG_PORT);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.DEDAULT_URL);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        }
        try {
            iEclipsePreferences.flush();
            PHPDebugPlugin.getDefault().savePluginPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.logException((Throwable)backingStoreException);
        }
    }

    class DebugPortValidateListener
    implements ModifyListener {
        DebugPortValidateListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            String string = null;
            boolean bl = true;
            String string2 = ((Text)modifyEvent.widget).getText();
            try {
                Integer n = new Integer(string2);
                int n2 = n;
                if (n2 < 0) {
                    bl = false;
                    string = PHPDebugUIMessages.PhpDebugPreferencePage_4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                string = PHPDebugUIMessages.PhpDebugPreferencePage_4;
            }
            catch (Exception exception) {
                bl = false;
                string = PHPDebugUIMessages.PhpDebugPreferencePage_4;
            }
            this.setErrorMessage(string);
            this.setValid(bl);
        }

        private void setValid(boolean bl) {
            if (PHPDebugPreferencesProjectAddon.this.propertyPage != null) {
                PHPDebugPreferencesProjectAddon.this.propertyPage.setValid(bl);
            }
        }

        private void setErrorMessage(String string) {
            if (PHPDebugPreferencesProjectAddon.this.propertyPage != null) {
                PHPDebugPreferencesProjectAddon.this.propertyPage.setErrorMessage(string);
            }
        }
    }
}

