/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.daemon;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.debug.daemon.communication.CommunicationDaemonRegistry;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.osgi.framework.BundleContext;

public class DaemonPlugin
extends Plugin {
    public static final String ID = "org.eclipse.php.debug.daemon";
    private static final int INTERNAL_ERROR = 10001;
    public static final boolean isDebugMode;
    private static DaemonPlugin plugin;
    private ICommunicationDaemon[] daemons;

    static {
        String string = Platform.getDebugOption((String)"org.eclipse.php.debug.daemon/debug");
        isDebugMode = string != null && string.equalsIgnoreCase("true");
    }

    public DaemonPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.daemons = CommunicationDaemonRegistry.getBestMatchCommunicationDaemons();
        if (this.daemons != null) {
            int n = 0;
            while (n < this.daemons.length) {
                this.daemons[n].init();
                this.daemons[n].startListen();
                ++n;
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
        if (this.daemons != null) {
            int n = 0;
            while (n < this.daemons.length) {
                this.daemons[n].stopListen();
                ++n;
            }
        }
        this.daemons = null;
    }

    public static String getID() {
        return ID;
    }

    public static DaemonPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus iStatus) {
        DaemonPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        DaemonPlugin.log((IStatus)new Status(4, ID, 10001, "Debug Daemon plugin internal error", throwable));
    }

    public static void logErrorMessage(String string) {
        DaemonPlugin.log((IStatus)new Status(4, ID, 10001, string, null));
    }
}

