/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.xml.sax.Attributes;

public class Generator {
    private ServletWriter out;
    private MethodsBuffer methodsBuffer;
    private ErrorDispatcher err;
    private BeanRepository beanInfo;
    private JspCompilationContext ctxt;
    private boolean breakAtLF;
    private PageInfo pageInfo;
    private int maxTagNesting;
    private Vector tagHandlerPoolNames;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Object;

    private static String quote(String s) {
        if (s == null) {
            return "null";
        }
        return '\"' + Generator.escape(s) + '\"';
    }

    private static String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            if (c == '\\') {
                b.append('\\').append('\\');
                continue;
            }
            if (c == '\n') {
                b.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                b.append('\\').append('r');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private void generateDeclarations(Node.Nodes page) throws JasperException {
        this.out.println();
        class DeclarationVisitor
        extends Node.Visitor {
            DeclarationVisitor() {
            }

            public void visit(Node.PageDirective n) throws JasperException {
                String info = n.getAttributeValue("info");
                if (info == null) {
                    return;
                }
                Generator.this.out.printil("public String getServletInfo() {");
                Generator.this.out.pushIndent();
                Generator.this.out.printin("return ");
                Generator.this.out.print(Generator.quote(info));
                Generator.this.out.println(";");
                Generator.this.out.popIndent();
                Generator.this.out.print('}');
                Generator.this.out.println();
            }

            public void visit(Node.Declaration n) throws JasperException {
                Generator.this.out.printMultiLn(new String(n.getText()));
                Generator.this.out.println();
            }
        }
        page.visit(new DeclarationVisitor());
    }

    private void compileTagHandlerPoolList(Node.Nodes page) throws JasperException {
        class TagHandlerPoolVisitor
        extends Node.Visitor {
            private Vector names;

            TagHandlerPoolVisitor(Vector v) {
                this.names = v;
            }

            public void visit(Node.CustomTag n) throws JasperException {
                String name = this.createTagHandlerPoolName(n.getPrefix(), n.getShortName(), n.getAttributes());
                n.setTagHandlerPoolName(name);
                if (!this.names.contains(name)) {
                    this.names.add(name);
                }
                this.visitBody(n);
            }

            private String createTagHandlerPoolName(String prefix, String shortName, Attributes attrs) {
                String poolName = null;
                if (prefix.indexOf(45) >= 0) {
                    prefix = JspUtil.replace(prefix, '-', "$1");
                }
                if (prefix.indexOf(46) >= 0) {
                    prefix = JspUtil.replace(prefix, '.', "$2");
                }
                if (shortName.indexOf(45) >= 0) {
                    shortName = JspUtil.replace(shortName, '-', "$1");
                }
                if (shortName.indexOf(46) >= 0) {
                    shortName = JspUtil.replace(shortName, '.', "$2");
                }
                if (shortName.indexOf(58) >= 0) {
                    shortName = JspUtil.replace(shortName, ':', "$3");
                }
                poolName = "_jspx_tagPool_" + prefix + "_" + shortName;
                if (attrs != null) {
                    int i;
                    String[] attrNames = new String[attrs.getLength()];
                    for (i = 0; i < attrNames.length; ++i) {
                        attrNames[i] = attrs.getQName(i);
                    }
                    Arrays.sort(attrNames, Collections.reverseOrder());
                    for (i = 0; i < attrNames.length; ++i) {
                        poolName = poolName + "_" + attrNames[i];
                    }
                }
                return poolName;
            }
        }
        page.visit(new TagHandlerPoolVisitor(this.tagHandlerPoolNames));
    }

    private void declareTemporaryScriptingVars(Node.Nodes page) throws JasperException {
        class ScriptingVarVisitor
        extends Node.Visitor {
            private Vector vars = new Vector();

            ScriptingVarVisitor() {
            }

            public void visit(Node.CustomTag n) throws JasperException {
                if (n.getCustomNestingLevel() > 0) {
                    TagVariableInfo[] tagVarInfos = n.getTagVariableInfos();
                    VariableInfo[] varInfos = n.getVariableInfos();
                    if (varInfos != null) {
                        for (int i = 0; i < varInfos.length; ++i) {
                            String varName = varInfos[i].getVarName();
                            String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                            if (this.vars.contains(tmpVarName)) continue;
                            this.vars.add(tmpVarName);
                            Generator.this.out.printin(varInfos[i].getClassName());
                            Generator.this.out.print(" ");
                            Generator.this.out.print(tmpVarName);
                            Generator.this.out.print(" = ");
                            Generator.this.out.print(null);
                            Generator.this.out.println(";");
                        }
                    } else if (tagVarInfos != null) {
                        for (int i = 0; i < tagVarInfos.length; ++i) {
                            String tmpVarName;
                            String varName = tagVarInfos[i].getNameGiven();
                            if (varName == null) {
                                varName = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                            }
                            if (this.vars.contains(tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel())) continue;
                            this.vars.add(tmpVarName);
                            Generator.this.out.printin(tagVarInfos[i].getClassName());
                            Generator.this.out.print(" ");
                            Generator.this.out.print(tmpVarName);
                            Generator.this.out.print(" = ");
                            Generator.this.out.print(null);
                            Generator.this.out.println(";");
                        }
                    }
                }
                this.visitBody(n);
            }
        }
        page.visit(new ScriptingVarVisitor());
    }

    private void generateDestroy() {
        if (this.tagHandlerPoolNames.size() <= 0) {
            return;
        }
        this.out.printil("public void _jspDestroy() {");
        this.out.pushIndent();
        for (int i = 0; i < this.tagHandlerPoolNames.size(); ++i) {
            this.out.printin((String)this.tagHandlerPoolNames.elementAt(i));
            this.out.println(".release();");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void generatePreamble(Node.Nodes page) throws JasperException {
        String servletPackageName = this.ctxt.getServletPackageName();
        String servletClassName = this.ctxt.getServletClassName();
        String serviceMethodName = "_jspService";
        if (!"".equals(servletPackageName) && servletPackageName != null) {
            this.out.printil("package " + servletPackageName + ";");
            this.out.println();
        }
        Iterator iter = this.pageInfo.getImports().iterator();
        while (iter.hasNext()) {
            this.out.printin("import ");
            this.out.print((String)iter.next());
            this.out.println(";");
        }
        this.out.println();
        this.out.printin("public class ");
        this.out.print(servletClassName);
        this.out.print(" extends ");
        this.out.print(this.pageInfo.getExtends());
        if (!this.pageInfo.isThreadSafe()) {
            this.out.print(" implements SingleThreadModel");
        }
        this.out.println(" {");
        this.out.pushIndent();
        this.generateDeclarations(page);
        this.out.println();
        this.out.printil("private static java.util.Vector _jspx_includes;");
        this.out.println();
        List includes = this.pageInfo.getIncludes();
        iter = includes.iterator();
        if (!includes.isEmpty()) {
            this.out.printil("static {");
            this.out.pushIndent();
            this.out.printin("_jspx_includes = new java.util.Vector(");
            this.out.print("" + includes.size());
            this.out.println(");");
            while (iter.hasNext()) {
                this.out.printin("_jspx_includes.add(\"");
                this.out.print((String)iter.next());
                this.out.println("\");");
            }
            this.out.popIndent();
            this.out.printil("}");
            this.out.println();
        }
        if (this.ctxt.getOptions().isPoolingEnabled() && !this.tagHandlerPoolNames.isEmpty()) {
            for (int i = 0; i < this.tagHandlerPoolNames.size(); ++i) {
                this.out.printil("private org.apache.jasper.runtime.TagHandlerPool " + this.tagHandlerPoolNames.elementAt(i) + ";");
            }
            this.out.println();
        }
        if (this.ctxt.getOptions().isPoolingEnabled() && !this.tagHandlerPoolNames.isEmpty()) {
            this.generateServletConstructor(servletClassName);
        }
        this.out.printil("public java.util.List getIncludes() {");
        this.out.pushIndent();
        this.out.printil("return _jspx_includes;");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        if (this.ctxt.getOptions().isPoolingEnabled() && !this.tagHandlerPoolNames.isEmpty()) {
            this.generateDestroy();
        }
        this.out.printin("public void ");
        this.out.print(serviceMethodName);
        this.out.println("(HttpServletRequest request, HttpServletResponse response)");
        this.out.println("        throws java.io.IOException, ServletException {");
        this.out.pushIndent();
        this.out.println();
        this.out.printil("JspFactory _jspxFactory = null;");
        this.out.printil("javax.servlet.jsp.PageContext pageContext = null;");
        if (this.pageInfo.isSession()) {
            this.out.printil("HttpSession session = null;");
        }
        if (this.pageInfo.isIsErrorPage()) {
            this.out.printil("Throwable exception = (Throwable) request.getAttribute(\"javax.servlet.jsp.jspException\");");
        }
        this.out.printil("ServletContext application = null;");
        this.out.printil("ServletConfig config = null;");
        this.out.printil("JspWriter out = null;");
        this.out.printil("Object page = this;");
        this.maxTagNesting = this.pageInfo.getMaxTagNesting();
        this.out.printil("JspWriter _jspx_out = null;");
        this.out.println();
        this.declareTemporaryScriptingVars(page);
        this.out.println();
        this.out.printil("try {");
        this.out.pushIndent();
        this.out.printil("_jspxFactory = JspFactory.getDefaultFactory();");
        this.out.printin("response.setContentType(");
        this.out.print(Generator.quote(this.pageInfo.getContentType()));
        this.out.println(");");
        this.out.printil("pageContext = _jspxFactory.getPageContext(this, request, response,");
        this.out.printin("\t\t\t");
        this.out.print(Generator.quote(this.pageInfo.getErrorPage()));
        this.out.print(", " + this.pageInfo.isSession());
        this.out.print(", " + this.pageInfo.getBuffer());
        this.out.print(", " + this.pageInfo.isAutoFlush());
        this.out.println(");");
        this.out.printil("application = pageContext.getServletContext();");
        this.out.printil("config = pageContext.getServletConfig();");
        if (this.pageInfo.isSession()) {
            this.out.printil("session = pageContext.getSession();");
        }
        this.out.printil("out = pageContext.getOut();");
        this.out.printil("_jspx_out = out;");
        this.out.println();
    }

    private void generateServletConstructor(String servletClassName) {
        this.out.printil("public " + servletClassName + "() {");
        this.out.pushIndent();
        for (int i = 0; i < this.tagHandlerPoolNames.size(); ++i) {
            this.out.printin((String)this.tagHandlerPoolNames.elementAt(i));
            this.out.println(" = new org.apache.jasper.runtime.TagHandlerPool();");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void generateJspState() {
    }

    private void generatePostamble(Node.Nodes page) {
        this.out.popIndent();
        this.out.printil("} catch (Throwable t) {");
        this.out.pushIndent();
        this.out.printil("out = _jspx_out;");
        this.out.printil("if (out != null && out.getBufferSize() != 0)");
        this.out.pushIndent();
        this.out.printil("out.clearBuffer();");
        this.out.popIndent();
        this.out.printil("if (pageContext != null) pageContext.handlePageException(t);");
        this.out.popIndent();
        this.out.printil("} finally {");
        this.out.pushIndent();
        this.out.printil("if (_jspxFactory != null) _jspxFactory.releasePageContext(pageContext);");
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("}");
        this.out.print(this.methodsBuffer.toString());
        if (this.maxTagNesting > 0) {
            this.generateJspState();
        }
        this.out.popIndent();
        this.out.printil("}");
    }

    Generator(ServletWriter out, Compiler compiler) {
        this.out = out;
        this.methodsBuffer = new MethodsBuffer();
        this.err = compiler.getErrorDispatcher();
        this.ctxt = compiler.getCompilationContext();
        this.pageInfo = compiler.getPageInfo();
        this.beanInfo = this.pageInfo.getBeanRepository();
        this.breakAtLF = this.ctxt.getOptions().getMappedFile();
        if (this.ctxt.getOptions().isPoolingEnabled()) {
            this.tagHandlerPoolNames = new Vector();
        }
    }

    public static void generate(ServletWriter out, Compiler compiler, Node.Nodes page) throws JasperException {
        Generator gen = new Generator(out, compiler);
        if (gen.ctxt.getOptions().isPoolingEnabled()) {
            gen.compileTagHandlerPoolList(page);
        }
        gen.generatePreamble(page);
        Generator generator = gen;
        generator.getClass();
        page.visit(generator.new GenerateVisitor(out, gen.methodsBuffer));
        gen.generatePostamble(page);
    }

    static /* synthetic */ String access$500(String x0) {
        return Generator.escape(x0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class GenerateVisitor
    extends Node.Visitor {
        private Hashtable handlerInfos;
        private Hashtable tagVarNumbers;
        private String parent;
        private String pushBodyCountVar;
        private ServletWriter out;
        private MethodsBuffer methodsBuffer;
        private int methodNesting;
        private static final String SINGLE_QUOTE = "'";
        private static final String DOUBLE_QUOTE = "\\\"";
        private static final int CHUNKSIZE = 1024;

        public GenerateVisitor(ServletWriter out, MethodsBuffer methodsBuffer) {
            this.out = out;
            this.methodsBuffer = methodsBuffer;
            this.methodNesting = 0;
            this.handlerInfos = new Hashtable();
            this.tagVarNumbers = new Hashtable();
        }

        private String attributeValue(Node.JspAttribute attr, boolean encode) {
            String v = attr.getValue();
            if (v == null) {
                return "";
            }
            if (attr.isExpression()) {
                if (encode) {
                    return "java.net.URLEncoder.encode(\"\" + " + v + ")";
                }
                return v;
            }
            if (encode) {
                v = URLEncoder.encode(v);
            }
            return Generator.quote(v);
        }

        private void printParams(Node n, Node.JspAttribute page) throws JasperException {
            String sep;
            String pValue = page.getValue();
            if (page.isExpression()) {
                sep = "((" + pValue + ").indexOf('?')>0? '&': '?')";
            } else {
                String string = sep = pValue.indexOf(63) > 0 ? "\"&\"" : "\"?\"";
            }
            if (n.getBody() != null) {
                class ParamVisitor
                extends Node.Visitor {
                    String separator;
                    private final /* synthetic */ GenerateVisitor this$1;

                    ParamVisitor(GenerateVisitor this$1, String separator) {
                        this.this$1 = this$1;
                        this.separator = separator;
                    }

                    public void visit(Node.ParamAction n) throws JasperException {
                        GenerateVisitor.access$200(this.this$1).print(" + ");
                        GenerateVisitor.access$200(this.this$1).print(this.separator);
                        GenerateVisitor.access$200(this.this$1).print(" + \"");
                        GenerateVisitor.access$200(this.this$1).print(n.getAttributeValue("name"));
                        GenerateVisitor.access$200(this.this$1).print("=\" + ");
                        GenerateVisitor.access$200(this.this$1).print(GenerateVisitor.access$300(this.this$1, n.getValue(), true));
                        this.separator = "\"&\"";
                    }
                }
                n.getBody().visit(new ParamVisitor(this, sep));
            }
        }

        public void visit(Node.Expression n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("out.print(" + new String(n.getText()) + ");");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.Scriptlet n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printMultiLn(new String(n.getText()));
            this.out.println();
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.IncludeAction n) throws JasperException {
            String flush = n.getAttributeValue("flush");
            boolean isFlush = false;
            if ("true".equals(flush)) {
                isFlush = true;
            }
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin("JspRuntimeLibrary.include(request, response, ");
            this.out.print(this.attributeValue(n.getPage(), false));
            this.printParams(n, n.getPage());
            this.out.println(", out, " + isFlush + ");");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.ForwardAction n) throws JasperException {
            String page = n.getAttributeValue("page");
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("if (true) {");
            this.out.pushIndent();
            this.out.printin("pageContext.forward(");
            this.out.print(this.attributeValue(n.getPage(), false));
            this.printParams(n, n.getPage());
            this.out.println(");");
            this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
            this.out.popIndent();
            this.out.printil("}");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.GetProperty n) throws JasperException {
            String name = n.getAttributeValue("name");
            String property = n.getAttributeValue("property");
            n.setBeginJavaLine(this.out.getJavaLine());
            if (Generator.this.beanInfo.checkVariable(name)) {
                Class bean = Generator.this.beanInfo.getBeanType(name);
                String beanName = bean.getName();
                Method meth = JspRuntimeLibrary.getReadMethod((Class)bean, (String)property);
                String methodName = meth.getName();
                this.out.printil("out.print(JspRuntimeLibrary.toString((((" + beanName + ")pageContext.findAttribute(" + "\"" + name + "\"))." + methodName + "())));");
            } else {
                this.out.printil("out.print(JspRuntimeLibrary.toString(JspRuntimeLibrary.handleGetProperty(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\")));");
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.SetProperty n) throws JasperException {
            String name = n.getAttributeValue("name");
            String property = n.getAttributeValue("property");
            String param = n.getAttributeValue("param");
            Node.JspAttribute value = n.getValue();
            n.setBeginJavaLine(this.out.getJavaLine());
            if ("*".equals(property)) {
                this.out.printil("JspRuntimeLibrary.introspect(pageContext.findAttribute(\"" + name + "\"), request);");
            } else if (value == null) {
                if (param == null) {
                    param = property;
                }
                this.out.printil("JspRuntimeLibrary.introspecthelper(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\", request.getParameter(\"" + param + "\"), " + "request, \"" + param + "\", false);");
            } else if (value.isExpression()) {
                this.out.printil("JspRuntimeLibrary.handleSetProperty(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\",");
                this.out.print(this.attributeValue(value, false));
                this.out.println(");");
            } else {
                this.out.printil("JspRuntimeLibrary.introspecthelper(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\",");
                this.out.print(this.attributeValue(value, false));
                this.out.println(",null, null, false);");
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.UseBean n) throws JasperException {
            String name = n.getAttributeValue("id");
            String scope = n.getAttributeValue("scope");
            String klass = n.getAttributeValue("class");
            String type = n.getAttributeValue("type");
            Node.JspAttribute beanName = n.getBeanName();
            if (type == null) {
                type = klass;
            }
            String scopename = "PageContext.PAGE_SCOPE";
            String lock = "pageContext";
            if ("request".equals(scope)) {
                scopename = "PageContext.REQUEST_SCOPE";
                lock = "request";
            } else if ("session".equals(scope)) {
                scopename = "PageContext.SESSION_SCOPE";
                lock = "session";
            } else if ("application".equals(scope)) {
                scopename = "PageContext.APPLICATION_SCOPE";
                lock = "application";
            }
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin(type);
            this.out.print(' ');
            this.out.print(name);
            this.out.println(" = null;");
            this.out.printin("synchronized (");
            this.out.print(lock);
            this.out.println(") {");
            this.out.pushIndent();
            this.out.printin(name);
            this.out.print(" = (");
            this.out.print(type);
            this.out.print(") pageContext.getAttribute(");
            this.out.print(Generator.quote(name));
            this.out.print(", ");
            this.out.print(scopename);
            this.out.println(");");
            this.out.printin("if (");
            this.out.print(name);
            this.out.println(" == null){");
            this.out.pushIndent();
            if (klass == null && beanName == null) {
                this.out.printin("throw new java.lang.InstantiationException(\"bean ");
                this.out.print(name);
                this.out.println(" not found within scope\");");
            } else {
                String className = beanName != null ? this.attributeValue(beanName, false) : Generator.quote(klass);
                this.out.printil("try {");
                this.out.pushIndent();
                this.out.printin(name);
                this.out.print(" = (");
                this.out.print(type);
                this.out.print(") java.beans.Beans.instantiate(");
                this.out.print("this.getClass().getClassLoader(), ");
                this.out.print(className);
                this.out.println(");");
                this.out.popIndent();
                this.out.printil("} catch (ClassNotFoundException exc) {");
                this.out.pushIndent();
                this.out.printil("throw new InstantiationException(exc.getMessage());");
                this.out.popIndent();
                this.out.printil("} catch (Exception exc) {");
                this.out.pushIndent();
                this.out.printin("throw new ServletException(");
                this.out.print("\"Cannot create bean of class \" + ");
                this.out.print(className);
                this.out.println(", exc);");
                this.out.popIndent();
                this.out.printil("}");
                this.out.printin("pageContext.setAttribute(");
                this.out.print(Generator.quote(name));
                this.out.print(", ");
                this.out.print(name);
                this.out.print(", ");
                this.out.print(scopename);
                this.out.println(");");
                this.visitBody(n);
            }
            this.out.popIndent();
            this.out.printil("}");
            this.out.popIndent();
            this.out.printil("}");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        private String makeAttr(String attr, String value) {
            if (value == null) {
                return "";
            }
            return " " + attr + "=\"" + value + '\"';
        }

        public void visit(Node.PlugIn n) throws JasperException {
            class ParamVisitor
            extends Node.Visitor {
                private boolean ie;
                private final /* synthetic */ GenerateVisitor this$1;

                ParamVisitor(GenerateVisitor this$1, boolean ie) {
                    this.this$1 = this$1;
                    this.ie = ie;
                }

                public void visit(Node.ParamAction n) throws JasperException {
                    String name = n.getAttributeValue("name");
                    if (name.equalsIgnoreCase("object")) {
                        name = "java_object";
                    } else if (name.equalsIgnoreCase("type")) {
                        name = "java_type";
                    }
                    n.setBeginJavaLine(GenerateVisitor.access$200(this.this$1).getJavaLine());
                    if (this.ie) {
                        GenerateVisitor.access$200(this.this$1).printil("out.write( \"<PARAM name=\\\"" + Generator.access$500(name) + "\\\" value=\\\"\" + " + GenerateVisitor.access$300(this.this$1, n.getValue(), false) + " + \"\\\">\" );");
                        GenerateVisitor.access$200(this.this$1).printil("out.write(\"\\n\");");
                    } else {
                        GenerateVisitor.access$200(this.this$1).printil("out.write( \" " + Generator.access$500(name) + "=\\\"\" + " + GenerateVisitor.access$300(this.this$1, n.getValue(), false) + " + \"\\\"\" );");
                    }
                    n.setEndJavaLine(GenerateVisitor.access$200(this.this$1).getJavaLine());
                }
            }
            String type = n.getAttributeValue("type");
            String code = n.getAttributeValue("code");
            String name = n.getAttributeValue("name");
            Node.JspAttribute height = n.getHeight();
            Node.JspAttribute width = n.getWidth();
            String hspace = n.getAttributeValue("hspace");
            String vspace = n.getAttributeValue("vspace");
            String align = n.getAttributeValue("align");
            String iepluginurl = n.getAttributeValue("iepluginurl");
            String nspluginurl = n.getAttributeValue("nspluginurl");
            String codebase = n.getAttributeValue("codebase");
            String archive = n.getAttributeValue("archive");
            String jreversion = n.getAttributeValue("jreversion");
            if (iepluginurl == null) {
                iepluginurl = "http://java.sun.com/products/plugin/1.2.2/jinstall-1_2_2-win.cab#Version=1,2,2,0";
            }
            if (nspluginurl == null) {
                nspluginurl = "http://java.sun.com/products/plugin/";
            }
            n.setBeginJavaLine(this.out.getJavaLine());
            String s0 = "<OBJECT classid=\"" + Generator.this.ctxt.getOptions().getIeClassId() + "\"" + this.makeAttr("name", name);
            String s1 = width != null ? (width.isExpression() ? Generator.quote(s0 + " width=\"") + " + " + width.getValue() + " + " + Generator.quote("\"") : Generator.quote(s0 + this.makeAttr("width", width.getValue()))) : Generator.quote(s0);
            String s2 = height != null ? (height.isExpression() ? Generator.quote(" height=\"") + " + " + height.getValue() + " + " + Generator.quote("\"") : Generator.quote(this.makeAttr("height", height.getValue()))) : "\"\"";
            String s3 = Generator.quote(this.makeAttr("hspace", hspace) + this.makeAttr("vspace", vspace) + this.makeAttr("align", align) + this.makeAttr("codebase", iepluginurl) + '>');
            this.out.printil("out.println(" + s1 + " + " + s2 + " + " + s3 + ");");
            s0 = "<PARAM name=\"java_code\"" + this.makeAttr("value", code) + '>';
            this.out.printil("out.println(" + Generator.quote(s0) + ");");
            if (codebase != null) {
                s0 = "<PARAM name=\"java_codebase\"" + this.makeAttr("value", codebase) + '>';
                this.out.printil("out.println(" + Generator.quote(s0) + ");");
            }
            if (archive != null) {
                s0 = "<PARAM name=\"java_archive\"" + this.makeAttr("value", archive) + '>';
                this.out.printil("out.println(" + Generator.quote(s0) + ");");
            }
            s0 = "<PARAM name=\"type\"" + this.makeAttr("value", "application/x-java-" + type + ";" + (jreversion == null ? "" : "version=" + jreversion)) + '>';
            this.out.printil("out.println(" + Generator.quote(s0) + ");");
            if (n.getBody() != null) {
                n.getBody().visit(new ParamVisitor(this, true));
            }
            this.out.printil("out.println(" + Generator.quote("<COMMENT>") + ");");
            s0 = "<EMBED" + this.makeAttr("type", "application/x-java-" + type + ";" + (jreversion == null ? "" : "version=" + jreversion)) + this.makeAttr("name", name);
            s1 = width != null ? (width.isExpression() ? Generator.quote(s0 + " width=\"") + " + " + width.getValue() + " + " + Generator.quote("\"") : Generator.quote(s0 + this.makeAttr("width", width.getValue()))) : Generator.quote(s0);
            s2 = height != null ? (height.isExpression() ? Generator.quote(" height=\"") + " + " + height.getValue() + " + " + Generator.quote("\"") : Generator.quote(this.makeAttr("height", height.getValue()))) : "\"\"";
            s3 = Generator.quote(this.makeAttr("hspace", hspace) + this.makeAttr("vspace", vspace) + this.makeAttr("align", align) + this.makeAttr("pluginspage", nspluginurl) + this.makeAttr("java_code", code) + this.makeAttr("java_codebase", codebase) + this.makeAttr("java_archive", archive));
            this.out.printil("out.println(" + s1 + " + " + s2 + " + " + s3 + ");");
            if (n.getBody() != null) {
                n.getBody().visit(new ParamVisitor(this, false));
            }
            this.out.printil("out.println(" + Generator.quote(">") + ");");
            this.out.printil("out.println(" + Generator.quote("<NOEMBED>") + ");");
            this.out.printil("out.println(" + Generator.quote("</COMMENT>") + ");");
            if (n.getBody() != null) {
                this.visitBody(n);
                this.out.printil("out.write(\"\\n\");");
            }
            this.out.printil("out.println(" + Generator.quote("</NOEMBED></EMBED>") + ");");
            this.out.printil("out.println(" + Generator.quote("</OBJECT>") + ");");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.CustomTag n) throws JasperException {
            TagHandlerInfo handlerInfo;
            Hashtable<String, TagHandlerInfo> handlerInfosByShortName = (Hashtable<String, TagHandlerInfo>)this.handlerInfos.get(n.getPrefix());
            if (handlerInfosByShortName == null) {
                handlerInfosByShortName = new Hashtable<String, TagHandlerInfo>();
                this.handlerInfos.put(n.getPrefix(), handlerInfosByShortName);
            }
            if ((handlerInfo = (TagHandlerInfo)handlerInfosByShortName.get(n.getShortName())) == null) {
                handlerInfo = new TagHandlerInfo(n, n.getTagHandlerClass(), Generator.this.err);
                handlerInfosByShortName.put(n.getShortName(), handlerInfo);
            }
            String baseVar = this.createTagVarName(n.getName(), n.getPrefix(), n.getShortName());
            String tagEvalVar = "_jspx_eval_" + baseVar;
            String tagHandlerVar = "_jspx_th_" + baseVar;
            String tagPushBodyCountVar = "_jspx_push_body_count_" + baseVar;
            ServletWriter outSave = null;
            MethodsBuffer methodsBufferSave = null;
            if (n.isScriptless() && !n.hasScriptingVars()) {
                String tagMethod = "_jspx_meth_" + baseVar;
                this.out.printin("if (");
                this.out.print(tagMethod);
                this.out.print("(");
                if (this.parent != null) {
                    this.out.print(this.parent);
                    this.out.print(", ");
                }
                this.out.print("pageContext");
                if (this.pushBodyCountVar != null) {
                    this.out.print(", ");
                    this.out.print(this.pushBodyCountVar);
                }
                this.out.println("))");
                this.out.pushIndent();
                this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
                this.out.popIndent();
                outSave = this.out;
                this.out = this.methodsBuffer.getOut();
                methodsBufferSave = this.methodsBuffer;
                this.methodsBuffer = new MethodsBuffer();
                ++this.methodNesting;
                this.out.println();
                this.out.pushIndent();
                this.out.printin("private boolean ");
                this.out.print(tagMethod);
                this.out.print("(");
                if (this.parent != null) {
                    this.out.print("javax.servlet.jsp.tagext.Tag ");
                    this.out.print(this.parent);
                    this.out.print(", ");
                }
                this.out.print("javax.servlet.jsp.PageContext pageContext");
                if (this.pushBodyCountVar != null) {
                    this.out.print(", int ");
                    this.out.print(this.pushBodyCountVar);
                }
                this.out.println(")");
                this.out.printil("        throws Throwable {");
                this.out.pushIndent();
                this.out.printil("JspWriter out = pageContext.getOut();");
                if (n.isHasUsebean()) {
                    this.out.println("HttpSession session = pageContext.getSession();");
                    this.out.println("ServletContext application = pageContext.getServletContext();");
                }
                if (n.isHasUsebean() || n.isHasIncludeAction() || n.isHasSetProperty()) {
                    this.out.println("HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();");
                }
                if (n.isHasIncludeAction()) {
                    this.out.println("HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();");
                }
            }
            this.generateCustomStart(n, handlerInfo, tagHandlerVar, tagEvalVar, tagPushBodyCountVar);
            String tmpParent = this.parent;
            this.parent = tagHandlerVar;
            String tmpPushBodyCountVar = null;
            if (n.implementsTryCatchFinally()) {
                tmpPushBodyCountVar = this.pushBodyCountVar;
                this.pushBodyCountVar = tagPushBodyCountVar;
            }
            this.visitBody(n);
            this.parent = tmpParent;
            if (n.implementsTryCatchFinally()) {
                this.pushBodyCountVar = tmpPushBodyCountVar;
            }
            this.generateCustomEnd(n, tagHandlerVar, tagEvalVar, tagPushBodyCountVar);
            if (n.isScriptless() && !n.hasScriptingVars()) {
                if (this.methodNesting > 0) {
                    this.out.printil("return false;");
                }
                this.out.popIndent();
                this.out.printil("}");
                this.out.popIndent();
                --this.methodNesting;
                this.out.print(this.methodsBuffer.toString());
                this.methodsBuffer = methodsBufferSave;
                this.out = outSave;
            }
        }

        public void visit(Node.UninterpretedTag n) throws JasperException {
            this.out.printin("out.write(\"<");
            this.out.print(n.getName());
            Attributes attrs = n.getAttributes();
            if (attrs != null) {
                int attrsLength = attrs.getLength();
                for (int i = 0; i < attrsLength; ++i) {
                    String quote = DOUBLE_QUOTE;
                    String value = attrs.getValue(i);
                    if (value.indexOf(34) != -1) {
                        quote = SINGLE_QUOTE;
                    }
                    this.out.print(" ");
                    this.out.print(attrs.getQName(i));
                    this.out.print("=");
                    this.out.print(quote);
                    this.out.print(value);
                    this.out.print(quote);
                }
            }
            if (n.getBody() != null) {
                this.out.println(">\");");
                this.visitBody(n);
                this.out.printin("out.write(\"</");
                this.out.print(n.getName());
                this.out.println(">\");");
            } else {
                this.out.println("/>\");");
            }
        }

        public void visit(Node.TemplateText n) throws JasperException {
            char[] chars = n.getText();
            int size = chars.length;
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin();
            StringBuffer sb = new StringBuffer("out.write(\"");
            int initLength = sb.length();
            int count = 1024;
            block7: for (int i = 0; i < size; ++i) {
                char ch = chars[i];
                --count;
                switch (ch) {
                    case '\"': {
                        sb.append('\\').append('\"');
                        continue block7;
                    }
                    case '\\': {
                        sb.append('\\').append('\\');
                        continue block7;
                    }
                    case '\r': {
                        sb.append('\\').append('r');
                        continue block7;
                    }
                    case '\n': {
                        sb.append('\\').append('n');
                        if (!Generator.this.breakAtLF && count >= 0) continue block7;
                        sb.append("\");");
                        this.out.println(sb.toString());
                        this.out.printin();
                        sb.setLength(initLength);
                        count = 1024;
                        continue block7;
                    }
                    case '\t': {
                        sb.append('\\').append('t');
                        continue block7;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            if (sb.length() > initLength) {
                sb.append("\");");
                this.out.println(sb.toString());
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        private void generateCustomStart(Node.CustomTag n, TagHandlerInfo handlerInfo, String tagHandlerVar, String tagEvalVar, String tagPushBodyCountVar) throws JasperException {
            Class tagHandlerClass = handlerInfo.getTagHandlerClass();
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin("/* ----  ");
            this.out.print(n.getName());
            this.out.println(" ---- */");
            this.declareScriptingVars(n, 1);
            this.saveScriptingVars(n, 1);
            this.out.printin(tagHandlerClass.getName());
            this.out.print(" ");
            this.out.print(tagHandlerVar);
            this.out.print(" = ");
            if (Generator.this.ctxt.getOptions().isPoolingEnabled()) {
                this.out.print("(");
                this.out.print(tagHandlerClass.getName());
                this.out.print(") ");
                this.out.print(n.getTagHandlerPoolName());
                this.out.print(".get(");
                this.out.print(tagHandlerClass.getName());
                this.out.println(".class);");
            } else {
                this.out.print("new ");
                this.out.print(tagHandlerClass.getName());
                this.out.println("();");
            }
            this.generateSetters(n, tagHandlerVar, handlerInfo);
            if (n.implementsTryCatchFinally()) {
                this.out.printin("int ");
                this.out.print(tagPushBodyCountVar);
                this.out.println(" = 0;");
                this.out.printil("try {");
                this.out.pushIndent();
            }
            this.out.printin("int ");
            this.out.print(tagEvalVar);
            this.out.print(" = ");
            this.out.print(tagHandlerVar);
            this.out.println(".doStartTag();");
            if (!n.implementsBodyTag()) {
                this.syncScriptingVars(n, 1);
            }
            if (n.getBody() != null) {
                this.out.printin("if (");
                this.out.print(tagEvalVar);
                this.out.println(" != javax.servlet.jsp.tagext.Tag.SKIP_BODY) {");
                this.out.pushIndent();
                this.declareScriptingVars(n, 0);
                this.saveScriptingVars(n, 0);
                if (n.implementsBodyTag()) {
                    this.out.printin("if (");
                    this.out.print(tagEvalVar);
                    this.out.println(" != javax.servlet.jsp.tagext.Tag.EVAL_BODY_INCLUDE) {");
                    this.out.pushIndent();
                    this.out.printil("javax.servlet.jsp.tagext.BodyContent _bc = pageContext.pushBody();");
                    if (n.implementsTryCatchFinally()) {
                        this.out.printin(tagPushBodyCountVar);
                        this.out.println("++;");
                    } else if (this.pushBodyCountVar != null) {
                        this.out.printin(this.pushBodyCountVar);
                        this.out.println("++;");
                    }
                    this.out.printil("out = _bc;");
                    this.out.printin(tagHandlerVar);
                    this.out.println(".setBodyContent(_bc);");
                    this.out.printin(tagHandlerVar);
                    this.out.println(".doInitBody();");
                    this.out.popIndent();
                    this.out.printil("}");
                    this.syncScriptingVars(n, 1);
                    this.syncScriptingVars(n, 0);
                } else {
                    this.syncScriptingVars(n, 0);
                }
                if (n.implementsIterationTag()) {
                    this.out.printil("do {");
                    this.out.pushIndent();
                }
            }
        }

        private void generateCustomEnd(Node.CustomTag n, String tagHandlerVar, String tagEvalVar, String tagPushBodyCountVar) {
            VariableInfo[] varInfos = n.getVariableInfos();
            TagVariableInfo[] tagVarInfos = n.getTagVariableInfos();
            if (n.getBody() != null) {
                if (n.implementsIterationTag()) {
                    this.out.printin("int evalDoAfterBody = ");
                    this.out.print(tagHandlerVar);
                    this.out.println(".doAfterBody();");
                    this.syncScriptingVars(n, 1);
                    this.syncScriptingVars(n, 0);
                    this.out.printil("if (evalDoAfterBody != javax.servlet.jsp.tagext.BodyTag.EVAL_BODY_AGAIN)");
                    this.out.pushIndent();
                    this.out.printil("break;");
                    this.out.popIndent();
                    this.out.popIndent();
                    this.out.printil("} while (true);");
                }
                this.restoreScriptingVars(n, 0);
                if (n.implementsBodyTag()) {
                    this.out.printin("if (");
                    this.out.print(tagEvalVar);
                    this.out.println(" != javax.servlet.jsp.tagext.Tag.EVAL_BODY_INCLUDE)");
                    this.out.pushIndent();
                    this.out.printil("out = pageContext.popBody();");
                    if (n.implementsTryCatchFinally()) {
                        this.out.printin(tagPushBodyCountVar);
                        this.out.println("--;");
                    } else if (this.pushBodyCountVar != null) {
                        this.out.printin(this.pushBodyCountVar);
                        this.out.println("--;");
                    }
                    this.out.popIndent();
                }
                this.out.popIndent();
                this.out.printil("}");
            }
            this.out.printin("if (");
            this.out.print(tagHandlerVar);
            this.out.println(".doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE)");
            this.out.pushIndent();
            this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
            this.out.popIndent();
            this.syncScriptingVars(n, 1);
            if (n.implementsTryCatchFinally()) {
                this.out.popIndent();
                this.out.printil("} catch (Throwable _jspx_exception) {");
                this.out.pushIndent();
                this.out.printin("while (");
                this.out.print(tagPushBodyCountVar);
                this.out.println("-- > 0)");
                this.out.pushIndent();
                this.out.printil("out = pageContext.popBody();");
                this.out.popIndent();
                this.out.printin(tagHandlerVar);
                this.out.println(".doCatch(_jspx_exception);");
                this.out.popIndent();
                this.out.printil("} finally {");
                this.out.pushIndent();
                this.out.printin(tagHandlerVar);
                this.out.println(".doFinally();");
            }
            if (Generator.this.ctxt.getOptions().isPoolingEnabled()) {
                this.out.printin(n.getTagHandlerPoolName());
                this.out.print(".reuse(");
                this.out.print(tagHandlerVar);
                this.out.println(");");
            }
            if (n.implementsTryCatchFinally()) {
                this.out.popIndent();
                this.out.printil("}");
            }
            this.declareScriptingVars(n, 2);
            this.syncScriptingVars(n, 2);
            this.restoreScriptingVars(n, 1);
            n.setEndJavaLine(this.out.getJavaLine());
        }

        private void declareScriptingVars(Node.CustomTag n, int scope) {
            Vector vec = n.getScriptingVars(scope);
            if (vec != null) {
                for (int i = 0; i < vec.size(); ++i) {
                    Object elem = vec.elementAt(i);
                    if (elem instanceof VariableInfo) {
                        VariableInfo varInfo = (VariableInfo)elem;
                        this.out.printin(varInfo.getClassName());
                        this.out.print(" ");
                        this.out.print(varInfo.getVarName());
                        this.out.println(" = null;");
                        continue;
                    }
                    TagVariableInfo tagVarInfo = (TagVariableInfo)elem;
                    String varName = tagVarInfo.getNameGiven();
                    if (varName == null) {
                        varName = n.getTagData().getAttributeString(tagVarInfo.getNameFromAttribute());
                    }
                    this.out.printin(tagVarInfo.getClassName());
                    this.out.print(" ");
                    this.out.print(varName);
                    this.out.println(" = null;");
                }
            }
        }

        private void saveScriptingVars(Node.CustomTag n, int scope) {
            if (n.getCustomNestingLevel() == 0) {
                return;
            }
            TagVariableInfo[] tagVarInfos = n.getTagVariableInfos();
            VariableInfo[] varInfos = n.getVariableInfos();
            if (varInfos == null && tagVarInfos == null) {
                return;
            }
            if (varInfos != null) {
                for (int i = 0; i < varInfos.length; ++i) {
                    if (varInfos[i].getScope() != scope) continue;
                    String varName = varInfos[i].getVarName();
                    String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                    this.out.printin(tmpVarName);
                    this.out.print(" = ");
                    this.out.print(varName);
                    this.out.println(";");
                }
            } else {
                for (int i = 0; i < tagVarInfos.length; ++i) {
                    if (tagVarInfos[i].getScope() != scope) continue;
                    String varName = tagVarInfos[i].getNameGiven();
                    if (varName == null) {
                        varName = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                    }
                    String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                    this.out.printin(tmpVarName);
                    this.out.print(" = ");
                    this.out.print(varName);
                    this.out.println(";");
                }
            }
        }

        private void restoreScriptingVars(Node.CustomTag n, int scope) {
            if (n.getCustomNestingLevel() == 0) {
                return;
            }
            TagVariableInfo[] tagVarInfos = n.getTagVariableInfos();
            VariableInfo[] varInfos = n.getVariableInfos();
            if (varInfos == null && tagVarInfos == null) {
                return;
            }
            if (varInfos != null) {
                for (int i = 0; i < varInfos.length; ++i) {
                    if (varInfos[i].getScope() != scope) continue;
                    String varName = varInfos[i].getVarName();
                    String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                    this.out.printin(varName);
                    this.out.print(" = ");
                    this.out.print(tmpVarName);
                    this.out.println(";");
                }
            } else {
                for (int i = 0; i < tagVarInfos.length; ++i) {
                    if (tagVarInfos[i].getScope() != scope) continue;
                    String varName = tagVarInfos[i].getNameGiven();
                    if (varName == null) {
                        varName = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                    }
                    String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                    this.out.printin(varName);
                    this.out.print(" = ");
                    this.out.print(tmpVarName);
                    this.out.println(";");
                }
            }
        }

        private void syncScriptingVars(Node.CustomTag n, int scope) {
            TagVariableInfo[] tagVarInfos = n.getTagVariableInfos();
            VariableInfo[] varInfos = n.getVariableInfos();
            if (varInfos == null && tagVarInfos == null) {
                return;
            }
            if (varInfos != null) {
                for (int i = 0; i < varInfos.length; ++i) {
                    if (varInfos[i].getScope() != scope) continue;
                    this.out.printin(varInfos[i].getVarName());
                    this.out.print(" = (");
                    this.out.print(varInfos[i].getClassName());
                    this.out.print(") pageContext.findAttribute(");
                    this.out.print(Generator.quote(varInfos[i].getVarName()));
                    this.out.println(");");
                }
            } else {
                for (int i = 0; i < tagVarInfos.length; ++i) {
                    if (tagVarInfos[i].getScope() != scope) continue;
                    String name = tagVarInfos[i].getNameGiven();
                    if (name == null) {
                        name = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                    }
                    this.out.printin(name);
                    this.out.print(" = (");
                    this.out.print(tagVarInfos[i].getClassName());
                    this.out.print(") pageContext.findAttribute(");
                    this.out.print(Generator.quote(name));
                    this.out.println(");");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String createTagVarName(String fullName, String prefix, String shortName) {
            if (prefix.indexOf(45) >= 0) {
                prefix = JspUtil.replace(prefix, '-', "$1");
            }
            if (prefix.indexOf(46) >= 0) {
                prefix = JspUtil.replace(prefix, '.', "$2");
            }
            if (shortName.indexOf(45) >= 0) {
                shortName = JspUtil.replace(shortName, '-', "$1");
            }
            if (shortName.indexOf(46) >= 0) {
                shortName = JspUtil.replace(shortName, '.', "$2");
            }
            if (shortName.indexOf(58) >= 0) {
                shortName = JspUtil.replace(shortName, ':', "$3");
            }
            Hashtable hashtable = this.tagVarNumbers;
            synchronized (hashtable) {
                String varName = prefix + "_" + shortName + "_";
                if (this.tagVarNumbers.get(fullName) != null) {
                    Integer i = (Integer)this.tagVarNumbers.get(fullName);
                    varName = varName + i;
                    this.tagVarNumbers.put(fullName, new Integer(i + 1));
                    return varName;
                }
                this.tagVarNumbers.put(fullName, new Integer(1));
                return varName + "0";
            }
        }

        private void generateSetters(Node.CustomTag n, String tagHandlerVar, TagHandlerInfo handlerInfo) throws JasperException {
            this.out.printin(tagHandlerVar);
            this.out.println(".setPageContext(pageContext);");
            this.out.printin(tagHandlerVar);
            this.out.print(".setParent(");
            this.out.print(this.parent);
            this.out.println(");");
            Node.JspAttribute[] attrs = n.getJspAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                String attrValue = attrs[i].getValue();
                if (attrValue == null) continue;
                String attrName = attrs[i].getName();
                Method m = handlerInfo.getSetterMethod(attrName);
                if (m == null) {
                    Generator.this.err.jspError(n, "jsp.error.unable.to_find_method", attrName);
                }
                Class<?>[] c = m.getParameterTypes();
                if (!attrs[i].isExpression()) {
                    attrValue = this.convertString(c[0], attrValue, attrName, handlerInfo.getPropertyEditorClass(attrName));
                }
                this.out.printin(tagHandlerVar);
                this.out.print(".");
                this.out.print(m.getName());
                this.out.print("(");
                this.out.print(attrValue);
                this.out.println(");");
            }
        }

        private String convertString(Class c, String s, String attrName, Class propEditorClass) throws JasperException {
            if (propEditorClass != null) {
                return "(" + c.getName() + ")JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(" + c.getName() + ".class, \"" + attrName + "\", " + Generator.quote(s) + ", " + propEditorClass.getName() + ".class)";
            }
            if (c == (class$java$lang$String == null ? (class$java$lang$String = Generator.class$("java.lang.String")) : class$java$lang$String)) {
                return Generator.quote(s);
            }
            if (c == Boolean.TYPE) {
                return Boolean.valueOf(s).toString();
            }
            if (c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Generator.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return "new Boolean(" + Boolean.valueOf(s).toString() + ")";
            }
            if (c == Byte.TYPE) {
                return "((byte)" + Byte.valueOf(s).toString() + ")";
            }
            if (c == (class$java$lang$Byte == null ? (class$java$lang$Byte = Generator.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return "new Byte((byte)" + Byte.valueOf(s).toString() + ")";
            }
            if (c == Character.TYPE) {
                if (s.length() > 0) {
                    char ch = s.charAt(0);
                    return "((char) " + ch + ")";
                }
                throw new NumberFormatException(Generator.this.err.getString("jsp.error.bad_string_char"));
            }
            if (c == (class$java$lang$Character == null ? (class$java$lang$Character = Generator.class$("java.lang.Character")) : class$java$lang$Character)) {
                if (s.length() > 0) {
                    char ch = s.charAt(0);
                    return "new Character((char) " + ch + ")";
                }
                throw new NumberFormatException(Generator.this.err.getString("jsp.error.bad_string_Character"));
            }
            if (c == Double.TYPE) {
                return Double.valueOf(s).toString();
            }
            if (c == (class$java$lang$Double == null ? (class$java$lang$Double = Generator.class$("java.lang.Double")) : class$java$lang$Double)) {
                return "new Double(" + Double.valueOf(s).toString() + ")";
            }
            if (c == Float.TYPE) {
                return Float.valueOf(s).toString() + "f";
            }
            if (c == (class$java$lang$Float == null ? (class$java$lang$Float = Generator.class$("java.lang.Float")) : class$java$lang$Float)) {
                return "new Float(" + Float.valueOf(s).toString() + "f)";
            }
            if (c == Integer.TYPE) {
                return Integer.valueOf(s).toString();
            }
            if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = Generator.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return "new Integer(" + Integer.valueOf(s).toString() + ")";
            }
            if (c == Short.TYPE) {
                return "((short) " + Short.valueOf(s).toString() + ")";
            }
            if (c == (class$java$lang$Short == null ? (class$java$lang$Short = Generator.class$("java.lang.Short")) : class$java$lang$Short)) {
                return "new Short(" + Short.valueOf(s).toString() + ")";
            }
            if (c == Long.TYPE) {
                return Long.valueOf(s).toString() + "l";
            }
            if (c == (class$java$lang$Long == null ? (class$java$lang$Long = Generator.class$("java.lang.Long")) : class$java$lang$Long)) {
                return "new Long(" + Long.valueOf(s).toString() + "l)";
            }
            if (c == (class$java$lang$Object == null ? (class$java$lang$Object = Generator.class$("java.lang.Object")) : class$java$lang$Object)) {
                return "new String(" + Generator.quote(s) + ")";
            }
            return "(" + c.getName() + ")JspRuntimeLibrary.getValueFromPropertyEditorManager(" + c.getName() + ".class, \"" + attrName + "\", " + Generator.quote(s) + ")";
        }

        static /* synthetic */ ServletWriter access$200(GenerateVisitor x0) {
            return x0.out;
        }

        static /* synthetic */ String access$300(GenerateVisitor x0, Node.JspAttribute x1, boolean x2) {
            return x0.attributeValue(x1, x2);
        }
    }

    private static class MethodsBuffer {
        private CharArrayWriter charWriter = new CharArrayWriter();
        private ServletWriter out = new ServletWriter(new PrintWriter(this.charWriter));

        MethodsBuffer() {
        }

        public ServletWriter getOut() {
            return this.out;
        }

        public String toString() {
            return this.charWriter.toString();
        }
    }

    private static class TagHandlerInfo {
        private Hashtable methodMaps;
        private Hashtable propertyEditorMaps;
        private Class tagHandlerClass;

        TagHandlerInfo(Node n, Class tagHandlerClass, ErrorDispatcher err) throws JasperException {
            this.tagHandlerClass = tagHandlerClass;
            this.methodMaps = new Hashtable();
            this.propertyEditorMaps = new Hashtable();
            try {
                BeanInfo tagClassInfo = Introspector.getBeanInfo(tagHandlerClass);
                PropertyDescriptor[] pd = tagClassInfo.getPropertyDescriptors();
                for (int i = 0; i < pd.length; ++i) {
                    if (pd[i].getWriteMethod() != null) {
                        this.methodMaps.put(pd[i].getName(), pd[i].getWriteMethod());
                    }
                    if (pd[i].getPropertyEditorClass() == null) continue;
                    this.propertyEditorMaps.put(pd[i].getName(), pd[i].getPropertyEditorClass());
                }
            }
            catch (IntrospectionException ie) {
                err.jspError(n, "jsp.error.introspect.taghandler", tagHandlerClass.getName(), ie);
            }
        }

        public Method getSetterMethod(String attrName) {
            return (Method)this.methodMaps.get(attrName);
        }

        public Class getPropertyEditorClass(String attrName) {
            return (Class)this.propertyEditorMaps.get(attrName);
        }

        public Class getTagHandlerClass() {
            return this.tagHandlerClass;
        }
    }
}

