/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.apt.Filer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.env.BinaryFileOutputStream;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;
import org.eclipse.jdt.apt.core.internal.env.EncodedFileOutputStream;
import org.eclipse.jdt.apt.core.internal.env.JavaSourceFilePrintWriter;
import org.eclipse.jdt.apt.core.internal.env.NoOpOutputStream;
import org.eclipse.jdt.apt.core.internal.env.NoOpPrintWriter;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.core.JavaModelException;

public class FilerImpl
implements Filer {
    private BuildEnv _env;
    private boolean _generatedClassFiles = false;

    public FilerImpl(BuildEnv env) {
        this._env = env;
    }

    public PrintWriter createSourceFile(String typeName) throws IOException {
        if (typeName == null) {
            throw new IllegalArgumentException("Type name cannot be null");
        }
        if ("".equals(typeName)) {
            throw new IllegalArgumentException("Type name cannot be empty");
        }
        this._env.checkValid();
        return new JavaSourceFilePrintWriter(typeName, new StringWriter(), this._env);
    }

    public OutputStream createClassFile(String typeName) throws IOException {
        IPath path;
        if (typeName == null) {
            throw new IllegalArgumentException("Type name cannot be null");
        }
        if ("".equals(typeName)) {
            throw new IllegalArgumentException("Type name cannot be empty");
        }
        this._env.checkValid();
        this._generatedClassFiles = true;
        if (this._env.getPhase() == Phase.RECONCILE) {
            return new NoOpOutputStream();
        }
        GeneratedSourceFolderManager gsfm = this._env.getAptProject().getGeneratedSourceFolderManager();
        try {
            path = gsfm.getBinaryOutputLocation();
        }
        catch (Exception e) {
            AptPlugin.log(e, "Failure getting the output file");
            throw new IOException();
        }
        path = path.append(String.valueOf(typeName.replace('.', File.separatorChar)) + ".class");
        IFile file = this._env.getProject().getFile(path);
        return new BinaryFileOutputStream(file, this._env);
    }

    public boolean hasGeneratedClassFile() {
        return this._generatedClassFiles;
    }

    public PrintWriter createTextFile(Filer.Location loc, String pkg, File relPath, String charsetName) throws IOException {
        if (relPath == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if ("".equals(relPath.getPath())) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        this._env.checkValid();
        if (this._env.getPhase() == Phase.RECONCILE) {
            return new NoOpPrintWriter();
        }
        IPath path = this.getOutputFileForLocation(loc, pkg, relPath);
        IFile file = this._env.getProject().getFile(path);
        EncodedFileOutputStream binaryOut = new EncodedFileOutputStream(file, this._env, charsetName);
        if (charsetName == null) {
            return new PrintWriter(binaryOut);
        }
        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)binaryOut, charsetName);
        return new PrintWriter(outWriter);
    }

    public OutputStream createBinaryFile(Filer.Location loc, String pkg, File relPath) throws IOException {
        if (relPath == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if ("".equals(relPath.getPath())) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        this._env.checkValid();
        if (this._env.getPhase() == Phase.RECONCILE) {
            return new NoOpOutputStream();
        }
        IPath path = this.getOutputFileForLocation(loc, pkg, relPath);
        IFile file = this._env.getProject().getFile(path);
        return new BinaryFileOutputStream(file, this._env);
    }

    private IPath getOutputFileForLocation(Filer.Location loc, String pkg, File relPath) throws IOException {
        GeneratedSourceFolderManager gsfm = this._env.getAptProject().getGeneratedSourceFolderManager();
        IPath path = null;
        if (loc == Filer.Location.CLASS_TREE) {
            try {
                path = gsfm.getBinaryOutputLocation();
            }
            catch (JavaModelException e) {
                AptPlugin.log(e, "Failure getting the output file");
                throw new IOException();
            }
        } else if (loc == Filer.Location.SOURCE_TREE) {
            path = gsfm.getFolder().getProjectRelativePath();
        }
        if (pkg != null) {
            path = path.append(pkg.replace('.', File.separatorChar));
        }
        path = path.append(relPath.getPath());
        IPath absolutePath = this._env.getProject().getLocation().append(path);
        File parentFile = absolutePath.toFile().getParentFile();
        FileSystemUtil.mkdirs(parentFile);
        return path;
    }
}

