/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeTextInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.Theme;

public class DrawData {
    public int style;
    public int[] state = new int[1];
    public Rectangle clientArea;
    public static final int SELECTED = 2;
    public static final int FOCUSED = 4;
    public static final int PRESSED = 8;
    public static final int ACTIVE = 16;
    public static final int DISABLED = 32;
    public static final int HOT = 64;
    public static final int DEFAULTED = 128;
    public static final int GRAYED = 256;
    public static final int DRAW_LEFT = 16;
    public static final int DRAW_TOP = 32;
    public static final int DRAW_RIGHT = 64;
    public static final int DRAW_BOTTOM = 128;
    public static final int DRAW_HCENTER = 256;
    public static final int DRAW_VCENTER = 512;
    public static final int WIDGET_NOWHERE = -1;
    public static final int WIDGET_WHOLE = 0;
    public static final int SCROLLBAR_UP_ARROW = 1;
    public static final int SCROLLBAR_DOWN_ARROW = 2;
    public static final int SCROLLBAR_LEFT_ARROW = 1;
    public static final int SCROLLBAR_RIGHT_ARROW = 2;
    public static final int SCROLLBAR_UP_TRACK = 3;
    public static final int SCROLLBAR_DOWN_TRACK = 4;
    public static final int SCROLLBAR_LEFT_TRACK = 3;
    public static final int SCROLLBAR_RIGHT_TRACK = 4;
    public static final int SCROLLBAR_THUMB = 5;
    public static final int SCALE_UP_TRACK = 1;
    public static final int SCALE_LEFT_TRACK = 1;
    public static final int SCALE_DOWN_TRACK = 2;
    public static final int SCALE_RIGHT_TRACK = 2;
    public static final int SCALE_THUMB = 3;
    public static final int TOOLITEM_ARROW = 1;
    public static final int COMBO_ARROW = 1;

    Rectangle computeTrim(Theme theme, GC gc) {
        return new Rectangle(this.clientArea.x, this.clientArea.y, this.clientArea.width, this.clientArea.height);
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
    }

    void drawImage(Theme theme, Image image, GC gc, Rectangle bounds) {
        Image drawImage = image;
        Rectangle rect = drawImage.getBounds();
        int state = this.state[0];
        if (OS.VERSION >= 4160 && (state & 0x28) != 0) {
            int transform = 0;
            if ((state & 0x20) != 0) {
                transform = 1;
            } else if ((state & 8) != 0) {
                transform = 16384;
            }
            if (transform != 0) {
                int[] buffer = new int[1];
                OS.HICreateTransformedCGImage(drawImage.handle, transform, buffer);
                if (buffer[0] != 0) {
                    drawImage = Image.carbon_new(null, drawImage.type, buffer[0], 0);
                }
            }
        }
        gc.drawImage(drawImage, 0, 0, rect.width, rect.height, bounds.x, bounds.y, bounds.width, bounds.height);
        if (drawImage != image) {
            drawImage.dispose();
        }
    }

    void drawText(Theme theme, String text, int flags, GC gc, Rectangle bounds) {
        int state = this.state[0];
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        int ptr = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        OS.CGContextSaveGState(gc.handle);
        if ((state & 0x20) != 0) {
            OS.CGContextSetFillColor(gc.handle, new float[]{0.5f, 0.5f, 0.5f, 1.0f});
        } else if ((state & 0x10) != 0) {
            OS.CGContextSetFillColor(gc.handle, new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        } else {
            OS.CGContextSetFillColor(gc.handle, new float[]{0.6f, 0.6f, 0.6f, 1.0f});
        }
        CGRect rect = new CGRect();
        rect.x = bounds.x;
        rect.y = bounds.y;
        rect.width = bounds.width;
        rect.height = bounds.height;
        HIThemeTextInfo info = this.getTextInfo(flags);
        OS.HIThemeDrawTextBox(ptr, rect, info, gc.handle, 0);
        OS.CGContextRestoreGState(gc.handle);
        OS.CFRelease(ptr);
    }

    Rectangle getBounds(int part, Rectangle bounds) {
        return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    int getFontId() {
        return 1;
    }

    HIThemeTextInfo getTextInfo(int flags) {
        int state = this.state[0];
        HIThemeTextInfo info = new HIThemeTextInfo();
        info.state = (state & 8) != 0 ? 2 : ((state & 0x10) != 0 ? ((state & 0x20) == 0 ? 1 : 7) : ((state & 0x20) == 0 ? 0 : 8));
        info.state = info.state;
        info.fontID = (short)this.getFontId();
        if ((flags & 0x10) != 0) {
            info.horizontalFlushness = 0;
        }
        if ((flags & 0x100) != 0) {
            info.horizontalFlushness = 1;
        }
        if ((flags & 0x40) != 0) {
            info.horizontalFlushness = 2;
        }
        if ((flags & 0x20) != 0) {
            info.verticalFlushness = 0;
        }
        if ((flags & 0x200) != 0) {
            info.verticalFlushness = 1;
        }
        if ((flags & 0x80) != 0) {
            info.verticalFlushness = 2;
        }
        info.truncationMaxLines = 0;
        info.truncationPosition = 0;
        info.options = 0;
        return info;
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return -1;
    }

    Rectangle measureText(Theme theme, String text, int flags, GC gc, Rectangle bounds) {
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        int ptr = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        int width = bounds != null ? bounds.width : 0;
        float[] outWidth = new float[1];
        float[] outHeight = new float[1];
        HIThemeTextInfo info = this.getTextInfo(flags);
        OS.HIThemeGetTextDimensions(ptr, width, info, outWidth, outHeight, null);
        OS.CFRelease(ptr);
        return new Rectangle(0, 0, (int)outWidth[0], (int)outHeight[0]);
    }
}

