/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.format.htmlFormatters;

import org.eclipse.php.core.documentModel.dom.PHPElementImpl;
import org.eclipse.php.core.format.PhpFormatter;
import org.eclipse.php.core.format.htmlFormatters.EmbeddedCSSFormatterNoPHP;
import org.eclipse.php.core.format.htmlFormatters.HTMLElementFormatterNoPHP;
import org.eclipse.php.core.format.htmlFormatters.HTMLFormatterNoPHP;
import org.eclipse.php.core.format.htmlFormatters.HTMLTextFormatterNoPHP;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.w3c.dom.Node;

public class HTMLFormatterNoPHPFactory {
    private static HTMLFormatterNoPHPFactory fInstance = null;
    public int start;
    public int length;

    public static synchronized HTMLFormatterNoPHPFactory getInstance() {
        if (fInstance == null) {
            fInstance = new HTMLFormatterNoPHPFactory();
        }
        return fInstance;
    }

    public IStructuredFormatter createFormatter(Node node, IStructuredFormatPreferences iStructuredFormatPreferences) {
        Object object = null;
        switch (node.getNodeType()) {
            case 1: {
                if (node instanceof PHPElementImpl) {
                    object = new PhpFormatter(this.start, this.length);
                    break;
                }
                object = new HTMLElementFormatterNoPHP();
                break;
            }
            case 3: {
                if (this.isEmbeddedCSS(node)) {
                    object = new EmbeddedCSSFormatterNoPHP();
                    break;
                }
                if (node.getParentNode() != null && node.getParentNode() instanceof PHPElementImpl) {
                    object = new PhpFormatter(this.start, this.length);
                    break;
                }
                object = new HTMLTextFormatterNoPHP();
                break;
            }
            default: {
                object = new HTMLFormatterNoPHP();
            }
        }
        object.setFormatPreferences(iStructuredFormatPreferences);
        return object;
    }

    private boolean isEmbeddedCSS(Node node) {
        if (node == null) {
            return false;
        }
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return false;
        }
        if (node2.getNodeType() != 1) {
            return false;
        }
        String string = node2.getNodeName();
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("STYLE");
    }
}

